/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import java.util.Arrays;
import java.util.concurrent.Callable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryPlayer
implements IInventory {
    public final ItemStack[] mainInventory = new ItemStack[36];
    public final ItemStack[] armorInventory = new ItemStack[4];
    public final ItemStack[] field_184439_c = new ItemStack[1];
    private final ItemStack[][] field_184440_g = new ItemStack[][]{this.mainInventory, this.armorInventory, this.field_184439_c};
    public int currentItem;
    public EntityPlayer player;
    private ItemStack itemStack;
    public boolean inventoryChanged;

    public InventoryPlayer(EntityPlayer playerIn) {
        this.player = playerIn;
    }

    public ItemStack getCurrentItem() {
        return InventoryPlayer.func_184435_e(this.currentItem) ? this.mainInventory[this.currentItem] : null;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private boolean func_184436_a(ItemStack p_184436_1_, ItemStack p_184436_2_) {
        return p_184436_1_ != null && this.func_184431_b(p_184436_1_, p_184436_2_) && p_184436_1_.isStackable() && p_184436_1_.stackSize < p_184436_1_.getMaxStackSize() && p_184436_1_.stackSize < this.getInventoryStackLimit();
    }

    private boolean func_184431_b(ItemStack p_184431_1_, ItemStack p_184431_2_) {
        return p_184431_1_.getItem() == p_184431_2_.getItem() && (!p_184431_1_.getHasSubtypes() || p_184431_1_.getMetadata() == p_184431_2_.getMetadata()) && ItemStack.areItemStackTagsEqual(p_184431_1_, p_184431_2_);
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public void func_184434_a(ItemStack p_184434_1_) {
        int i = this.func_184429_b(p_184434_1_);
        if (InventoryPlayer.func_184435_e(i)) {
            this.currentItem = i;
        } else if (i == -1) {
            int j;
            this.currentItem = this.func_184433_k();
            if (this.mainInventory[this.currentItem] != null && (j = this.getFirstEmptyStack()) != -1) {
                this.mainInventory[j] = this.mainInventory[this.currentItem];
            }
            this.mainInventory[this.currentItem] = p_184434_1_;
        } else {
            this.func_184430_d(i);
        }
    }

    public void func_184430_d(int p_184430_1_) {
        this.currentItem = this.func_184433_k();
        ItemStack itemstack = this.mainInventory[this.currentItem];
        this.mainInventory[this.currentItem] = this.mainInventory[p_184430_1_];
        this.mainInventory[p_184430_1_] = itemstack;
    }

    public static boolean func_184435_e(int p_184435_0_) {
        return p_184435_0_ >= 0 && p_184435_0_ < 9;
    }

    public int func_184429_b(ItemStack p_184429_1_) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null || !this.func_184431_b(p_184429_1_, this.mainInventory[i])) continue;
            return i;
        }
        return -1;
    }

    public int func_184433_k() {
        for (int i = 0; i < 9; ++i) {
            int j = (this.currentItem + i) % 9;
            if (this.mainInventory[j] != null) continue;
            return j;
        }
        for (int k = 0; k < 9; ++k) {
            int l = (this.currentItem + k) % 9;
            if (this.mainInventory[l].isItemEnchanted()) continue;
            return l;
        }
        return this.currentItem;
    }

    public void changeCurrentItem(int direction) {
        if (direction > 0) {
            direction = 1;
        }
        if (direction < 0) {
            direction = -1;
        }
        this.currentItem -= direction;
        while (this.currentItem < 0) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9) {
            this.currentItem -= 9;
        }
    }

    public int clearMatchingItems(Item itemIn, int metadataIn, int removeCount, NBTTagCompound itemNBT) {
        int i = 0;
        for (int j = 0; j < this.getSizeInventory(); ++j) {
            ItemStack itemstack = this.getStackInSlot(j);
            if (itemstack == null || itemIn != null && itemstack.getItem() != itemIn || metadataIn > -1 && itemstack.getMetadata() != metadataIn || itemNBT != null && !NBTUtil.func_181123_a(itemNBT, itemstack.getTagCompound(), true)) continue;
            int k = removeCount <= 0 ? itemstack.stackSize : Math.min(removeCount - i, itemstack.stackSize);
            i += k;
            if (removeCount == 0) continue;
            itemstack.stackSize -= k;
            if (itemstack.stackSize == 0) {
                this.setInventorySlotContents(j, null);
            }
            if (removeCount <= 0 || i < removeCount) continue;
            return i;
        }
        if (this.itemStack != null) {
            if (itemIn != null && this.itemStack.getItem() != itemIn) {
                return i;
            }
            if (metadataIn > -1 && this.itemStack.getMetadata() != metadataIn) {
                return i;
            }
            if (itemNBT != null && !NBTUtil.func_181123_a(itemNBT, this.itemStack.getTagCompound(), true)) {
                return i;
            }
            int l = removeCount <= 0 ? this.itemStack.stackSize : Math.min(removeCount - i, this.itemStack.stackSize);
            i += l;
            if (removeCount != 0) {
                this.itemStack.stackSize -= l;
                if (this.itemStack.stackSize == 0) {
                    this.itemStack = null;
                }
                if (removeCount > 0 && i >= removeCount) {
                    return i;
                }
            }
        }
        return i;
    }

    private int storePartialItemStack(ItemStack itemStackIn) {
        Item item = itemStackIn.getItem();
        int i = itemStackIn.stackSize;
        int j = this.storeItemStack(itemStackIn);
        if (j == -1) {
            j = this.getFirstEmptyStack();
        }
        if (j == -1) {
            return i;
        }
        ItemStack itemstack = this.getStackInSlot(j);
        if (itemstack == null) {
            itemstack = new ItemStack(item, 0, itemStackIn.getMetadata());
            if (itemStackIn.hasTagCompound()) {
                itemstack.setTagCompound((NBTTagCompound)itemStackIn.getTagCompound().copy());
            }
            this.setInventorySlotContents(j, itemstack);
        }
        int k = i;
        if (i > itemstack.getMaxStackSize() - itemstack.stackSize) {
            k = itemstack.getMaxStackSize() - itemstack.stackSize;
        }
        if (k > this.getInventoryStackLimit() - itemstack.stackSize) {
            k = this.getInventoryStackLimit() - itemstack.stackSize;
        }
        if (k == 0) {
            return i;
        }
        itemstack.stackSize += k;
        itemstack.animationsToGo = 5;
        return i -= k;
    }

    private int storeItemStack(ItemStack itemStackIn) {
        if (this.func_184436_a(this.getStackInSlot(this.currentItem), itemStackIn)) {
            return this.currentItem;
        }
        if (this.func_184436_a(this.getStackInSlot(40), itemStackIn)) {
            return 40;
        }
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (!this.func_184436_a(this.mainInventory[i], itemStackIn)) continue;
            return i;
        }
        return -1;
    }

    public void decrementAnimations() {
        for (int i = 0; i < this.field_184440_g.length; ++i) {
            ItemStack[] aitemstack = this.field_184440_g[i];
            for (int j = 0; j < aitemstack.length; ++j) {
                if (aitemstack[j] == null) continue;
                aitemstack[j].updateAnimation(this.player.worldObj, this.player, j, this.currentItem == j);
            }
        }
    }

    public boolean addItemStackToInventory(final ItemStack itemStackIn) {
        if (itemStackIn != null && itemStackIn.stackSize != 0 && itemStackIn.getItem() != null) {
            try {
                int i;
                if (itemStackIn.isItemDamaged()) {
                    int j = this.getFirstEmptyStack();
                    if (j >= 0) {
                        this.mainInventory[j] = ItemStack.copyItemStack(itemStackIn);
                        this.mainInventory[j].animationsToGo = 5;
                        itemStackIn.stackSize = 0;
                        return true;
                    }
                    if (this.player.capabilities.isCreativeMode) {
                        itemStackIn.stackSize = 0;
                        return true;
                    }
                    return false;
                }
                do {
                    i = itemStackIn.stackSize;
                    itemStackIn.stackSize = this.storePartialItemStack(itemStackIn);
                } while (itemStackIn.stackSize > 0 && itemStackIn.stackSize < i);
                if (itemStackIn.stackSize == i && this.player.capabilities.isCreativeMode) {
                    itemStackIn.stackSize = 0;
                    return true;
                }
                return itemStackIn.stackSize < i;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Item being added");
                crashreportcategory.addCrashSection("Item ID", Item.getIdFromItem(itemStackIn.getItem()));
                crashreportcategory.addCrashSection("Item data", itemStackIn.getMetadata());
                crashreportcategory.addCrashSectionCallable("Item name", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return itemStackIn.getDisplayName();
                    }
                });
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    @Override
    public ItemStack decrStackSize(int index, int count) {
        ItemStack[] aitemstack = null;
        for (ItemStack[] aitemstack1 : this.field_184440_g) {
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
        }
        return aitemstack != null && aitemstack[index] != null ? ItemStackHelper.func_188382_a(aitemstack, index, count) : null;
    }

    public void func_184437_d(ItemStack p_184437_1_) {
        block0: for (ItemStack[] aitemstack : this.field_184440_g) {
            for (int i = 0; i < aitemstack.length; ++i) {
                if (aitemstack[i] != p_184437_1_) continue;
                aitemstack[i] = null;
                continue block0;
            }
        }
    }

    @Override
    public ItemStack removeStackFromSlot(int index) {
        ItemStack[] aitemstack = null;
        for (ItemStack[] aitemstack1 : this.field_184440_g) {
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
        }
        if (aitemstack != null && aitemstack[index] != null) {
            void itemstack = aitemstack[index];
            aitemstack[index] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        ItemStack[] aitemstack = null;
        for (ItemStack[] aitemstack1 : this.field_184440_g) {
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
        }
        if (aitemstack != null) {
            aitemstack[index] = stack;
        }
    }

    public float func_184438_a(IBlockState p_184438_1_) {
        float f = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f *= this.mainInventory[this.currentItem].getStrVsBlock(p_184438_1_);
        }
        return f;
    }

    public NBTTagList writeToNBT(NBTTagList nbtTagListIn) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            if (this.mainInventory[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)i);
            this.mainInventory[i].writeToNBT(nbttagcompound);
            nbtTagListIn.appendTag(nbttagcompound);
        }
        for (int j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)(j + 100));
            this.armorInventory[j].writeToNBT(nbttagcompound1);
            nbtTagListIn.appendTag(nbttagcompound1);
        }
        for (int k = 0; k < this.field_184439_c.length; ++k) {
            if (this.field_184439_c[k] == null) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.setByte("Slot", (byte)(k + 150));
            this.field_184439_c[k].writeToNBT(nbttagcompound2);
            nbtTagListIn.appendTag(nbttagcompound2);
        }
        return nbtTagListIn;
    }

    public void readFromNBT(NBTTagList nbtTagListIn) {
        Arrays.fill(this.mainInventory, null);
        Arrays.fill(this.armorInventory, null);
        Arrays.fill(this.field_184439_c, null);
        for (int i = 0; i < nbtTagListIn.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = nbtTagListIn.getCompoundTagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.loadItemStackFromNBT(nbttagcompound);
            if (itemstack == null) continue;
            if (j >= 0 && j < this.mainInventory.length) {
                this.mainInventory[j] = itemstack;
                continue;
            }
            if (j >= 100 && j < this.armorInventory.length + 100) {
                this.armorInventory[j - 100] = itemstack;
                continue;
            }
            if (j < 150 || j >= this.field_184439_c.length + 150) continue;
            this.field_184439_c[j - 150] = itemstack;
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.length + this.armorInventory.length + this.field_184439_c.length;
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        ItemStack[] aitemstack = null;
        for (ItemStack[] aitemstack1 : this.field_184440_g) {
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
        }
        return aitemstack == null ? null : aitemstack[index];
    }

    @Override
    public String getName() {
        return "container.inventory";
    }

    @Override
    public boolean hasCustomName() {
        return false;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean func_184432_b(IBlockState p_184432_1_) {
        if (p_184432_1_.getMaterial().isToolNotRequired()) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        return itemstack != null ? itemstack.canHarvestBlock(p_184432_1_) : false;
    }

    public ItemStack armorItemInSlot(int slotIn) {
        return this.armorInventory[slotIn];
    }

    public void damageArmor(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        for (int i = 0; i < this.armorInventory.length; ++i) {
            if (this.armorInventory[i] == null || !(this.armorInventory[i].getItem() instanceof ItemArmor)) continue;
            this.armorInventory[i].damageItem((int)damage, this.player);
            if (this.armorInventory[i].stackSize != 0) continue;
            this.armorInventory[i] = null;
        }
    }

    public void dropAllItems() {
        for (ItemStack[] aitemstack : this.field_184440_g) {
            for (int i = 0; i < aitemstack.length; ++i) {
                if (aitemstack[i] == null) continue;
                this.player.dropItem(aitemstack[i], true, false);
                aitemstack[i] = null;
            }
        }
    }

    @Override
    public void markDirty() {
        this.inventoryChanged = true;
    }

    public void setItemStack(ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.player.isDead ? false : player.getDistanceSqToEntity(this.player) <= 64.0;
    }

    public boolean hasItemStack(ItemStack itemStackIn) {
        for (ItemStack[] aitemstack : this.field_184440_g) {
            for (int i = 0; i < aitemstack.length; ++i) {
                if (aitemstack[i] == null || !aitemstack[i].isItemEqual(itemStackIn)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void openInventory(EntityPlayer player) {
    }

    @Override
    public void closeInventory(EntityPlayer player) {
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public void copyInventory(InventoryPlayer playerInventory) {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            this.setInventorySlotContents(i, playerInventory.getStackInSlot(i));
        }
        this.currentItem = playerInventory.currentItem;
    }

    @Override
    public int getField(int id) {
        return 0;
    }

    @Override
    public void setField(int id, int value) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        for (ItemStack[] aitemstack : this.field_184440_g) {
            for (int i = 0; i < aitemstack.length; ++i) {
                aitemstack[i] = null;
            }
        }
    }
}

