/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityDragonFireball
extends EntityFireball {
    public EntityDragonFireball(World worldIn) {
        super(worldIn);
        this.setSize(0.3125f, 0.3125f);
    }

    public EntityDragonFireball(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(worldIn, x, y, z, accelX, accelY, accelZ);
        this.setSize(0.3125f, 0.3125f);
    }

    public EntityDragonFireball(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        this.setSize(0.3125f, 0.3125f);
    }

    @Override
    protected void onImpact(RayTraceResult movingObject) {
        if (!this.worldObj.isRemote) {
            List<EntityLivingBase> list = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().expand(4.0, 2.0, 4.0));
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.worldObj, this.posX, this.posY, this.posZ);
            entityareaeffectcloud.func_184481_a(this.shootingEntity);
            entityareaeffectcloud.func_184491_a(EnumParticleTypes.DRAGON_BREATH);
            entityareaeffectcloud.setRadius(3.0f);
            entityareaeffectcloud.func_184486_b(2400);
            entityareaeffectcloud.func_184487_c((7.0f - entityareaeffectcloud.getRadius()) / (float)entityareaeffectcloud.func_184489_o());
            entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.harm, 1, 1));
            if (!list.isEmpty()) {
                for (EntityLivingBase entitylivingbase : list) {
                    double d0 = this.getDistanceSqToEntity(entitylivingbase);
                    if (!(d0 < 16.0)) continue;
                    entityareaeffectcloud.setPosition(entitylivingbase.posX, entitylivingbase.posY, entitylivingbase.posZ);
                    break;
                }
            }
            this.worldObj.playAuxSFX(2006, new BlockPos(this.posX, this.posY, this.posZ), 0);
            this.worldObj.spawnEntityInWorld(entityareaeffectcloud);
            this.setDead();
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        return false;
    }

    @Override
    protected EnumParticleTypes func_184563_j() {
        return EnumParticleTypes.DRAGON_BREATH;
    }

    @Override
    protected boolean func_184564_k() {
        return false;
    }
}

