/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.init;

import net.minecraft.init.Bootstrap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class Biomes {
    public static final BiomeGenBase ocean;
    public static final BiomeGenBase DEFAULT;
    public static final BiomeGenBase plains;
    public static final BiomeGenBase desert;
    public static final BiomeGenBase extremeHills;
    public static final BiomeGenBase forest;
    public static final BiomeGenBase taiga;
    public static final BiomeGenBase swampland;
    public static final BiomeGenBase river;
    public static final BiomeGenBase hell;
    public static final BiomeGenBase sky;
    public static final BiomeGenBase frozenOcean;
    public static final BiomeGenBase frozenRiver;
    public static final BiomeGenBase icePlains;
    public static final BiomeGenBase iceMountains;
    public static final BiomeGenBase mushroomIsland;
    public static final BiomeGenBase mushroomIslandShore;
    public static final BiomeGenBase beach;
    public static final BiomeGenBase desertHills;
    public static final BiomeGenBase forestHills;
    public static final BiomeGenBase taigaHills;
    public static final BiomeGenBase extremeHillsEdge;
    public static final BiomeGenBase jungle;
    public static final BiomeGenBase jungleHills;
    public static final BiomeGenBase jungleEdge;
    public static final BiomeGenBase deepOcean;
    public static final BiomeGenBase stoneBeach;
    public static final BiomeGenBase coldBeach;
    public static final BiomeGenBase birchForest;
    public static final BiomeGenBase birchForestHills;
    public static final BiomeGenBase roofedForest;
    public static final BiomeGenBase coldTaiga;
    public static final BiomeGenBase coldTaigaHills;
    public static final BiomeGenBase megaTaiga;
    public static final BiomeGenBase megaTaigaHills;
    public static final BiomeGenBase extremeHillsPlus;
    public static final BiomeGenBase savanna;
    public static final BiomeGenBase savannaPlateau;
    public static final BiomeGenBase mesa;
    public static final BiomeGenBase mesaPlateau_F;
    public static final BiomeGenBase mesaPlateau;
    public static final BiomeGenBase voidBiome;
    public static final BiomeGenBase mutated_plains;
    public static final BiomeGenBase mutated_desert;
    public static final BiomeGenBase mutated_extreme_hills;
    public static final BiomeGenBase mutated_forest;
    public static final BiomeGenBase mutated_taiga;
    public static final BiomeGenBase mutated_swampland;
    public static final BiomeGenBase mutated_ice_flats;
    public static final BiomeGenBase mutated_jungle;
    public static final BiomeGenBase mutated_jungle_edge;
    public static final BiomeGenBase mutated_birch_forest;
    public static final BiomeGenBase mutated_birch_forest_hills;
    public static final BiomeGenBase mutated_roofed_forest;
    public static final BiomeGenBase mutated_taiga_cold;
    public static final BiomeGenBase mutated_redwood_taiga;
    public static final BiomeGenBase mutated_redwood_taiga_hills;
    public static final BiomeGenBase mutated_extreme_hills_with_trees;
    public static final BiomeGenBase mutated_savanna;
    public static final BiomeGenBase mutated_savanna_rock;
    public static final BiomeGenBase mutated_mesa;
    public static final BiomeGenBase mutated_mesa_rock;
    public static final BiomeGenBase mutated_mesa_clear_rock;

    private static BiomeGenBase getRegisteredBiome(String id) {
        BiomeGenBase biomegenbase = BiomeGenBase.biomeRegistry.getObject(new ResourceLocation(id));
        if (biomegenbase == null) {
            throw new IllegalStateException("Invalid Biome requested: " + id);
        }
        return biomegenbase;
    }

    static {
        if (!Bootstrap.isRegistered()) {
            throw new RuntimeException("Accessed Biomes before Bootstrap!");
        }
        DEFAULT = ocean = Biomes.getRegisteredBiome("ocean");
        plains = Biomes.getRegisteredBiome("plains");
        desert = Biomes.getRegisteredBiome("desert");
        extremeHills = Biomes.getRegisteredBiome("extreme_hills");
        forest = Biomes.getRegisteredBiome("forest");
        taiga = Biomes.getRegisteredBiome("taiga");
        swampland = Biomes.getRegisteredBiome("swampland");
        river = Biomes.getRegisteredBiome("river");
        hell = Biomes.getRegisteredBiome("hell");
        sky = Biomes.getRegisteredBiome("sky");
        frozenOcean = Biomes.getRegisteredBiome("frozen_ocean");
        frozenRiver = Biomes.getRegisteredBiome("frozen_river");
        icePlains = Biomes.getRegisteredBiome("ice_flats");
        iceMountains = Biomes.getRegisteredBiome("ice_mountains");
        mushroomIsland = Biomes.getRegisteredBiome("mushroom_island");
        mushroomIslandShore = Biomes.getRegisteredBiome("mushroom_island_shore");
        beach = Biomes.getRegisteredBiome("beaches");
        desertHills = Biomes.getRegisteredBiome("desert_hills");
        forestHills = Biomes.getRegisteredBiome("forest_hills");
        taigaHills = Biomes.getRegisteredBiome("taiga_hills");
        extremeHillsEdge = Biomes.getRegisteredBiome("smaller_extreme_hills");
        jungle = Biomes.getRegisteredBiome("jungle");
        jungleHills = Biomes.getRegisteredBiome("jungle_hills");
        jungleEdge = Biomes.getRegisteredBiome("jungle_edge");
        deepOcean = Biomes.getRegisteredBiome("deep_ocean");
        stoneBeach = Biomes.getRegisteredBiome("stone_beach");
        coldBeach = Biomes.getRegisteredBiome("cold_beach");
        birchForest = Biomes.getRegisteredBiome("birch_forest");
        birchForestHills = Biomes.getRegisteredBiome("birch_forest_hills");
        roofedForest = Biomes.getRegisteredBiome("roofed_forest");
        coldTaiga = Biomes.getRegisteredBiome("taiga_cold");
        coldTaigaHills = Biomes.getRegisteredBiome("taiga_cold_hills");
        megaTaiga = Biomes.getRegisteredBiome("redwood_taiga");
        megaTaigaHills = Biomes.getRegisteredBiome("redwood_taiga_hills");
        extremeHillsPlus = Biomes.getRegisteredBiome("extreme_hills_with_trees");
        savanna = Biomes.getRegisteredBiome("savanna");
        savannaPlateau = Biomes.getRegisteredBiome("savanna_rock");
        mesa = Biomes.getRegisteredBiome("mesa");
        mesaPlateau_F = Biomes.getRegisteredBiome("mesa_rock");
        mesaPlateau = Biomes.getRegisteredBiome("mesa_clear_rock");
        voidBiome = Biomes.getRegisteredBiome("void");
        mutated_plains = Biomes.getRegisteredBiome("mutated_plains");
        mutated_desert = Biomes.getRegisteredBiome("mutated_desert");
        mutated_extreme_hills = Biomes.getRegisteredBiome("mutated_extreme_hills");
        mutated_forest = Biomes.getRegisteredBiome("mutated_forest");
        mutated_taiga = Biomes.getRegisteredBiome("mutated_taiga");
        mutated_swampland = Biomes.getRegisteredBiome("mutated_swampland");
        mutated_ice_flats = Biomes.getRegisteredBiome("mutated_ice_flats");
        mutated_jungle = Biomes.getRegisteredBiome("mutated_jungle");
        mutated_jungle_edge = Biomes.getRegisteredBiome("mutated_jungle_edge");
        mutated_birch_forest = Biomes.getRegisteredBiome("mutated_birch_forest");
        mutated_birch_forest_hills = Biomes.getRegisteredBiome("mutated_birch_forest_hills");
        mutated_roofed_forest = Biomes.getRegisteredBiome("mutated_roofed_forest");
        mutated_taiga_cold = Biomes.getRegisteredBiome("mutated_taiga_cold");
        mutated_redwood_taiga = Biomes.getRegisteredBiome("mutated_redwood_taiga");
        mutated_redwood_taiga_hills = Biomes.getRegisteredBiome("mutated_redwood_taiga_hills");
        mutated_extreme_hills_with_trees = Biomes.getRegisteredBiome("mutated_extreme_hills_with_trees");
        mutated_savanna = Biomes.getRegisteredBiome("mutated_savanna");
        mutated_savanna_rock = Biomes.getRegisteredBiome("mutated_savanna_rock");
        mutated_mesa = Biomes.getRegisteredBiome("mutated_mesa");
        mutated_mesa_rock = Biomes.getRegisteredBiome("mutated_mesa_rock");
        mutated_mesa_clear_rock = Biomes.getRegisteredBiome("mutated_mesa_clear_rock");
    }
}

