/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.init;

import net.minecraft.init.Bootstrap;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public class MobEffects {
    public static final Potion moveSpeed;
    public static final Potion moveSlowdown;
    public static final Potion digSpeed;
    public static final Potion digSlowdown;
    public static final Potion damageBoost;
    public static final Potion heal;
    public static final Potion harm;
    public static final Potion jump;
    public static final Potion confusion;
    public static final Potion regeneration;
    public static final Potion resistance;
    public static final Potion fireResistance;
    public static final Potion waterBreathing;
    public static final Potion invisibility;
    public static final Potion blindness;
    public static final Potion nightVision;
    public static final Potion hunger;
    public static final Potion weakness;
    public static final Potion poison;
    public static final Potion wither;
    public static final Potion healthBoost;
    public static final Potion absorption;
    public static final Potion saturation;
    public static final Potion glowing;
    public static final Potion levitation;
    public static final Potion luck;
    public static final Potion unluck;

    private static Potion getRegisteredMobEffect(String id) {
        Potion potion = Potion.potionRegistry.getObject(new ResourceLocation(id));
        if (potion == null) {
            throw new IllegalStateException("Invalid MobEffect requested: " + id);
        }
        return potion;
    }

    static {
        if (!Bootstrap.isRegistered()) {
            throw new RuntimeException("Accessed MobEffects before Bootstrap!");
        }
        moveSpeed = MobEffects.getRegisteredMobEffect("speed");
        moveSlowdown = MobEffects.getRegisteredMobEffect("slowness");
        digSpeed = MobEffects.getRegisteredMobEffect("haste");
        digSlowdown = MobEffects.getRegisteredMobEffect("mining_fatigue");
        damageBoost = MobEffects.getRegisteredMobEffect("strength");
        heal = MobEffects.getRegisteredMobEffect("instant_health");
        harm = MobEffects.getRegisteredMobEffect("instant_damage");
        jump = MobEffects.getRegisteredMobEffect("jump_boost");
        confusion = MobEffects.getRegisteredMobEffect("nausea");
        regeneration = MobEffects.getRegisteredMobEffect("regeneration");
        resistance = MobEffects.getRegisteredMobEffect("resistance");
        fireResistance = MobEffects.getRegisteredMobEffect("fire_resistance");
        waterBreathing = MobEffects.getRegisteredMobEffect("water_breathing");
        invisibility = MobEffects.getRegisteredMobEffect("invisibility");
        blindness = MobEffects.getRegisteredMobEffect("blindness");
        nightVision = MobEffects.getRegisteredMobEffect("night_vision");
        hunger = MobEffects.getRegisteredMobEffect("hunger");
        weakness = MobEffects.getRegisteredMobEffect("weakness");
        poison = MobEffects.getRegisteredMobEffect("poison");
        wither = MobEffects.getRegisteredMobEffect("wither");
        healthBoost = MobEffects.getRegisteredMobEffect("health_boost");
        absorption = MobEffects.getRegisteredMobEffect("absorption");
        saturation = MobEffects.getRegisteredMobEffect("saturation");
        glowing = MobEffects.getRegisteredMobEffect("glowing");
        levitation = MobEffects.getRegisteredMobEffect("levitation");
        luck = MobEffects.getRegisteredMobEffect("luck");
        unluck = MobEffects.getRegisteredMobEffect("unluck");
    }
}

