/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Rotations;
import net.minecraft.world.World;

public class ItemArmorStand
extends Item {
    public ItemArmorStand() {
        this.setCreativeTab(CreativeTabs.tabDecorations);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand side, EnumFacing hitX, float hitY, float hitZ, float p_180614_9_) {
        double d2;
        double d1;
        BlockPos blockpos;
        if (hitX == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        boolean flag = worldIn.getBlockState(pos).getBlock().isReplaceable(worldIn, pos);
        BlockPos blockPos = blockpos = flag ? pos : pos.offset(hitX);
        if (!playerIn.canPlayerEdit(blockpos, hitX, stack)) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos1 = blockpos.up();
        boolean flag1 = !worldIn.isAirBlock(blockpos) && !worldIn.getBlockState(blockpos).getBlock().isReplaceable(worldIn, blockpos);
        if (flag1 |= !worldIn.isAirBlock(blockpos1) && !worldIn.getBlockState(blockpos1).getBlock().isReplaceable(worldIn, blockpos1)) {
            return EnumActionResult.FAIL;
        }
        double d0 = blockpos.getX();
        List<Entity> list = worldIn.getEntitiesWithinAABBExcludingEntity(null, new AxisAlignedBB(d0, d1 = (double)blockpos.getY(), d2 = (double)blockpos.getZ(), d0 + 1.0, d1 + 2.0, d2 + 1.0));
        if (!list.isEmpty()) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.isRemote) {
            worldIn.setBlockToAir(blockpos);
            worldIn.setBlockToAir(blockpos1);
            EntityArmorStand entityarmorstand = new EntityArmorStand(worldIn, d0 + 0.5, d1, d2 + 0.5);
            float f = (float)MathHelper.floor_float((MathHelper.wrapAngleTo180_float(playerIn.rotationYaw - 180.0f) + 22.5f) / 45.0f) * 45.0f;
            entityarmorstand.setLocationAndAngles(d0 + 0.5, d1, d2 + 0.5, f, 0.0f);
            this.applyRandomRotations(entityarmorstand, worldIn.rand);
            ItemMonsterPlacer.func_185079_a(worldIn, playerIn, stack, entityarmorstand);
            worldIn.spawnEntityInWorld(entityarmorstand);
            worldIn.func_184148_a(null, entityarmorstand.posX, entityarmorstand.posY, entityarmorstand.posZ, SoundEvents.entity_armorstand_place, SoundCategory.BLOCKS, 0.75f, 0.8f);
        }
        --stack.stackSize;
        return EnumActionResult.SUCCESS;
    }

    private void applyRandomRotations(EntityArmorStand armorStand, Random rand) {
        Rotations rotations = armorStand.getHeadRotation();
        float f = rand.nextFloat() * 5.0f;
        float f1 = rand.nextFloat() * 20.0f - 10.0f;
        Rotations rotations1 = new Rotations(rotations.getX() + f, rotations.getY() + f1, rotations.getZ());
        armorStand.setHeadRotation(rotations1);
        rotations = armorStand.getBodyRotation();
        f = rand.nextFloat() * 10.0f - 5.0f;
        rotations1 = new Rotations(rotations.getX(), rotations.getY() + f, rotations.getZ());
        armorStand.setBodyRotation(rotations1);
    }
}

