/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.world.World;

public class ShieldRecipes {
    public void func_185256_a(CraftingManager p_185256_1_) {
        p_185256_1_.addRecipe(new ItemStack(Items.shield), "WoW", "WWW", " W ", Character.valueOf('W'), Blocks.planks, Character.valueOf('o'), Items.iron_ingot);
        p_185256_1_.addRecipe(new Decoration());
    }

    static class Decoration
    implements IRecipe {
        private Decoration() {
        }

        @Override
        public boolean matches(InventoryCrafting inv, World worldIn) {
            ItemStack itemstack = null;
            ItemStack itemstack1 = null;
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                ItemStack itemstack2 = inv.getStackInSlot(i);
                if (itemstack2 == null) continue;
                if (itemstack2.getItem() == Items.banner) {
                    if (itemstack1 != null) {
                        return false;
                    }
                    itemstack1 = itemstack2;
                    continue;
                }
                if (itemstack2.getItem() != Items.shield) {
                    return false;
                }
                if (itemstack != null) {
                    return false;
                }
                if (itemstack2.getSubCompound("BlockEntityTag", false) != null) {
                    return false;
                }
                itemstack = itemstack2;
            }
            return itemstack != null && itemstack1 != null;
        }

        @Override
        public ItemStack getCraftingResult(InventoryCrafting inv) {
            EnumDyeColor enumdyecolor;
            NBTTagCompound nbttagcompound;
            ItemStack itemstack = null;
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                ItemStack itemstack1 = inv.getStackInSlot(i);
                if (itemstack1 == null || itemstack1.getItem() != Items.banner) continue;
                itemstack = itemstack1;
            }
            ItemStack itemstack2 = new ItemStack(Items.shield, 1, 0);
            if (itemstack.hasTagCompound()) {
                nbttagcompound = (NBTTagCompound)itemstack.getTagCompound().copy();
                enumdyecolor = EnumDyeColor.byDyeDamage(TileEntityBanner.getBaseColor(itemstack));
            } else {
                nbttagcompound = new NBTTagCompound();
                enumdyecolor = EnumDyeColor.byDyeDamage(itemstack.getItemDamage());
            }
            itemstack2.setTagCompound(nbttagcompound);
            TileEntityBanner.func_184248_a(itemstack2, enumdyecolor);
            return itemstack2;
        }

        @Override
        public int getRecipeSize() {
            return 2;
        }

        @Override
        public ItemStack getRecipeOutput() {
            return null;
        }

        @Override
        public ItemStack[] getRemainingItems(InventoryCrafting inv) {
            ItemStack[] aitemstack = new ItemStack[inv.getSizeInventory()];
            for (int i = 0; i < aitemstack.length; ++i) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack == null || !itemstack.getItem().hasContainerItem()) continue;
                aitemstack[i] = new ItemStack(itemstack.getItem().getContainerItem());
            }
            return aitemstack;
        }
    }
}

