/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.text.ITextComponent;

public class DataSerializers {
    private static final IntIdentityHashBiMap<DataSerializer<?>> field_187204_n = new IntIdentityHashBiMap(16);
    public static final DataSerializer<Byte> BYTE = new DataSerializer<Byte>(){

        @Override
        public void write(PacketBuffer buf, Byte value) {
            buf.writeByte(value.byteValue());
        }

        @Override
        public Byte read(PacketBuffer buf) {
            return buf.readByte();
        }

        @Override
        public DataParameter<Byte> createKey(int id) {
            return new DataParameter<Byte>(id, this);
        }
    };
    public static final DataSerializer<Integer> VARINT = new DataSerializer<Integer>(){

        @Override
        public void write(PacketBuffer buf, Integer value) {
            buf.writeVarIntToBuffer(value);
        }

        @Override
        public Integer read(PacketBuffer buf) {
            return buf.readVarIntFromBuffer();
        }

        @Override
        public DataParameter<Integer> createKey(int id) {
            return new DataParameter<Integer>(id, this);
        }
    };
    public static final DataSerializer<Float> FLOAT = new DataSerializer<Float>(){

        @Override
        public void write(PacketBuffer buf, Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float read(PacketBuffer buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public DataParameter<Float> createKey(int id) {
            return new DataParameter<Float>(id, this);
        }
    };
    public static final DataSerializer<String> STRING = new DataSerializer<String>(){

        @Override
        public void write(PacketBuffer buf, String value) {
            buf.writeString(value);
        }

        @Override
        public String read(PacketBuffer buf) {
            return buf.readStringFromBuffer(Short.MAX_VALUE);
        }

        @Override
        public DataParameter<String> createKey(int id) {
            return new DataParameter<String>(id, this);
        }
    };
    public static final DataSerializer<ITextComponent> TEXT_COMPONENT = new DataSerializer<ITextComponent>(){

        @Override
        public void write(PacketBuffer buf, ITextComponent value) {
            buf.writeChatComponent(value);
        }

        @Override
        public ITextComponent read(PacketBuffer buf) throws IOException {
            return buf.readChatComponent();
        }

        @Override
        public DataParameter<ITextComponent> createKey(int id) {
            return new DataParameter<ITextComponent>(id, this);
        }
    };
    public static final DataSerializer<Optional<ItemStack>> OPTIONAL_ITEM_STACK = new DataSerializer<Optional<ItemStack>>(){

        @Override
        public void write(PacketBuffer buf, Optional<ItemStack> value) {
            buf.writeItemStackToBuffer((ItemStack)value.orNull());
        }

        @Override
        public Optional<ItemStack> read(PacketBuffer buf) throws IOException {
            return Optional.fromNullable((Object)buf.readItemStackFromBuffer());
        }

        @Override
        public DataParameter<Optional<ItemStack>> createKey(int id) {
            return new DataParameter<Optional<ItemStack>>(id, this);
        }
    };
    public static final DataSerializer<Optional<IBlockState>> OPTIONAL_BLOCK_STATE = new DataSerializer<Optional<IBlockState>>(){

        @Override
        public void write(PacketBuffer buf, Optional<IBlockState> value) {
            if (value.isPresent()) {
                buf.writeVarIntToBuffer(Block.getStateId((IBlockState)value.get()));
            } else {
                buf.writeVarIntToBuffer(0);
            }
        }

        @Override
        public Optional<IBlockState> read(PacketBuffer buf) {
            int i = buf.readVarIntFromBuffer();
            return i == 0 ? Optional.absent() : Optional.of((Object)Block.getStateById(i));
        }

        @Override
        public DataParameter<Optional<IBlockState>> createKey(int id) {
            return new DataParameter<Optional<IBlockState>>(id, this);
        }
    };
    public static final DataSerializer<Boolean> BOOLEAN = new DataSerializer<Boolean>(){

        @Override
        public void write(PacketBuffer buf, Boolean value) {
            buf.writeBoolean(value);
        }

        @Override
        public Boolean read(PacketBuffer buf) {
            return buf.readBoolean();
        }

        @Override
        public DataParameter<Boolean> createKey(int id) {
            return new DataParameter<Boolean>(id, this);
        }
    };
    public static final DataSerializer<Rotations> ROTATIONS = new DataSerializer<Rotations>(){

        @Override
        public void write(PacketBuffer buf, Rotations value) {
            buf.writeFloat(value.getX());
            buf.writeFloat(value.getY());
            buf.writeFloat(value.getZ());
        }

        @Override
        public Rotations read(PacketBuffer buf) {
            return new Rotations(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        @Override
        public DataParameter<Rotations> createKey(int id) {
            return new DataParameter<Rotations>(id, this);
        }
    };
    public static final DataSerializer<BlockPos> BLOCK_POS = new DataSerializer<BlockPos>(){

        @Override
        public void write(PacketBuffer buf, BlockPos value) {
            buf.writeBlockPos(value);
        }

        @Override
        public BlockPos read(PacketBuffer buf) {
            return buf.readBlockPos();
        }

        @Override
        public DataParameter<BlockPos> createKey(int id) {
            return new DataParameter<BlockPos>(id, this);
        }
    };
    public static final DataSerializer<Optional<BlockPos>> OPTIONAL_BLOCK_POS = new DataSerializer<Optional<BlockPos>>(){

        @Override
        public void write(PacketBuffer buf, Optional<BlockPos> value) {
            buf.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                buf.writeBlockPos((BlockPos)value.get());
            }
        }

        @Override
        public Optional<BlockPos> read(PacketBuffer buf) {
            return !buf.readBoolean() ? Optional.absent() : Optional.of((Object)buf.readBlockPos());
        }

        @Override
        public DataParameter<Optional<BlockPos>> createKey(int id) {
            return new DataParameter<Optional<BlockPos>>(id, this);
        }
    };
    public static final DataSerializer<EnumFacing> FACING = new DataSerializer<EnumFacing>(){

        @Override
        public void write(PacketBuffer buf, EnumFacing value) {
            buf.writeEnumValue(value);
        }

        @Override
        public EnumFacing read(PacketBuffer buf) {
            return buf.readEnumValue(EnumFacing.class);
        }

        @Override
        public DataParameter<EnumFacing> createKey(int id) {
            return new DataParameter<EnumFacing>(id, this);
        }
    };
    public static final DataSerializer<Optional<UUID>> OPTIONAL_UNIQUE_ID = new DataSerializer<Optional<UUID>>(){

        @Override
        public void write(PacketBuffer buf, Optional<UUID> value) {
            buf.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                buf.writeUuid((UUID)value.get());
            }
        }

        @Override
        public Optional<UUID> read(PacketBuffer buf) {
            return !buf.readBoolean() ? Optional.absent() : Optional.of((Object)buf.readUuid());
        }

        @Override
        public DataParameter<Optional<UUID>> createKey(int id) {
            return new DataParameter<Optional<UUID>>(id, this);
        }
    };

    public static void registerSerializer(DataSerializer<?> serializer) {
        field_187204_n.func_186808_c(serializer);
    }

    public static DataSerializer<?> getSerializer(int id) {
        return field_187204_n.func_186813_a(id);
    }

    public static int getSerializerId(DataSerializer<?> serializer) {
        return field_187204_n.func_186815_a(serializer);
    }

    static {
        DataSerializers.registerSerializer(BYTE);
        DataSerializers.registerSerializer(VARINT);
        DataSerializers.registerSerializer(FLOAT);
        DataSerializers.registerSerializer(STRING);
        DataSerializers.registerSerializer(TEXT_COMPONENT);
        DataSerializers.registerSerializer(OPTIONAL_ITEM_STACK);
        DataSerializers.registerSerializer(BOOLEAN);
        DataSerializers.registerSerializer(ROTATIONS);
        DataSerializers.registerSerializer(BLOCK_POS);
        DataSerializers.registerSerializer(OPTIONAL_BLOCK_POS);
        DataSerializers.registerSerializer(FACING);
        DataSerializers.registerSerializer(OPTIONAL_UNIQUE_ID);
        DataSerializers.registerSerializer(OPTIONAL_BLOCK_STATE);
    }
}

