/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;

public class PotionType {
    private static final ResourceLocation WATER = new ResourceLocation("water");
    public static final RegistryNamespacedDefaultedByKey<ResourceLocation, PotionType> REGISTRY = new RegistryNamespacedDefaultedByKey(WATER);
    private static int field_185178_c;
    private final String name;
    private final ImmutableList<PotionEffect> effects;

    public static PotionType getPotionTypeForID(int p_185169_0_) {
        return REGISTRY.getObjectById(p_185169_0_);
    }

    public static int getID(PotionType p_185171_0_) {
        return REGISTRY.getIDForObject(p_185171_0_);
    }

    public static PotionType getPotionTypeForName(String p_185168_0_) {
        return REGISTRY.getObject(new ResourceLocation(p_185168_0_));
    }

    public PotionType(PotionEffect ... p_i46739_1_) {
        this((String)null, p_i46739_1_);
    }

    public PotionType(String p_i46740_1_, PotionEffect ... p_i46740_2_) {
        this.name = p_i46740_1_;
        this.effects = ImmutableList.copyOf((Object[])p_i46740_2_);
    }

    public String func_185174_b(String p_185174_1_) {
        return this.name == null ? p_185174_1_ + REGISTRY.getNameForObject(this).getResourcePath() : p_185174_1_ + this.name;
    }

    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    public static void registerPotionTypes() {
        PotionType.registerPotionType("empty", new PotionType(new PotionEffect[0]));
        PotionType.registerPotionType("water", new PotionType(new PotionEffect[0]));
        PotionType.registerPotionType("mundane", new PotionType(new PotionEffect[0]));
        PotionType.registerPotionType("thick", new PotionType(new PotionEffect[0]));
        PotionType.registerPotionType("awkward", new PotionType(new PotionEffect[0]));
        PotionType.registerPotionType("night_vision", new PotionType(new PotionEffect(MobEffects.nightVision, 3600)));
        PotionType.registerPotionType("long_night_vision", new PotionType("night_vision", new PotionEffect(MobEffects.nightVision, 9600)));
        PotionType.registerPotionType("invisibility", new PotionType(new PotionEffect(MobEffects.invisibility, 3600)));
        PotionType.registerPotionType("long_invisibility", new PotionType("invisibility", new PotionEffect(MobEffects.invisibility, 9600)));
        PotionType.registerPotionType("leaping", new PotionType(new PotionEffect(MobEffects.jump, 3600)));
        PotionType.registerPotionType("long_leaping", new PotionType("leaping", new PotionEffect(MobEffects.jump, 9600)));
        PotionType.registerPotionType("strong_leaping", new PotionType("leaping", new PotionEffect(MobEffects.jump, 1800, 1)));
        PotionType.registerPotionType("fire_resistance", new PotionType(new PotionEffect(MobEffects.fireResistance, 3600)));
        PotionType.registerPotionType("long_fire_resistance", new PotionType("fire_resistance", new PotionEffect(MobEffects.fireResistance, 9600)));
        PotionType.registerPotionType("swiftness", new PotionType(new PotionEffect(MobEffects.moveSpeed, 3600)));
        PotionType.registerPotionType("long_swiftness", new PotionType("swiftness", new PotionEffect(MobEffects.moveSpeed, 9600)));
        PotionType.registerPotionType("strong_swiftness", new PotionType("swiftness", new PotionEffect(MobEffects.moveSpeed, 1800, 1)));
        PotionType.registerPotionType("slowness", new PotionType(new PotionEffect(MobEffects.moveSlowdown, 1800)));
        PotionType.registerPotionType("long_slowness", new PotionType("slowness", new PotionEffect(MobEffects.moveSlowdown, 4800)));
        PotionType.registerPotionType("water_breathing", new PotionType(new PotionEffect(MobEffects.waterBreathing, 3600)));
        PotionType.registerPotionType("long_water_breathing", new PotionType("water_breathing", new PotionEffect(MobEffects.waterBreathing, 9600)));
        PotionType.registerPotionType("healing", new PotionType(new PotionEffect(MobEffects.heal, 1)));
        PotionType.registerPotionType("strong_healing", new PotionType("healing", new PotionEffect(MobEffects.heal, 1, 1)));
        PotionType.registerPotionType("harming", new PotionType(new PotionEffect(MobEffects.harm, 1)));
        PotionType.registerPotionType("strong_harming", new PotionType("harming", new PotionEffect(MobEffects.harm, 1, 1)));
        PotionType.registerPotionType("poison", new PotionType(new PotionEffect(MobEffects.poison, 900)));
        PotionType.registerPotionType("long_poison", new PotionType("poison", new PotionEffect(MobEffects.poison, 1800)));
        PotionType.registerPotionType("strong_poison", new PotionType("poison", new PotionEffect(MobEffects.poison, 432, 1)));
        PotionType.registerPotionType("regeneration", new PotionType(new PotionEffect(MobEffects.regeneration, 900)));
        PotionType.registerPotionType("long_regeneration", new PotionType("regeneration", new PotionEffect(MobEffects.regeneration, 1800)));
        PotionType.registerPotionType("strong_regeneration", new PotionType("regeneration", new PotionEffect(MobEffects.regeneration, 450, 1)));
        PotionType.registerPotionType("strength", new PotionType(new PotionEffect(MobEffects.damageBoost, 3600)));
        PotionType.registerPotionType("long_strength", new PotionType("strength", new PotionEffect(MobEffects.damageBoost, 9600)));
        PotionType.registerPotionType("strong_strength", new PotionType("strength", new PotionEffect(MobEffects.damageBoost, 1800, 1)));
        PotionType.registerPotionType("weakness", new PotionType(new PotionEffect(MobEffects.weakness, 1800)));
        PotionType.registerPotionType("long_weakness", new PotionType("weakness", new PotionEffect(MobEffects.weakness, 4800)));
        PotionType.registerPotionType("luck", new PotionType("luck", new PotionEffect(MobEffects.luck, 6000)));
        REGISTRY.validateKey();
    }

    protected static void registerPotionType(String p_185173_0_, PotionType p_185173_1_) {
        REGISTRY.register(field_185178_c++, new ResourceLocation(p_185173_0_), p_185173_1_);
    }

    public boolean func_185172_c() {
        if (!this.effects.isEmpty()) {
            for (PotionEffect potioneffect : this.effects) {
                if (!potioneffect.func_188419_a().isInstant()) continue;
                return true;
            }
        }
        return false;
    }
}

