/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.src.Config;
import net.minecraft.src.CustomColors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class PotionUtils {
    public static List<PotionEffect> getEffectsFromStack(ItemStack stack) {
        return PotionUtils.getEffectsFromTag(stack.getTagCompound());
    }

    public static List<PotionEffect> func_185186_a(PotionType p_185186_0_, Collection<PotionEffect> p_185186_1_) {
        ArrayList list = Lists.newArrayList();
        list.addAll(p_185186_0_.getEffects());
        list.addAll(p_185186_1_);
        return list;
    }

    public static List<PotionEffect> getEffectsFromTag(NBTTagCompound tag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(PotionUtils.func_185187_c(tag).getEffects());
        PotionUtils.func_185193_a(tag, list);
        return list;
    }

    public static List<PotionEffect> func_185190_b(ItemStack p_185190_0_) {
        return PotionUtils.func_185192_b(p_185190_0_.getTagCompound());
    }

    public static List<PotionEffect> func_185192_b(NBTTagCompound p_185192_0_) {
        ArrayList list = Lists.newArrayList();
        PotionUtils.func_185193_a(p_185192_0_, list);
        return list;
    }

    public static void func_185193_a(NBTTagCompound p_185193_0_, List<PotionEffect> p_185193_1_) {
        if (p_185193_0_ != null && p_185193_0_.hasKey("CustomPotionEffects", 9)) {
            NBTTagList nbttaglist = p_185193_0_.getTagList("CustomPotionEffects", 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                PotionEffect potioneffect = PotionEffect.readCustomPotionEffectFromNBT(nbttagcompound);
                if (potioneffect == null) continue;
                p_185193_1_.add(potioneffect);
            }
        }
    }

    public static int func_185183_a(PotionType p_185183_0_) {
        return PotionUtils.func_185181_a(p_185183_0_.getEffects());
    }

    public static int func_185181_a(Collection<PotionEffect> p_185181_0_) {
        int i = 3694022;
        if (p_185181_0_.isEmpty()) {
            return Config.isCustomColors() ? CustomColors.getPotionColor(null, i) : 3694022;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (PotionEffect potioneffect : p_185181_0_) {
            if (!potioneffect.func_188418_e()) continue;
            int k = potioneffect.func_188419_a().getLiquidColor();
            if (Config.isCustomColors()) {
                k = CustomColors.getPotionColor(potioneffect.func_188419_a(), k);
            }
            int l = potioneffect.getAmplifier() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static PotionType func_185191_c(ItemStack p_185191_0_) {
        return PotionUtils.func_185187_c(p_185191_0_.getTagCompound());
    }

    public static PotionType func_185187_c(NBTTagCompound p_185187_0_) {
        return p_185187_0_ == null ? PotionTypes.water : PotionType.getPotionTypeForName(p_185187_0_.getString("Potion"));
    }

    public static ItemStack func_185188_a(ItemStack p_185188_0_, PotionType p_185188_1_) {
        ResourceLocation resourcelocation = PotionType.REGISTRY.getNameForObject(p_185188_1_);
        if (resourcelocation != null) {
            NBTTagCompound nbttagcompound = p_185188_0_.hasTagCompound() ? p_185188_0_.getTagCompound() : new NBTTagCompound();
            nbttagcompound.setString("Potion", resourcelocation.toString());
            p_185188_0_.setTagCompound(nbttagcompound);
        }
        return p_185188_0_;
    }

    public static ItemStack func_185184_a(ItemStack p_185184_0_, Collection<PotionEffect> p_185184_1_) {
        if (p_185184_1_.isEmpty()) {
            return p_185184_0_;
        }
        NBTTagCompound nbttagcompound = (NBTTagCompound)Objects.firstNonNull((Object)p_185184_0_.getTagCompound(), (Object)new NBTTagCompound());
        NBTTagList nbttaglist = nbttagcompound.getTagList("CustomPotionEffects", 9);
        for (PotionEffect potioneffect : p_185184_1_) {
            nbttaglist.appendTag(potioneffect.writeCustomPotionEffectToNBT(new NBTTagCompound()));
        }
        nbttagcompound.setTag("CustomPotionEffects", nbttaglist);
        p_185184_0_.setTagCompound(nbttagcompound);
        return p_185184_0_;
    }

    public static void addPotionTooltip(ItemStack p_185182_0_, List<String> p_185182_1_, float p_185182_2_) {
        List<PotionEffect> list = PotionUtils.getEffectsFromStack(p_185182_0_);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            String s = I18n.translateToLocal("effect.none").trim();
            p_185182_1_.add((Object)((Object)TextFormatting.GRAY) + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = I18n.translateToLocal(potioneffect.getEffectName()).trim();
                Potion potion = potioneffect.func_188419_a();
                Map<IAttribute, AttributeModifier> map = potion.getAttributeModifierMap();
                if (!map.isEmpty()) {
                    for (Map.Entry<IAttribute, AttributeModifier> entry : map.entrySet()) {
                        AttributeModifier attributemodifier = entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.getName(), potion.getAttributeModifierAmount(potioneffect.getAmplifier(), attributemodifier), attributemodifier.getOperation());
                        list1.add(new Tuple<String, AttributeModifier>(entry.getKey().getAttributeUnlocalizedName(), attributemodifier1));
                    }
                }
                if (potioneffect.getAmplifier() > 0) {
                    s1 = s1 + " " + I18n.translateToLocal("potion.potency." + potioneffect.getAmplifier()).trim();
                }
                if (potioneffect.getDuration() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a(potioneffect, p_185182_2_) + ")";
                }
                if (potion.isBadEffect()) {
                    p_185182_1_.add((Object)((Object)TextFormatting.RED) + s1);
                    continue;
                }
                p_185182_1_.add((Object)((Object)TextFormatting.BLUE) + s1);
            }
        }
        if (!list1.isEmpty()) {
            p_185182_1_.add("");
            p_185182_1_.add((Object)((Object)TextFormatting.DARK_PURPLE) + I18n.translateToLocal("potion.whenDrank"));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.getSecond();
                double d0 = attributemodifier2.getAmount();
                double d1 = attributemodifier2.getOperation() != 1 && attributemodifier2.getOperation() != 2 ? attributemodifier2.getAmount() : attributemodifier2.getAmount() * 100.0;
                if (d0 > 0.0) {
                    p_185182_1_.add((Object)((Object)TextFormatting.BLUE) + I18n.translateToLocalFormatted("attribute.modifier.plus." + attributemodifier2.getOperation(), ItemStack.DECIMALFORMAT.format(d1), I18n.translateToLocal("attribute.name." + (String)tuple.getFirst())));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                p_185182_1_.add((Object)((Object)TextFormatting.RED) + I18n.translateToLocalFormatted("attribute.modifier.take." + attributemodifier2.getOperation(), ItemStack.DECIMALFORMAT.format(d1 *= -1.0), I18n.translateToLocal("attribute.name." + (String)tuple.getFirst())));
            }
        }
    }
}

