/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.block.state.BlockStateBase;
import net.minecraft.src.Config;

public class MatchBlock {
    private int blockId = -1;
    private int[] metadatas = null;

    public MatchBlock(int p_i40_1_) {
        this.blockId = p_i40_1_;
    }

    public MatchBlock(int p_i41_1_, int p_i41_2_) {
        this.blockId = p_i41_1_;
        if (p_i41_2_ >= 0 && p_i41_2_ <= 15) {
            this.metadatas = new int[]{p_i41_2_};
        }
    }

    public MatchBlock(int p_i42_1_, int[] p_i42_2_) {
        this.blockId = p_i42_1_;
        this.metadatas = p_i42_2_;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public int[] getMetadatas() {
        return this.metadatas;
    }

    public boolean matches(BlockStateBase p_matches_1_) {
        if (p_matches_1_.getBlockId() != this.blockId) {
            return false;
        }
        if (this.metadatas != null) {
            boolean flag = false;
            int i = p_matches_1_.getMetadata();
            for (int j = 0; j < this.metadatas.length; ++j) {
                int k = this.metadatas[j];
                if (k != i) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
        }
        return true;
    }

    public void addMetadata(int p_addMetadata_1_) {
        if (this.metadatas != null && p_addMetadata_1_ >= 0 && p_addMetadata_1_ <= 15) {
            for (int i = 0; i < this.metadatas.length; ++i) {
                if (this.metadatas[i] != p_addMetadata_1_) continue;
                return;
            }
            this.metadatas = Config.addIntToArray(this.metadatas, p_addMetadata_1_);
        }
    }

    public String toString() {
        return "" + this.blockId + ":" + Config.arrayToString(this.metadatas);
    }
}

