/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.lang.reflect.Method;
import net.minecraft.src.Config;
import net.minecraft.src.Reflector;
import net.minecraft.src.ReflectorClass;

public class ReflectorMethod {
    private ReflectorClass reflectorClass = null;
    private String targetMethodName = null;
    private Class[] targetMethodParameterTypes = null;
    private boolean checked = false;
    private Method targetMethod = null;

    public ReflectorMethod(ReflectorClass p_i62_1_, String p_i62_2_) {
        this(p_i62_1_, p_i62_2_, null, false);
    }

    public ReflectorMethod(ReflectorClass p_i63_1_, String p_i63_2_, Class[] p_i63_3_) {
        this(p_i63_1_, p_i63_2_, p_i63_3_, false);
    }

    public ReflectorMethod(ReflectorClass p_i64_1_, String p_i64_2_, Class[] p_i64_3_, boolean p_i64_4_) {
        this.reflectorClass = p_i64_1_;
        this.targetMethodName = p_i64_2_;
        this.targetMethodParameterTypes = p_i64_3_;
        if (!p_i64_4_) {
            Method method = this.getTargetMethod();
        }
    }

    public Method getTargetMethod() {
        if (this.checked) {
            return this.targetMethod;
        }
        this.checked = true;
        Class oclass = this.reflectorClass.getTargetClass();
        if (oclass == null) {
            return null;
        }
        try {
            Method method;
            Method[] amethod = oclass.getDeclaredMethods();
            int i = 0;
            while (true) {
                Class[] aclass;
                if (i >= amethod.length) {
                    Config.log("(Reflector) Method not present: " + oclass.getName() + "." + this.targetMethodName);
                    return null;
                }
                method = amethod[i];
                if (method.getName().equals(this.targetMethodName) && (this.targetMethodParameterTypes == null || Reflector.matchesTypes(this.targetMethodParameterTypes, aclass = method.getParameterTypes()))) break;
                ++i;
            }
            this.targetMethod = method;
            if (!this.targetMethod.isAccessible()) {
                this.targetMethod.setAccessible(true);
            }
            return this.targetMethod;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        return this.checked ? this.targetMethod != null : this.getTargetMethod() != null;
    }

    public Class getReturnType() {
        Method method = this.getTargetMethod();
        return method == null ? null : method.getReturnType();
    }

    public void deactivate() {
        this.checked = true;
        this.targetMethod = null;
    }
}

