/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandResultStats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TileEntityCommandBlock
extends TileEntity {
    private boolean powered;
    private boolean auto;
    private boolean conditionMet;
    private boolean field_184262_h;
    private final CommandBlockBaseLogic commandBlockLogic = new CommandBlockBaseLogic(){

        @Override
        public BlockPos getPosition() {
            return TileEntityCommandBlock.this.pos;
        }

        @Override
        public Vec3d getPositionVector() {
            return new Vec3d((double)TileEntityCommandBlock.this.pos.getX() + 0.5, (double)TileEntityCommandBlock.this.pos.getY() + 0.5, (double)TileEntityCommandBlock.this.pos.getZ() + 0.5);
        }

        @Override
        public World getEntityWorld() {
            return TileEntityCommandBlock.this.getWorld();
        }

        @Override
        public void setCommand(String command) {
            super.setCommand(command);
            TileEntityCommandBlock.this.markDirty();
        }

        @Override
        public void updateCommand() {
            IBlockState iblockstate = TileEntityCommandBlock.this.worldObj.getBlockState(TileEntityCommandBlock.this.pos);
            TileEntityCommandBlock.this.getWorld().notifyBlockUpdate(TileEntityCommandBlock.this.pos, iblockstate, iblockstate, 3);
        }

        @Override
        public int func_145751_f() {
            return 0;
        }

        @Override
        public void func_145757_a(ByteBuf p_145757_1_) {
            p_145757_1_.writeInt(TileEntityCommandBlock.this.pos.getX());
            p_145757_1_.writeInt(TileEntityCommandBlock.this.pos.getY());
            p_145757_1_.writeInt(TileEntityCommandBlock.this.pos.getZ());
        }

        @Override
        public Entity getCommandSenderEntity() {
            return null;
        }

        @Override
        public MinecraftServer getServer() {
            return TileEntityCommandBlock.this.worldObj.getMinecraftServer();
        }
    };

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        this.commandBlockLogic.writeDataToNBT(compound);
        compound.setBoolean("powered", this.isPowered());
        compound.setBoolean("conditionMet", this.isConditionMet());
        compound.setBoolean("auto", this.isAuto());
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.commandBlockLogic.readDataFromNBT(compound);
        this.setPowered(compound.getBoolean("powered"));
        this.setConditionMet(compound.getBoolean("conditionMet"));
        this.setAuto(compound.getBoolean("auto"));
    }

    @Override
    public Packet<?> getDescriptionPacket() {
        if (this.func_184257_h()) {
            this.func_184252_d(false);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.writeToNBT(nbttagcompound);
            return new SPacketUpdateTileEntity(this.pos, 2, nbttagcompound);
        }
        return null;
    }

    @Override
    public boolean func_183000_F() {
        return true;
    }

    public CommandBlockBaseLogic getCommandBlockLogic() {
        return this.commandBlockLogic;
    }

    public CommandResultStats getCommandResultStats() {
        return this.commandBlockLogic.getCommandResultStats();
    }

    public void setPowered(boolean p_184250_1_) {
        this.powered = p_184250_1_;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setAuto(boolean p_184253_1_) {
        Block block;
        boolean flag = this.auto;
        this.auto = p_184253_1_;
        if (!flag && p_184253_1_ && !this.powered && this.worldObj != null && this.func_184251_i() != Mode.SEQUENCE && (block = this.getBlockType()) instanceof BlockCommandBlock) {
            BlockPos blockpos = this.getPos();
            BlockCommandBlock blockcommandblock = (BlockCommandBlock)block;
            this.conditionMet = !this.func_184258_j() || blockcommandblock.func_185562_e(this.worldObj, blockpos, this.worldObj.getBlockState(blockpos));
            this.worldObj.scheduleUpdate(blockpos, block, block.tickRate(this.worldObj));
            if (this.conditionMet) {
                blockcommandblock.func_185563_c(this.worldObj, blockpos);
            }
        }
    }

    public boolean isConditionMet() {
        return this.conditionMet;
    }

    public void setConditionMet(boolean p_184249_1_) {
        this.conditionMet = p_184249_1_;
    }

    public boolean func_184257_h() {
        return this.field_184262_h;
    }

    public void func_184252_d(boolean p_184252_1_) {
        this.field_184262_h = p_184252_1_;
    }

    public Mode func_184251_i() {
        Block block = this.getBlockType();
        return block == Blocks.command_block ? Mode.REDSTONE : (block == Blocks.repeating_command_block ? Mode.AUTO : (block == Blocks.chain_command_block ? Mode.SEQUENCE : Mode.REDSTONE));
    }

    public boolean func_184258_j() {
        IBlockState iblockstate = this.worldObj.getBlockState(this.getPos());
        return iblockstate.getBlock() instanceof BlockCommandBlock ? iblockstate.getValue(BlockCommandBlock.CONDITIONAL) : false;
    }

    @Override
    public void validate() {
        this.blockType = null;
        super.validate();
    }

    public static enum Mode {
        SEQUENCE,
        AUTO,
        REDSTONE;

    }
}

