/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenEnd;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenForestMutated;
import net.minecraft.world.biome.BiomeGenHell;
import net.minecraft.world.biome.BiomeGenHills;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.biome.BiomeGenMushroomIsland;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.biome.BiomeGenSavanna;
import net.minecraft.world.biome.BiomeGenSavannaMutated;
import net.minecraft.world.biome.BiomeGenSnow;
import net.minecraft.world.biome.BiomeGenStoneBeach;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraft.world.biome.BiomeGenTaiga;
import net.minecraft.world.biome.BiomeVoid;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BiomeGenBase {
    private static final Logger logger = LogManager.getLogger();
    protected static final IBlockState STONE = Blocks.stone.getDefaultState();
    protected static final IBlockState AIR = Blocks.air.getDefaultState();
    protected static final IBlockState BEDROCK = Blocks.bedrock.getDefaultState();
    protected static final IBlockState GRAVEL = Blocks.gravel.getDefaultState();
    protected static final IBlockState RED_SANDSTONE = Blocks.red_sandstone.getDefaultState();
    protected static final IBlockState SANDSTONE = Blocks.sandstone.getDefaultState();
    protected static final IBlockState ICE = Blocks.ice.getDefaultState();
    protected static final IBlockState WATER = Blocks.water.getDefaultState();
    public static final Set<BiomeGenBase> explorationBiomesList = Sets.newHashSet();
    public static final ObjectIntIdentityMap<BiomeGenBase> MUTATION_TO_BASE_ID_MAP = new ObjectIntIdentityMap();
    protected static final NoiseGeneratorPerlin temperatureNoise = new NoiseGeneratorPerlin(new Random(1234L), 1);
    protected static final NoiseGeneratorPerlin GRASS_COLOR_NOISE = new NoiseGeneratorPerlin(new Random(2345L), 1);
    protected static final WorldGenDoublePlant DOUBLE_PLANT_GENERATOR = new WorldGenDoublePlant();
    protected static final WorldGenTrees worldGeneratorTrees = new WorldGenTrees(false);
    protected static final WorldGenBigTree worldGeneratorBigTree = new WorldGenBigTree(false);
    protected static final WorldGenSwamp worldGeneratorSwamp = new WorldGenSwamp();
    public static final RegistryNamespaced<ResourceLocation, BiomeGenBase> biomeRegistry = new RegistryNamespaced();
    private final String biomeName;
    private final float baseHeight;
    private final float heightVariation;
    private final float temperature;
    private final float rainfall;
    private final int waterColor;
    private final boolean enableSnow;
    private final boolean enableRain;
    private final String baseBiomeRegName;
    public IBlockState topBlock = Blocks.grass.getDefaultState();
    public IBlockState fillerBlock = Blocks.dirt.getDefaultState();
    public BiomeDecorator theBiomeDecorator;
    protected List<SpawnListEntry> spawnableMonsterList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableCreatureList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableWaterCreatureList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableCaveCreatureList = Lists.newArrayList();

    public static int getIdForBiome(BiomeGenBase biome) {
        return biomeRegistry.getIDForObject(biome);
    }

    public static BiomeGenBase getBiomeForId(int id) {
        return biomeRegistry.getObjectById(id);
    }

    public static BiomeGenBase getMutationForBiome(BiomeGenBase biome) {
        return MUTATION_TO_BASE_ID_MAP.getByValue(BiomeGenBase.getIdForBiome(biome));
    }

    protected BiomeGenBase(BiomeProperties properties) {
        this.biomeName = properties.biomeName;
        this.baseHeight = properties.baseHeight;
        this.heightVariation = properties.heightVariation;
        this.temperature = properties.temperature;
        this.rainfall = properties.rainfall;
        this.waterColor = properties.waterColor;
        this.enableSnow = properties.enableSnow;
        this.enableRain = properties.enableRain;
        this.baseBiomeRegName = properties.baseBiomeRegName;
        this.theBiomeDecorator = this.createBiomeDecorator();
        this.spawnableCreatureList.add(new SpawnListEntry(EntitySheep.class, 12, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityPig.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityCow.class, 8, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySpider.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombie.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySkeleton.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityCreeper.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySlime.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityEnderman.class, 10, 1, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityWitch.class, 5, 1, 1));
        this.spawnableWaterCreatureList.add(new SpawnListEntry(EntitySquid.class, 10, 4, 4));
        this.spawnableCaveCreatureList.add(new SpawnListEntry(EntityBat.class, 10, 8, 8));
    }

    protected BiomeDecorator createBiomeDecorator() {
        return new BiomeDecorator();
    }

    public boolean isMutation() {
        return this.baseBiomeRegName != null;
    }

    public WorldGenAbstractTree genBigTreeChance(Random rand) {
        return rand.nextInt(10) == 0 ? worldGeneratorBigTree : worldGeneratorTrees;
    }

    public WorldGenerator getRandomWorldGenForGrass(Random rand) {
        return new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public BlockFlower.EnumFlowerType pickRandomFlower(Random rand, BlockPos pos) {
        return rand.nextInt(3) > 0 ? BlockFlower.EnumFlowerType.DANDELION : BlockFlower.EnumFlowerType.POPPY;
    }

    public int getSkyColorByTemp(float p_76731_1_) {
        p_76731_1_ /= 3.0f;
        p_76731_1_ = MathHelper.clamp_float(p_76731_1_, -1.0f, 1.0f);
        return MathHelper.hsvToRGB(0.62222224f - p_76731_1_ * 0.05f, 0.5f + p_76731_1_ * 0.1f, 1.0f);
    }

    public List<SpawnListEntry> getSpawnableList(EnumCreatureType creatureType) {
        switch (creatureType) {
            case MONSTER: {
                return this.spawnableMonsterList;
            }
            case CREATURE: {
                return this.spawnableCreatureList;
            }
            case WATER_CREATURE: {
                return this.spawnableWaterCreatureList;
            }
            case AMBIENT: {
                return this.spawnableCaveCreatureList;
            }
        }
        return Collections.emptyList();
    }

    public boolean getEnableSnow() {
        return this.isSnowyBiome();
    }

    public boolean canRain() {
        return this.isSnowyBiome() ? false : this.enableRain;
    }

    public boolean isHighHumidity() {
        return this.getRainfall() > 0.85f;
    }

    public float getSpawningChance() {
        return 0.1f;
    }

    public final float getFloatTemperature(BlockPos pos) {
        if (pos.getY() > 64) {
            float f = (float)(temperatureNoise.func_151601_a((float)pos.getX() / 8.0f, (float)pos.getZ() / 8.0f) * 4.0);
            return this.getTemperature() - (f + (float)pos.getY() - 64.0f) * 0.05f / 30.0f;
        }
        return this.getTemperature();
    }

    public void decorate(World worldIn, Random rand, BlockPos pos) {
        this.theBiomeDecorator.decorate(worldIn, rand, this, pos);
    }

    public int getGrassColorAtPos(BlockPos pos) {
        double d0 = MathHelper.clamp_float(this.getFloatTemperature(pos), 0.0f, 1.0f);
        double d1 = MathHelper.clamp_float(this.getRainfall(), 0.0f, 1.0f);
        return ColorizerGrass.getGrassColor(d0, d1);
    }

    public int getFoliageColorAtPos(BlockPos pos) {
        double d0 = MathHelper.clamp_float(this.getFloatTemperature(pos), 0.0f, 1.0f);
        double d1 = MathHelper.clamp_float(this.getRainfall(), 0.0f, 1.0f);
        return ColorizerFoliage.getFoliageColor(d0, d1);
    }

    public void genTerrainBlocks(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateBiomeTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public final void generateBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.getSeaLevel();
        IBlockState iblockstate = this.topBlock;
        IBlockState iblockstate1 = this.fillerBlock;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.setBlockState(i1, j1, l, BEDROCK);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.getBlockState(i1, j1, l);
            if (iblockstate2.getMaterial() == Material.air) {
                j = -1;
                continue;
            }
            if (iblockstate2.getBlock() != Blocks.stone) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.topBlock;
                    iblockstate1 = this.fillerBlock;
                }
                if (j1 < i && (iblockstate == null || iblockstate.getMaterial() == Material.air)) {
                    iblockstate = this.getFloatTemperature(blockpos$mutableblockpos.set(x, j1, z)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.setBlockState(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = STONE;
                    chunkPrimerIn.setBlockState(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.setBlockState(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.setBlockState(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.getBlock() != Blocks.sand) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.getValue(BlockSand.VARIANT) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    public Class<? extends BiomeGenBase> getBiomeClass() {
        return this.getClass();
    }

    public TempCategory getTempCategory() {
        return (double)this.getTemperature() < 0.2 ? TempCategory.COLD : ((double)this.getTemperature() < 1.0 ? TempCategory.MEDIUM : TempCategory.WARM);
    }

    public static BiomeGenBase getBiome(int id) {
        return BiomeGenBase.getBiomeFromBiomeList(id, null);
    }

    public static BiomeGenBase getBiomeFromBiomeList(int biomeId, BiomeGenBase biome) {
        BiomeGenBase biomegenbase = BiomeGenBase.getBiomeForId(biomeId);
        return biomegenbase == null ? biome : biomegenbase;
    }

    public boolean ignorePlayerSpawnSuitability() {
        return false;
    }

    public final float getBaseHeight() {
        return this.baseHeight;
    }

    public final float getRainfall() {
        return this.rainfall;
    }

    public final String getBiomeName() {
        return this.biomeName;
    }

    public final float getHeightVariation() {
        return this.heightVariation;
    }

    public final float getTemperature() {
        return this.temperature;
    }

    public final int getWaterColor() {
        return this.waterColor;
    }

    public final boolean isSnowyBiome() {
        return this.enableSnow;
    }

    public static void registerBiomes() {
        BiomeGenBase.registerBiome(0, "ocean", new BiomeGenOcean(new BiomeProperties("Ocean").setBaseHeight(-1.0f).setHeightVariation(0.1f)));
        BiomeGenBase.registerBiome(1, "plains", new BiomeGenPlains(false, new BiomeProperties("Plains").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(0.8f).setRainfall(0.4f)));
        BiomeGenBase.registerBiome(2, "desert", new BiomeGenDesert(new BiomeProperties("Desert").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(3, "extreme_hills", new BiomeGenHills(BiomeGenHills.Type.NORMAL, new BiomeProperties("Extreme Hills").setBaseHeight(1.0f).setHeightVariation(0.5f).setTemperature(0.2f).setRainfall(0.3f)));
        BiomeGenBase.registerBiome(4, "forest", new BiomeGenForest(BiomeGenForest.Type.NORMAL, new BiomeProperties("Forest").setTemperature(0.7f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(5, "taiga", new BiomeGenTaiga(BiomeGenTaiga.Type.NORMAL, new BiomeProperties("Taiga").setBaseHeight(0.2f).setHeightVariation(0.2f).setTemperature(0.25f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(6, "swampland", new BiomeGenSwamp(new BiomeProperties("Swampland").setBaseHeight(-0.2f).setHeightVariation(0.1f).setTemperature(0.8f).setRainfall(0.9f).setWaterColor(14745518)));
        BiomeGenBase.registerBiome(7, "river", new BiomeGenRiver(new BiomeProperties("River").setBaseHeight(-0.5f).setHeightVariation(0.0f)));
        BiomeGenBase.registerBiome(8, "hell", new BiomeGenHell(new BiomeProperties("Hell").setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(9, "sky", new BiomeGenEnd(new BiomeProperties("The End").setRainDisabled()));
        BiomeGenBase.registerBiome(10, "frozen_ocean", new BiomeGenOcean(new BiomeProperties("FrozenOcean").setBaseHeight(-1.0f).setHeightVariation(0.1f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        BiomeGenBase.registerBiome(11, "frozen_river", new BiomeGenRiver(new BiomeProperties("FrozenRiver").setBaseHeight(-0.5f).setHeightVariation(0.0f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        BiomeGenBase.registerBiome(12, "ice_flats", new BiomeGenSnow(false, new BiomeProperties("Ice Plains").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        BiomeGenBase.registerBiome(13, "ice_mountains", new BiomeGenSnow(false, new BiomeProperties("Ice Mountains").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        BiomeGenBase.registerBiome(14, "mushroom_island", new BiomeGenMushroomIsland(new BiomeProperties("MushroomIsland").setBaseHeight(0.2f).setHeightVariation(0.3f).setTemperature(0.9f).setRainfall(1.0f)));
        BiomeGenBase.registerBiome(15, "mushroom_island_shore", new BiomeGenMushroomIsland(new BiomeProperties("MushroomIslandShore").setBaseHeight(0.0f).setHeightVariation(0.025f).setTemperature(0.9f).setRainfall(1.0f)));
        BiomeGenBase.registerBiome(16, "beaches", new BiomeGenBeach(new BiomeProperties("Beach").setBaseHeight(0.0f).setHeightVariation(0.025f).setTemperature(0.8f).setRainfall(0.4f)));
        BiomeGenBase.registerBiome(17, "desert_hills", new BiomeGenDesert(new BiomeProperties("DesertHills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(18, "forest_hills", new BiomeGenForest(BiomeGenForest.Type.NORMAL, new BiomeProperties("ForestHills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.7f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(19, "taiga_hills", new BiomeGenTaiga(BiomeGenTaiga.Type.NORMAL, new BiomeProperties("TaigaHills").setTemperature(0.25f).setRainfall(0.8f).setBaseHeight(0.45f).setHeightVariation(0.3f)));
        BiomeGenBase.registerBiome(20, "smaller_extreme_hills", new BiomeGenHills(BiomeGenHills.Type.EXTRA_TREES, new BiomeProperties("Extreme Hills Edge").setBaseHeight(0.8f).setHeightVariation(0.3f).setTemperature(0.2f).setRainfall(0.3f)));
        BiomeGenBase.registerBiome(21, "jungle", new BiomeGenJungle(false, new BiomeProperties("Jungle").setTemperature(0.95f).setRainfall(0.9f)));
        BiomeGenBase.registerBiome(22, "jungle_hills", new BiomeGenJungle(false, new BiomeProperties("JungleHills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.95f).setRainfall(0.9f)));
        BiomeGenBase.registerBiome(23, "jungle_edge", new BiomeGenJungle(true, new BiomeProperties("JungleEdge").setTemperature(0.95f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(24, "deep_ocean", new BiomeGenOcean(new BiomeProperties("Deep Ocean").setBaseHeight(-1.8f).setHeightVariation(0.1f)));
        BiomeGenBase.registerBiome(25, "stone_beach", new BiomeGenStoneBeach(new BiomeProperties("Stone Beach").setBaseHeight(0.1f).setHeightVariation(0.8f).setTemperature(0.2f).setRainfall(0.3f)));
        BiomeGenBase.registerBiome(26, "cold_beach", new BiomeGenBeach(new BiomeProperties("Cold Beach").setBaseHeight(0.0f).setHeightVariation(0.025f).setTemperature(0.05f).setRainfall(0.3f).setSnowEnabled()));
        BiomeGenBase.registerBiome(27, "birch_forest", new BiomeGenForest(BiomeGenForest.Type.BIRCH, new BiomeProperties("Birch Forest").setTemperature(0.6f).setRainfall(0.6f)));
        BiomeGenBase.registerBiome(28, "birch_forest_hills", new BiomeGenForest(BiomeGenForest.Type.BIRCH, new BiomeProperties("Birch Forest Hills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.6f).setRainfall(0.6f)));
        BiomeGenBase.registerBiome(29, "roofed_forest", new BiomeGenForest(BiomeGenForest.Type.ROOFED, new BiomeProperties("Roofed Forest").setTemperature(0.7f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(30, "taiga_cold", new BiomeGenTaiga(BiomeGenTaiga.Type.NORMAL, new BiomeProperties("Cold Taiga").setBaseHeight(0.2f).setHeightVariation(0.2f).setTemperature(-0.5f).setRainfall(0.4f).setSnowEnabled()));
        BiomeGenBase.registerBiome(31, "taiga_cold_hills", new BiomeGenTaiga(BiomeGenTaiga.Type.NORMAL, new BiomeProperties("Cold Taiga Hills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(-0.5f).setRainfall(0.4f).setSnowEnabled()));
        BiomeGenBase.registerBiome(32, "redwood_taiga", new BiomeGenTaiga(BiomeGenTaiga.Type.MEGA, new BiomeProperties("Mega Taiga").setTemperature(0.3f).setRainfall(0.8f).setBaseHeight(0.2f).setHeightVariation(0.2f)));
        BiomeGenBase.registerBiome(33, "redwood_taiga_hills", new BiomeGenTaiga(BiomeGenTaiga.Type.MEGA, new BiomeProperties("Mega Taiga Hills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.3f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(34, "extreme_hills_with_trees", new BiomeGenHills(BiomeGenHills.Type.EXTRA_TREES, new BiomeProperties("Extreme Hills+").setBaseHeight(1.0f).setHeightVariation(0.5f).setTemperature(0.2f).setRainfall(0.3f)));
        BiomeGenBase.registerBiome(35, "savanna", new BiomeGenSavanna(new BiomeProperties("Savanna").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(1.2f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(36, "savanna_rock", new BiomeGenSavanna(new BiomeProperties("Savanna Plateau").setBaseHeight(1.5f).setHeightVariation(0.025f).setTemperature(1.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(37, "mesa", new BiomeGenMesa(false, false, new BiomeProperties("Mesa").setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(38, "mesa_rock", new BiomeGenMesa(false, true, new BiomeProperties("Mesa Plateau F").setBaseHeight(1.5f).setHeightVariation(0.025f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(39, "mesa_clear_rock", new BiomeGenMesa(false, false, new BiomeProperties("Mesa Plateau").setBaseHeight(1.5f).setHeightVariation(0.025f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(127, "void", new BiomeVoid(new BiomeProperties("The Void").setRainDisabled()));
        BiomeGenBase.registerBiome(129, "mutated_plains", new BiomeGenPlains(true, new BiomeProperties("Sunflower Plains").setBaseBiome("plains").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(0.8f).setRainfall(0.4f)));
        BiomeGenBase.registerBiome(130, "mutated_desert", new BiomeGenDesert(new BiomeProperties("Desert M").setBaseBiome("desert").setBaseHeight(0.225f).setHeightVariation(0.25f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(131, "mutated_extreme_hills", new BiomeGenHills(BiomeGenHills.Type.MUTATED, new BiomeProperties("Extreme Hills M").setBaseBiome("extreme_hills").setBaseHeight(1.0f).setHeightVariation(0.5f).setTemperature(0.2f).setRainfall(0.3f)));
        BiomeGenBase.registerBiome(132, "mutated_forest", new BiomeGenForest(BiomeGenForest.Type.FLOWER, new BiomeProperties("Flower Forest").setBaseBiome("forest").setHeightVariation(0.4f).setTemperature(0.7f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(133, "mutated_taiga", new BiomeGenTaiga(BiomeGenTaiga.Type.NORMAL, new BiomeProperties("Taiga M").setBaseBiome("taiga").setBaseHeight(0.3f).setHeightVariation(0.4f).setTemperature(0.25f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(134, "mutated_swampland", new BiomeGenSwamp(new BiomeProperties("Swampland M").setBaseBiome("swampland").setBaseHeight(-0.1f).setHeightVariation(0.3f).setTemperature(0.8f).setRainfall(0.9f).setWaterColor(14745518)));
        BiomeGenBase.registerBiome(140, "mutated_ice_flats", new BiomeGenSnow(true, new BiomeProperties("Ice Plains Spikes").setBaseBiome("ice_flats").setBaseHeight(0.425f).setHeightVariation(0.45000002f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        BiomeGenBase.registerBiome(149, "mutated_jungle", new BiomeGenJungle(false, new BiomeProperties("Jungle M").setBaseBiome("jungle").setBaseHeight(0.2f).setHeightVariation(0.4f).setTemperature(0.95f).setRainfall(0.9f)));
        BiomeGenBase.registerBiome(151, "mutated_jungle_edge", new BiomeGenJungle(true, new BiomeProperties("JungleEdge M").setBaseBiome("jungle_edge").setBaseHeight(0.2f).setHeightVariation(0.4f).setTemperature(0.95f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(155, "mutated_birch_forest", new BiomeGenForestMutated(new BiomeProperties("Birch Forest M").setBaseBiome("birch_forest").setBaseHeight(0.2f).setHeightVariation(0.4f).setTemperature(0.6f).setRainfall(0.6f)));
        BiomeGenBase.registerBiome(156, "mutated_birch_forest_hills", new BiomeGenForestMutated(new BiomeProperties("Birch Forest Hills M").setBaseBiome("birch_forest").setBaseHeight(0.55f).setHeightVariation(0.5f).setTemperature(0.6f).setRainfall(0.6f)));
        BiomeGenBase.registerBiome(157, "mutated_roofed_forest", new BiomeGenForest(BiomeGenForest.Type.ROOFED, new BiomeProperties("Roofed Forest M").setBaseBiome("roofed_forest").setBaseHeight(0.2f).setHeightVariation(0.4f).setTemperature(0.7f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(158, "mutated_taiga_cold", new BiomeGenTaiga(BiomeGenTaiga.Type.NORMAL, new BiomeProperties("Cold Taiga M").setBaseBiome("taiga_cold").setBaseHeight(0.3f).setHeightVariation(0.4f).setTemperature(-0.5f).setRainfall(0.4f).setSnowEnabled()));
        BiomeGenBase.registerBiome(160, "mutated_redwood_taiga", new BiomeGenTaiga(BiomeGenTaiga.Type.MEGA_SPRUCE, new BiomeProperties("Mega Spruce Taiga").setBaseBiome("redwood_taiga").setBaseHeight(0.2f).setHeightVariation(0.2f).setTemperature(0.25f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(161, "mutated_redwood_taiga_hills", new BiomeGenTaiga(BiomeGenTaiga.Type.MEGA_SPRUCE, new BiomeProperties("Redwood Taiga Hills M").setBaseBiome("redwood_taiga_hills").setBaseHeight(0.2f).setHeightVariation(0.2f).setTemperature(0.25f).setRainfall(0.8f)));
        BiomeGenBase.registerBiome(162, "mutated_extreme_hills_with_trees", new BiomeGenHills(BiomeGenHills.Type.MUTATED, new BiomeProperties("Extreme Hills+ M").setBaseBiome("extreme_hills_with_trees").setBaseHeight(1.0f).setHeightVariation(0.5f).setTemperature(0.2f).setRainfall(0.3f)));
        BiomeGenBase.registerBiome(163, "mutated_savanna", new BiomeGenSavannaMutated(new BiomeProperties("Savanna M").setBaseBiome("savanna").setBaseHeight(0.3625f).setHeightVariation(1.225f).setTemperature(1.1f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(164, "mutated_savanna_rock", new BiomeGenSavannaMutated(new BiomeProperties("Savanna Plateau M").setBaseBiome("savanna_rock").setBaseHeight(1.05f).setHeightVariation(1.2125001f).setTemperature(1.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(165, "mutated_mesa", new BiomeGenMesa(true, false, new BiomeProperties("Mesa (Bryce)").setBaseBiome("mesa").setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(166, "mutated_mesa_rock", new BiomeGenMesa(false, true, new BiomeProperties("Mesa Plateau F M").setBaseBiome("mesa_rock").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        BiomeGenBase.registerBiome(167, "mutated_mesa_clear_rock", new BiomeGenMesa(false, false, new BiomeProperties("Mesa Plateau M").setBaseBiome("mesa_clear_rock").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Collections.addAll(explorationBiomesList, Biomes.ocean, Biomes.plains, Biomes.desert, Biomes.extremeHills, Biomes.forest, Biomes.taiga, Biomes.swampland, Biomes.river, Biomes.frozenRiver, Biomes.icePlains, Biomes.iceMountains, Biomes.mushroomIsland, Biomes.mushroomIslandShore, Biomes.beach, Biomes.desertHills, Biomes.forestHills, Biomes.taigaHills, Biomes.jungle, Biomes.jungleHills, Biomes.jungleEdge, Biomes.deepOcean, Biomes.stoneBeach, Biomes.coldBeach, Biomes.birchForest, Biomes.birchForestHills, Biomes.roofedForest, Biomes.coldTaiga, Biomes.coldTaigaHills, Biomes.megaTaiga, Biomes.megaTaigaHills, Biomes.extremeHillsPlus, Biomes.savanna, Biomes.savannaPlateau, Biomes.mesa, Biomes.mesaPlateau_F, Biomes.mesaPlateau);
    }

    private static void registerBiome(int id, String name, BiomeGenBase biome) {
        biomeRegistry.register(id, new ResourceLocation(name), biome);
        if (biome.isMutation()) {
            MUTATION_TO_BASE_ID_MAP.put(biome, BiomeGenBase.getIdForBiome(biomeRegistry.getObject(new ResourceLocation(biome.baseBiomeRegName))));
        }
    }

    public static enum TempCategory {
        OCEAN,
        COLD,
        MEDIUM,
        WARM;

    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public Class<? extends EntityLiving> entityClass;
        public int minGroupCount;
        public int maxGroupCount;

        public SpawnListEntry(Class<? extends EntityLiving> entityclassIn, int weight, int groupCountMin, int groupCountMax) {
            super(weight);
            this.entityClass = entityclassIn;
            this.minGroupCount = groupCountMin;
            this.maxGroupCount = groupCountMax;
        }

        public String toString() {
            return this.entityClass.getSimpleName() + "*(" + this.minGroupCount + "-" + this.maxGroupCount + "):" + this.itemWeight;
        }
    }

    public static class BiomeProperties {
        private final String biomeName;
        private float baseHeight = 0.1f;
        private float heightVariation = 0.2f;
        private float temperature = 0.5f;
        private float rainfall = 0.5f;
        private int waterColor = 0xFFFFFF;
        private boolean enableSnow;
        private boolean enableRain = true;
        private String baseBiomeRegName;

        public BiomeProperties(String nameIn) {
            this.biomeName = nameIn;
        }

        protected BiomeProperties setTemperature(float temperatureIn) {
            if (temperatureIn > 0.1f && temperatureIn < 0.2f) {
                throw new IllegalArgumentException("Please avoid temperatures in the range 0.1 - 0.2 because of snow");
            }
            this.temperature = temperatureIn;
            return this;
        }

        protected BiomeProperties setRainfall(float rainfallIn) {
            this.rainfall = rainfallIn;
            return this;
        }

        protected BiomeProperties setBaseHeight(float baseHeightIn) {
            this.baseHeight = baseHeightIn;
            return this;
        }

        protected BiomeProperties setHeightVariation(float heightVariationIn) {
            this.heightVariation = heightVariationIn;
            return this;
        }

        protected BiomeProperties setRainDisabled() {
            this.enableRain = false;
            return this;
        }

        protected BiomeProperties setSnowEnabled() {
            this.enableSnow = true;
            return this;
        }

        protected BiomeProperties setWaterColor(int waterColorIn) {
            this.waterColor = waterColorIn;
            return this;
        }

        protected BiomeProperties setBaseBiome(String nameIn) {
            this.baseBiomeRegName = nameIn;
            return this;
        }
    }
}

