/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import net.minecraft.init.Biomes;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerBiome
extends GenLayer {
    private BiomeGenBase[] field_151623_c = new BiomeGenBase[]{Biomes.desert, Biomes.desert, Biomes.desert, Biomes.savanna, Biomes.savanna, Biomes.plains};
    private BiomeGenBase[] field_151621_d = new BiomeGenBase[]{Biomes.forest, Biomes.roofedForest, Biomes.extremeHills, Biomes.plains, Biomes.birchForest, Biomes.swampland};
    private BiomeGenBase[] field_151622_e = new BiomeGenBase[]{Biomes.forest, Biomes.extremeHills, Biomes.taiga, Biomes.plains};
    private BiomeGenBase[] field_151620_f = new BiomeGenBase[]{Biomes.icePlains, Biomes.icePlains, Biomes.icePlains, Biomes.coldTaiga};
    private final ChunkProviderSettings field_175973_g;

    public GenLayerBiome(long p_i45560_1_, GenLayer p_i45560_3_, WorldType p_i45560_4_, String p_i45560_5_) {
        super(p_i45560_1_);
        this.parent = p_i45560_3_;
        if (p_i45560_4_ == WorldType.DEFAULT_1_1) {
            this.field_151623_c = new BiomeGenBase[]{Biomes.desert, Biomes.forest, Biomes.extremeHills, Biomes.swampland, Biomes.plains, Biomes.taiga};
            this.field_175973_g = null;
        } else {
            this.field_175973_g = p_i45560_4_ == WorldType.CUSTOMIZED ? ChunkProviderSettings.Factory.jsonToFactory(p_i45560_5_).func_177864_b() : null;
        }
    }

    @Override
    public int[] getInts(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.parent.getInts(areaX, areaY, areaWidth, areaHeight);
        int[] aint1 = IntCache.getIntCache(areaWidth * areaHeight);
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.initChunkSeed(j + areaX, i + areaY);
                int k = aint[j + i * areaWidth];
                int l = (k & 0xF00) >> 8;
                k &= 0xFFFFF0FF;
                if (this.field_175973_g != null && this.field_175973_g.fixedBiome >= 0) {
                    aint1[j + i * areaWidth] = this.field_175973_g.fixedBiome;
                    continue;
                }
                if (GenLayerBiome.isBiomeOceanic(k)) {
                    aint1[j + i * areaWidth] = k;
                    continue;
                }
                if (k == BiomeGenBase.getIdForBiome(Biomes.mushroomIsland)) {
                    aint1[j + i * areaWidth] = k;
                    continue;
                }
                if (k == 1) {
                    if (l > 0) {
                        if (this.nextInt(3) == 0) {
                            aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(Biomes.mesaPlateau);
                            continue;
                        }
                        aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(Biomes.mesaPlateau_F);
                        continue;
                    }
                    aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(this.field_151623_c[this.nextInt(this.field_151623_c.length)]);
                    continue;
                }
                if (k == 2) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(Biomes.jungle);
                        continue;
                    }
                    aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(this.field_151621_d[this.nextInt(this.field_151621_d.length)]);
                    continue;
                }
                if (k == 3) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(Biomes.megaTaiga);
                        continue;
                    }
                    aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(this.field_151622_e[this.nextInt(this.field_151622_e.length)]);
                    continue;
                }
                aint1[j + i * areaWidth] = k == 4 ? BiomeGenBase.getIdForBiome(this.field_151620_f[this.nextInt(this.field_151620_f.length)]) : BiomeGenBase.getIdForBiome(Biomes.mushroomIsland);
            }
        }
        return aint1;
    }
}

