/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import net.minecraft.init.Biomes;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerBiomeEdge
extends GenLayer {
    public GenLayerBiomeEdge(long p_i45475_1_, GenLayer p_i45475_3_) {
        super(p_i45475_1_);
        this.parent = p_i45475_3_;
    }

    @Override
    public int[] getInts(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.parent.getInts(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] aint1 = IntCache.getIntCache(areaWidth * areaHeight);
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.initChunkSeed(j + areaX, i + areaY);
                int k = aint[j + 1 + (i + 1) * (areaWidth + 2)];
                if (this.replaceBiomeEdgeIfNecessary(aint, aint1, j, i, areaWidth, k, BiomeGenBase.getIdForBiome(Biomes.extremeHills), BiomeGenBase.getIdForBiome(Biomes.extremeHillsEdge)) || this.replaceBiomeEdge(aint, aint1, j, i, areaWidth, k, BiomeGenBase.getIdForBiome(Biomes.mesaPlateau_F), BiomeGenBase.getIdForBiome(Biomes.mesa)) || this.replaceBiomeEdge(aint, aint1, j, i, areaWidth, k, BiomeGenBase.getIdForBiome(Biomes.mesaPlateau), BiomeGenBase.getIdForBiome(Biomes.mesa)) || this.replaceBiomeEdge(aint, aint1, j, i, areaWidth, k, BiomeGenBase.getIdForBiome(Biomes.megaTaiga), BiomeGenBase.getIdForBiome(Biomes.taiga))) continue;
                if (k == BiomeGenBase.getIdForBiome(Biomes.desert)) {
                    int l1 = aint[j + 1 + (i + 1 - 1) * (areaWidth + 2)];
                    int i2 = aint[j + 1 + 1 + (i + 1) * (areaWidth + 2)];
                    int j2 = aint[j + 1 - 1 + (i + 1) * (areaWidth + 2)];
                    int k2 = aint[j + 1 + (i + 1 + 1) * (areaWidth + 2)];
                    if (l1 != BiomeGenBase.getIdForBiome(Biomes.icePlains) && i2 != BiomeGenBase.getIdForBiome(Biomes.icePlains) && j2 != BiomeGenBase.getIdForBiome(Biomes.icePlains) && k2 != BiomeGenBase.getIdForBiome(Biomes.icePlains)) {
                        aint1[j + i * areaWidth] = k;
                        continue;
                    }
                    aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(Biomes.extremeHillsPlus);
                    continue;
                }
                if (k == BiomeGenBase.getIdForBiome(Biomes.swampland)) {
                    int l = aint[j + 1 + (i + 1 - 1) * (areaWidth + 2)];
                    int i1 = aint[j + 1 + 1 + (i + 1) * (areaWidth + 2)];
                    int j1 = aint[j + 1 - 1 + (i + 1) * (areaWidth + 2)];
                    int k1 = aint[j + 1 + (i + 1 + 1) * (areaWidth + 2)];
                    if (l != BiomeGenBase.getIdForBiome(Biomes.desert) && i1 != BiomeGenBase.getIdForBiome(Biomes.desert) && j1 != BiomeGenBase.getIdForBiome(Biomes.desert) && k1 != BiomeGenBase.getIdForBiome(Biomes.desert) && l != BiomeGenBase.getIdForBiome(Biomes.coldTaiga) && i1 != BiomeGenBase.getIdForBiome(Biomes.coldTaiga) && j1 != BiomeGenBase.getIdForBiome(Biomes.coldTaiga) && k1 != BiomeGenBase.getIdForBiome(Biomes.coldTaiga) && l != BiomeGenBase.getIdForBiome(Biomes.icePlains) && i1 != BiomeGenBase.getIdForBiome(Biomes.icePlains) && j1 != BiomeGenBase.getIdForBiome(Biomes.icePlains) && k1 != BiomeGenBase.getIdForBiome(Biomes.icePlains)) {
                        if (l != BiomeGenBase.getIdForBiome(Biomes.jungle) && k1 != BiomeGenBase.getIdForBiome(Biomes.jungle) && i1 != BiomeGenBase.getIdForBiome(Biomes.jungle) && j1 != BiomeGenBase.getIdForBiome(Biomes.jungle)) {
                            aint1[j + i * areaWidth] = k;
                            continue;
                        }
                        aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(Biomes.jungleEdge);
                        continue;
                    }
                    aint1[j + i * areaWidth] = BiomeGenBase.getIdForBiome(Biomes.plains);
                    continue;
                }
                aint1[j + i * areaWidth] = k;
            }
        }
        return aint1;
    }

    private boolean replaceBiomeEdgeIfNecessary(int[] p_151636_1_, int[] p_151636_2_, int p_151636_3_, int p_151636_4_, int p_151636_5_, int p_151636_6_, int p_151636_7_, int p_151636_8_) {
        if (!GenLayerBiomeEdge.biomesEqualOrMesaPlateau(p_151636_6_, p_151636_7_)) {
            return false;
        }
        int i = p_151636_1_[p_151636_3_ + 1 + (p_151636_4_ + 1 - 1) * (p_151636_5_ + 2)];
        int j = p_151636_1_[p_151636_3_ + 1 + 1 + (p_151636_4_ + 1) * (p_151636_5_ + 2)];
        int k = p_151636_1_[p_151636_3_ + 1 - 1 + (p_151636_4_ + 1) * (p_151636_5_ + 2)];
        int l = p_151636_1_[p_151636_3_ + 1 + (p_151636_4_ + 1 + 1) * (p_151636_5_ + 2)];
        p_151636_2_[p_151636_3_ + p_151636_4_ * p_151636_5_] = this.canBiomesBeNeighbors(i, p_151636_7_) && this.canBiomesBeNeighbors(j, p_151636_7_) && this.canBiomesBeNeighbors(k, p_151636_7_) && this.canBiomesBeNeighbors(l, p_151636_7_) ? p_151636_6_ : p_151636_8_;
        return true;
    }

    private boolean replaceBiomeEdge(int[] p_151635_1_, int[] p_151635_2_, int p_151635_3_, int p_151635_4_, int p_151635_5_, int p_151635_6_, int p_151635_7_, int p_151635_8_) {
        if (p_151635_6_ != p_151635_7_) {
            return false;
        }
        int i = p_151635_1_[p_151635_3_ + 1 + (p_151635_4_ + 1 - 1) * (p_151635_5_ + 2)];
        int j = p_151635_1_[p_151635_3_ + 1 + 1 + (p_151635_4_ + 1) * (p_151635_5_ + 2)];
        int k = p_151635_1_[p_151635_3_ + 1 - 1 + (p_151635_4_ + 1) * (p_151635_5_ + 2)];
        int l = p_151635_1_[p_151635_3_ + 1 + (p_151635_4_ + 1 + 1) * (p_151635_5_ + 2)];
        p_151635_2_[p_151635_3_ + p_151635_4_ * p_151635_5_] = GenLayerBiomeEdge.biomesEqualOrMesaPlateau(i, p_151635_7_) && GenLayerBiomeEdge.biomesEqualOrMesaPlateau(j, p_151635_7_) && GenLayerBiomeEdge.biomesEqualOrMesaPlateau(k, p_151635_7_) && GenLayerBiomeEdge.biomesEqualOrMesaPlateau(l, p_151635_7_) ? p_151635_6_ : p_151635_8_;
        return true;
    }

    private boolean canBiomesBeNeighbors(int p_151634_1_, int p_151634_2_) {
        if (GenLayerBiomeEdge.biomesEqualOrMesaPlateau(p_151634_1_, p_151634_2_)) {
            return true;
        }
        BiomeGenBase biomegenbase = BiomeGenBase.getBiome(p_151634_1_);
        BiomeGenBase biomegenbase1 = BiomeGenBase.getBiome(p_151634_2_);
        if (biomegenbase != null && biomegenbase1 != null) {
            BiomeGenBase.TempCategory biomegenbase$tempcategory1;
            BiomeGenBase.TempCategory biomegenbase$tempcategory = biomegenbase.getTempCategory();
            return biomegenbase$tempcategory == (biomegenbase$tempcategory1 = biomegenbase1.getTempCategory()) || biomegenbase$tempcategory == BiomeGenBase.TempCategory.MEDIUM || biomegenbase$tempcategory1 == BiomeGenBase.TempCategory.MEDIUM;
        }
        return false;
    }
}

