/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import net.minecraft.init.Biomes;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenLayerHills
extends GenLayer {
    private static final Logger logger = LogManager.getLogger();
    private GenLayer field_151628_d;

    public GenLayerHills(long p_i45479_1_, GenLayer p_i45479_3_, GenLayer p_i45479_4_) {
        super(p_i45479_1_);
        this.parent = p_i45479_3_;
        this.field_151628_d = p_i45479_4_;
    }

    @Override
    public int[] getInts(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.parent.getInts(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] aint1 = this.field_151628_d.getInts(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] aint2 = IntCache.getIntCache(areaWidth * areaHeight);
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                BiomeGenBase biomegenbase;
                boolean flag1;
                boolean flag;
                this.initChunkSeed(j + areaX, i + areaY);
                int k = aint[j + 1 + (i + 1) * (areaWidth + 2)];
                int l = aint1[j + 1 + (i + 1) * (areaWidth + 2)];
                boolean bl = flag = (l - 2) % 29 == 0;
                if (k > 255) {
                    logger.debug("old! " + k);
                }
                boolean bl2 = flag1 = (biomegenbase = BiomeGenBase.getBiomeForId(k)) != null && biomegenbase.isMutation();
                if (k != 0 && l >= 2 && (l - 2) % 29 == 1 && !flag1) {
                    BiomeGenBase biomegenbase3 = BiomeGenBase.getMutationForBiome(biomegenbase);
                    aint2[j + i * areaWidth] = biomegenbase3 == null ? k : BiomeGenBase.getIdForBiome(biomegenbase3);
                    continue;
                }
                if (this.nextInt(3) != 0 && !flag) {
                    aint2[j + i * areaWidth] = k;
                    continue;
                }
                BiomeGenBase biomegenbase1 = biomegenbase;
                if (biomegenbase == Biomes.desert) {
                    biomegenbase1 = Biomes.desertHills;
                } else if (biomegenbase == Biomes.forest) {
                    biomegenbase1 = Biomes.forestHills;
                } else if (biomegenbase == Biomes.birchForest) {
                    biomegenbase1 = Biomes.birchForestHills;
                } else if (biomegenbase == Biomes.roofedForest) {
                    biomegenbase1 = Biomes.plains;
                } else if (biomegenbase == Biomes.taiga) {
                    biomegenbase1 = Biomes.taigaHills;
                } else if (biomegenbase == Biomes.megaTaiga) {
                    biomegenbase1 = Biomes.megaTaigaHills;
                } else if (biomegenbase == Biomes.coldTaiga) {
                    biomegenbase1 = Biomes.coldTaigaHills;
                } else if (biomegenbase == Biomes.plains) {
                    biomegenbase1 = this.nextInt(3) == 0 ? Biomes.forestHills : Biomes.forest;
                } else if (biomegenbase == Biomes.icePlains) {
                    biomegenbase1 = Biomes.iceMountains;
                } else if (biomegenbase == Biomes.jungle) {
                    biomegenbase1 = Biomes.jungleHills;
                } else if (biomegenbase == Biomes.ocean) {
                    biomegenbase1 = Biomes.deepOcean;
                } else if (biomegenbase == Biomes.extremeHills) {
                    biomegenbase1 = Biomes.extremeHillsPlus;
                } else if (biomegenbase == Biomes.savanna) {
                    biomegenbase1 = Biomes.savannaPlateau;
                } else if (GenLayerHills.biomesEqualOrMesaPlateau(k, BiomeGenBase.getIdForBiome(Biomes.mesaPlateau_F))) {
                    biomegenbase1 = Biomes.mesa;
                } else if (biomegenbase == Biomes.deepOcean && this.nextInt(3) == 0) {
                    int i1 = this.nextInt(2);
                    biomegenbase1 = i1 == 0 ? Biomes.plains : Biomes.forest;
                }
                int j2 = BiomeGenBase.getIdForBiome(biomegenbase1);
                if (flag && j2 != k) {
                    BiomeGenBase biomegenbase2 = BiomeGenBase.getMutationForBiome(biomegenbase1);
                    int n = j2 = biomegenbase2 == null ? k : BiomeGenBase.getIdForBiome(biomegenbase2);
                }
                if (j2 == k) {
                    aint2[j + i * areaWidth] = k;
                    continue;
                }
                int k2 = aint[j + 1 + (i + 0) * (areaWidth + 2)];
                int j1 = aint[j + 2 + (i + 1) * (areaWidth + 2)];
                int k1 = aint[j + 0 + (i + 1) * (areaWidth + 2)];
                int l1 = aint[j + 1 + (i + 2) * (areaWidth + 2)];
                int i2 = 0;
                if (GenLayerHills.biomesEqualOrMesaPlateau(k2, k)) {
                    ++i2;
                }
                if (GenLayerHills.biomesEqualOrMesaPlateau(j1, k)) {
                    ++i2;
                }
                if (GenLayerHills.biomesEqualOrMesaPlateau(k1, k)) {
                    ++i2;
                }
                if (GenLayerHills.biomesEqualOrMesaPlateau(l1, k)) {
                    ++i2;
                }
                aint2[j + i * areaWidth] = i2 >= 3 ? j2 : k;
            }
        }
        return aint2;
    }
}

