/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import net.minecraft.init.Biomes;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerRiverMix
extends GenLayer {
    private GenLayer biomePatternGeneratorChain;
    private GenLayer riverPatternGeneratorChain;

    public GenLayerRiverMix(long p_i2129_1_, GenLayer p_i2129_3_, GenLayer p_i2129_4_) {
        super(p_i2129_1_);
        this.biomePatternGeneratorChain = p_i2129_3_;
        this.riverPatternGeneratorChain = p_i2129_4_;
    }

    @Override
    public void initWorldGenSeed(long seed) {
        this.biomePatternGeneratorChain.initWorldGenSeed(seed);
        this.riverPatternGeneratorChain.initWorldGenSeed(seed);
        super.initWorldGenSeed(seed);
    }

    @Override
    public int[] getInts(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.biomePatternGeneratorChain.getInts(areaX, areaY, areaWidth, areaHeight);
        int[] aint1 = this.riverPatternGeneratorChain.getInts(areaX, areaY, areaWidth, areaHeight);
        int[] aint2 = IntCache.getIntCache(areaWidth * areaHeight);
        for (int i = 0; i < areaWidth * areaHeight; ++i) {
            if (aint[i] != BiomeGenBase.getIdForBiome(Biomes.ocean) && aint[i] != BiomeGenBase.getIdForBiome(Biomes.deepOcean)) {
                if (aint1[i] == BiomeGenBase.getIdForBiome(Biomes.river)) {
                    if (aint[i] == BiomeGenBase.getIdForBiome(Biomes.icePlains)) {
                        aint2[i] = BiomeGenBase.getIdForBiome(Biomes.frozenRiver);
                        continue;
                    }
                    if (aint[i] != BiomeGenBase.getIdForBiome(Biomes.mushroomIsland) && aint[i] != BiomeGenBase.getIdForBiome(Biomes.mushroomIslandShore)) {
                        aint2[i] = aint1[i] & 0xFF;
                        continue;
                    }
                    aint2[i] = BiomeGenBase.getIdForBiome(Biomes.mushroomIslandShore);
                    continue;
                }
                aint2[i] = aint[i];
                continue;
            }
            aint2[i] = aint[i];
        }
        return aint2;
    }
}

