/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import org.apache.commons.lang3.ArrayUtils;

public class LootPool {
    private final LootEntry[] field_186453_a;
    private final LootCondition[] field_186454_b;
    private final RandomValueRange field_186455_c;
    private final RandomValueRange field_186456_d;

    public LootPool(LootEntry[] p_i46643_1_, LootCondition[] p_i46643_2_, RandomValueRange p_i46643_3_, RandomValueRange p_i46643_4_) {
        this.field_186453_a = p_i46643_1_;
        this.field_186454_b = p_i46643_2_;
        this.field_186455_c = p_i46643_3_;
        this.field_186456_d = p_i46643_4_;
    }

    protected void func_186452_a(Collection<ItemStack> p_186452_1_, Random p_186452_2_, LootContext p_186452_3_) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (LootEntry lootentry : this.field_186453_a) {
            int j;
            if (!LootConditionManager.testAllConditions(lootentry.conditions, p_186452_2_, p_186452_3_) || (j = lootentry.func_186361_a(p_186452_3_.getLuck())) <= 0) continue;
            list.add(lootentry);
            i += j;
        }
        if (i != 0 && !list.isEmpty()) {
            int k = p_186452_2_.nextInt(i);
            for (LootEntry lootentry1 : list) {
                if ((k -= lootentry1.func_186361_a(p_186452_3_.getLuck())) >= 0) continue;
                lootentry1.addLoot(p_186452_1_, p_186452_2_, p_186452_3_);
                return;
            }
        }
    }

    public void func_186449_b(Collection<ItemStack> p_186449_1_, Random p_186449_2_, LootContext p_186449_3_) {
        if (LootConditionManager.testAllConditions(this.field_186454_b, p_186449_2_, p_186449_3_)) {
            int i = this.field_186455_c.generateInt(p_186449_2_) + MathHelper.floor_float(this.field_186456_d.generateFloat(p_186449_2_) * p_186449_3_.getLuck());
            for (int j = 0; j < i; ++j) {
                this.func_186452_a(p_186449_1_, p_186449_2_, p_186449_3_);
            }
        }
    }

    public static class Serializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.getJsonObject(p_deserialize_1_, "loot pool");
            LootEntry[] alootentry = JsonUtils.func_188174_a(jsonobject, "entries", p_deserialize_3_, LootEntry[].class);
            LootCondition[] alootcondition = JsonUtils.func_188177_a(jsonobject, "conditions", new LootCondition[0], p_deserialize_3_, LootCondition[].class);
            RandomValueRange randomvaluerange = JsonUtils.func_188174_a(jsonobject, "rolls", p_deserialize_3_, RandomValueRange.class);
            RandomValueRange randomvaluerange1 = JsonUtils.func_188177_a(jsonobject, "bonus_rolls", new RandomValueRange(0.0f, 0.0f), p_deserialize_3_, RandomValueRange.class);
            return new LootPool(alootentry, alootcondition, randomvaluerange, randomvaluerange1);
        }

        public JsonElement serialize(LootPool p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("entries", p_serialize_3_.serialize((Object)p_serialize_1_.field_186453_a));
            jsonobject.add("rolls", p_serialize_3_.serialize((Object)p_serialize_1_.field_186455_c));
            if (p_serialize_1_.field_186456_d.getMin() != 0.0f && p_serialize_1_.field_186456_d.getMax() != 0.0f) {
                jsonobject.add("bonus_rolls", p_serialize_3_.serialize((Object)p_serialize_1_.field_186456_d));
            }
            if (!ArrayUtils.isEmpty((Object[])p_serialize_1_.field_186454_b)) {
                jsonobject.add("conditions", p_serialize_3_.serialize((Object)p_serialize_1_.field_186454_b));
            }
            return jsonobject;
        }
    }
}

