/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class EntityHasScore
implements LootCondition {
    private final Map<String, RandomValueRange> field_186634_a;
    private final LootContext.EntityTarget field_186635_b;

    public EntityHasScore(Map<String, RandomValueRange> p_i46618_1_, LootContext.EntityTarget p_i46618_2_) {
        this.field_186634_a = p_i46618_1_;
        this.field_186635_b = p_i46618_2_;
    }

    @Override
    public boolean testCondition(Random rand, LootContext context) {
        Entity entity = context.getEntity(this.field_186635_b);
        if (entity == null) {
            return false;
        }
        Scoreboard scoreboard = entity.worldObj.getScoreboard();
        for (Map.Entry<String, RandomValueRange> entry : this.field_186634_a.entrySet()) {
            if (this.func_186631_a(entity, scoreboard, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean func_186631_a(Entity p_186631_1_, Scoreboard p_186631_2_, String p_186631_3_, RandomValueRange p_186631_4_) {
        ScoreObjective scoreobjective = p_186631_2_.getObjective(p_186631_3_);
        if (scoreobjective == null) {
            return false;
        }
        String s = p_186631_1_ instanceof EntityPlayerMP ? p_186631_1_.getName() : p_186631_1_.getUniqueID().toString();
        return !p_186631_2_.entityHasObjective(s, scoreobjective) ? false : p_186631_4_.isInRange(p_186631_2_.getValueFromObjective(s, scoreobjective).getScorePoints());
    }

    public static class Serializer
    extends LootCondition.Serializer<EntityHasScore> {
        protected Serializer() {
            super(new ResourceLocation("entity_scores"), EntityHasScore.class);
        }

        @Override
        public void serialize(JsonObject json, EntityHasScore value, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry entry : value.field_186634_a.entrySet()) {
                jsonobject.add((String)entry.getKey(), context.serialize(entry.getValue()));
            }
            json.add("scores", (JsonElement)jsonobject);
            json.add("entity", context.serialize((Object)value.field_186635_b));
        }

        @Override
        public EntityHasScore deserialize(JsonObject json, JsonDeserializationContext context) {
            Set set = JsonUtils.getJsonObject(json, "scores").entrySet();
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (Map.Entry entry : set) {
                map.put(entry.getKey(), JsonUtils.func_188179_a((JsonElement)entry.getValue(), "score", context, RandomValueRange.class));
            }
            return new EntityHasScore(map, JsonUtils.func_188174_a(json, "entity", context, LootContext.EntityTarget.class));
        }
    }
}

