/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetAttributes;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraft.world.storage.loot.functions.Smelt;

public class LootFunctionManager {
    private static final Map<ResourceLocation, LootFunction.Serializer<?>> field_186584_a = Maps.newHashMap();
    private static final Map<Class<? extends LootFunction>, LootFunction.Serializer<?>> field_186585_b = Maps.newHashMap();

    public static <T extends LootFunction> void func_186582_a(LootFunction.Serializer<? extends T> p_186582_0_) {
        ResourceLocation resourcelocation = p_186582_0_.func_186529_a();
        Class<T> oclass = p_186582_0_.func_186531_b();
        if (field_186584_a.containsKey(resourcelocation)) {
            throw new IllegalArgumentException("Can't re-register item function name " + resourcelocation);
        }
        if (field_186585_b.containsKey(oclass)) {
            throw new IllegalArgumentException("Can't re-register item function class " + oclass.getName());
        }
        field_186584_a.put(resourcelocation, p_186582_0_);
        field_186585_b.put(oclass, p_186582_0_);
    }

    public static LootFunction.Serializer<?> func_186583_a(ResourceLocation p_186583_0_) {
        LootFunction.Serializer<?> serializer = field_186584_a.get(p_186583_0_);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item function '" + p_186583_0_ + "'");
        }
        return serializer;
    }

    public static <T extends LootFunction> LootFunction.Serializer<T> func_186581_a(T p_186581_0_) {
        LootFunction.Serializer<?> serializer = field_186585_b.get(p_186581_0_.getClass());
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item function " + p_186581_0_);
        }
        return serializer;
    }

    static {
        LootFunctionManager.func_186582_a(new SetCount.Serializer());
        LootFunctionManager.func_186582_a(new SetMetadata.Serializer());
        LootFunctionManager.func_186582_a(new EnchantWithLevels.Serializer());
        LootFunctionManager.func_186582_a(new EnchantRandomly.Serializer());
        LootFunctionManager.func_186582_a(new SetNBT.Serializer());
        LootFunctionManager.func_186582_a(new Smelt.Serializer());
        LootFunctionManager.func_186582_a(new LootingEnchantBonus.Serializer());
        LootFunctionManager.func_186582_a(new SetDamage.Serializer());
        LootFunctionManager.func_186582_a(new SetAttributes.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<LootFunction>,
    JsonSerializer<LootFunction> {
        public LootFunction deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            LootFunction.Serializer<?> serializer;
            JsonObject jsonobject = JsonUtils.getJsonObject(p_deserialize_1_, "function");
            ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.getString(jsonobject, "function"));
            try {
                serializer = LootFunctionManager.func_186583_a(resourcelocation);
            }
            catch (IllegalArgumentException var8) {
                throw new JsonSyntaxException("Unknown function '" + resourcelocation + "'");
            }
            return serializer.func_186530_b(jsonobject, p_deserialize_3_, JsonUtils.func_188177_a(jsonobject, "conditions", new LootCondition[0], p_deserialize_3_, LootCondition[].class));
        }

        public JsonElement serialize(LootFunction p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            LootFunction.Serializer<LootFunction> serializer = LootFunctionManager.func_186581_a(p_serialize_1_);
            JsonObject jsonobject = new JsonObject();
            serializer.func_186532_a(jsonobject, p_serialize_1_, p_serialize_3_);
            jsonobject.addProperty("function", serializer.func_186529_a().toString());
            if (p_serialize_1_.getConditions() != null && p_serialize_1_.getConditions().length > 0) {
                jsonobject.add("conditions", p_serialize_3_.serialize((Object)p_serialize_1_.getConditions()));
            }
            return jsonobject;
        }
    }
}

