/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import optifine.HashUtils;
import optifine.Patcher;
import optifine.Utils;
import optifine.xdelta.Delta;
import optifine.xdelta.DeltaException;
import optifine.xdelta.DiffWriter;
import optifine.xdelta.GDiffWriter;

public class Differ {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            Utils.dbg("Usage: Differ <base.jar> <mod.jar> <diff.jar>");
            return;
        } else {
            File file1 = new File(args[0]);
            File file2 = new File(args[1]);
            File file3 = new File(args[2]);
            if (file1.getName().equals("AUTO")) {
                file1 = Differ.detectBaseFile(file2);
            }
            if (!file1.exists() || !file1.isFile()) throw new IOException("Base file not found: " + file1);
            if (!file2.exists() || !file2.isFile()) throw new IOException("Mod file not found: " + file2);
            Differ.process(file1, file2, file3);
        }
    }

    private static void process(File baseFile, File modFile, File diffFile) throws IOException, DeltaException, NoSuchAlgorithmException {
        ZipFile zipfile = new ZipFile(modFile);
        Map<String, String> map = Patcher.getConfigurationMap(zipfile);
        Pattern[] apattern = Patcher.getConfigurationPatterns(map);
        ZipOutputStream zipoutputstream = new ZipOutputStream(new FileOutputStream(diffFile));
        ZipFile zipfile1 = new ZipFile(baseFile);
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipentry = enumeration.nextElement();
            InputStream inputstream = zipfile.getInputStream(zipentry);
            byte[] abyte = Utils.readAll(inputstream);
            String s = zipentry.getName();
            byte[] abyte1 = Differ.makeDiff(s, abyte, apattern, map, zipfile1);
            if (abyte1 != abyte) {
                ZipEntry zipentry1 = new ZipEntry("patch/" + s + ".xdelta");
                zipoutputstream.putNextEntry(zipentry1);
                zipoutputstream.write(abyte1);
                zipoutputstream.closeEntry();
                Utils.dbg("Delta: " + zipentry1.getName());
                byte[] abyte2 = HashUtils.getHashMd5(abyte);
                String s1 = HashUtils.toHexString(abyte2);
                byte[] abyte3 = s1.getBytes("ASCII");
                ZipEntry zipentry2 = new ZipEntry("patch/" + s + ".md5");
                zipoutputstream.putNextEntry(zipentry2);
                zipoutputstream.write(abyte3);
                zipoutputstream.closeEntry();
                continue;
            }
            ZipEntry zipentry3 = new ZipEntry(s);
            zipoutputstream.putNextEntry(zipentry3);
            zipoutputstream.write(abyte);
            zipoutputstream.closeEntry();
            Utils.dbg("Same: " + zipentry3.getName());
        }
        zipoutputstream.close();
    }

    public static byte[] makeDiff(String name, byte[] bytesMod, Pattern[] patterns, Map<String, String> cfgMap, ZipFile zipBase) throws IOException, DeltaException {
        String s = Patcher.getPatchBase(name, patterns, cfgMap);
        if (s == null) {
            return bytesMod;
        }
        ZipEntry zipentry = zipBase.getEntry(s);
        if (zipentry == null) {
            throw new IOException("Base entry not found: " + s);
        }
        InputStream inputstream = zipBase.getInputStream(zipentry);
        byte[] abyte = Utils.readAll(inputstream);
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(bytesMod);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        GDiffWriter diffwriter = new GDiffWriter(new DataOutputStream(bytearrayoutputstream));
        Delta.computeDelta(abyte, (InputStream)bytearrayinputstream, bytesMod.length, (DiffWriter)diffwriter);
        diffwriter.close();
        return bytearrayoutputstream.toByteArray();
    }

    public static File detectBaseFile(File modFile) throws IOException {
        ZipFile zipfile = new ZipFile(modFile);
        zipfile.close();
        String s1 = "1.9";
        File file1 = Utils.getWorkingDirectory();
        File file2 = new File(file1, "versions/" + s1 + "/" + s1 + ".jar");
        return file2;
    }
}

