/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import optifine.Differ;
import optifine.HashUtils;
import optifine.IResourceProvider;
import optifine.Utils;
import optifine.ZipResourceProvider;
import optifine.xdelta.GDiffPatcher;
import optifine.xdelta.PatchException;

public class Patcher {
    public static final String CONFIG_FILE = "patch.cfg";
    public static final String PREFIX_PATCH = "patch/";
    public static final String SUFFIX_DELTA = ".xdelta";
    public static final String SUFFIX_MD5 = ".md5";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            Utils.dbg("Usage: Patcher <base.jar> <diff.jar> <mod.jar>");
            return;
        } else {
            File file1 = new File(args[0]);
            File file2 = new File(args[1]);
            File file3 = new File(args[2]);
            if (file1.getName().equals("AUTO")) {
                file1 = Differ.detectBaseFile(file2);
            }
            if (!file1.exists() || !file1.isFile()) throw new IOException("Base file not found: " + file1);
            if (!file2.exists() || !file2.isFile()) throw new IOException("Diff file not found: " + file3);
            Patcher.process(file1, file2, file3);
        }
    }

    public static void process(File baseFile, File diffFile, File modFile) throws Exception {
        ZipFile zipfile = new ZipFile(diffFile);
        Map<String, String> map = Patcher.getConfigurationMap(zipfile);
        Pattern[] apattern = Patcher.getConfigurationPatterns(map);
        ZipOutputStream zipoutputstream = new ZipOutputStream(new FileOutputStream(modFile));
        ZipFile zipfile1 = new ZipFile(baseFile);
        ZipResourceProvider zipresourceprovider = new ZipResourceProvider(zipfile1);
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipentry = enumeration.nextElement();
            InputStream inputstream = zipfile.getInputStream(zipentry);
            byte[] abyte = Utils.readAll(inputstream);
            String s = zipentry.getName();
            if (s.startsWith(PREFIX_PATCH) && s.endsWith(SUFFIX_DELTA)) {
                byte[] abyte2;
                String s3;
                byte[] abyte1;
                String s2;
                s = s.substring(PREFIX_PATCH.length());
                s = s.substring(0, s.length() - SUFFIX_DELTA.length());
                byte[] abyte3 = Patcher.applyPatch(s, abyte, apattern, map, zipresourceprovider);
                String s1 = PREFIX_PATCH + s + SUFFIX_MD5;
                ZipEntry zipentry2 = zipfile.getEntry(s1);
                if (zipentry2 != null && !(s2 = new String(abyte1 = Utils.readAll(zipfile.getInputStream(zipentry2)), "ASCII")).equals(s3 = HashUtils.toHexString(abyte2 = HashUtils.getHashMd5(abyte3)))) {
                    throw new Exception("MD5 not matching, name: " + s + ", saved: " + s2 + ", patched: " + s3);
                }
                ZipEntry zipentry3 = new ZipEntry(s);
                zipoutputstream.putNextEntry(zipentry3);
                zipoutputstream.write(abyte3);
                zipoutputstream.closeEntry();
                Utils.dbg("Mod: " + s);
                continue;
            }
            if (s.startsWith(PREFIX_PATCH) && s.endsWith(SUFFIX_MD5)) continue;
            ZipEntry zipentry1 = new ZipEntry(s);
            zipoutputstream.putNextEntry(zipentry1);
            zipoutputstream.write(abyte);
            zipoutputstream.closeEntry();
            Utils.dbg("Same: " + zipentry1.getName());
        }
        zipoutputstream.close();
    }

    public static byte[] applyPatch(String name, byte[] bytesDiff, Pattern[] patterns, Map<String, String> cfgMap, IResourceProvider resourceProvider) throws IOException, PatchException {
        String s = Patcher.getPatchBase(name = Utils.removePrefix(name, "/"), patterns, cfgMap);
        if (s == null) {
            throw new IOException("No patch base, name: " + name + ", patterns: " + Utils.arrayToCommaSeparatedString(patterns));
        }
        InputStream inputstream = resourceProvider.getResourceStream(s);
        if (inputstream == null) {
            throw new IOException("Base resource not found: " + s);
        }
        byte[] abyte = Utils.readAll(inputstream);
        ByteArrayInputStream inputstream1 = new ByteArrayInputStream(bytesDiff);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        new GDiffPatcher(abyte, (InputStream)inputstream1, (OutputStream)bytearrayoutputstream);
        bytearrayoutputstream.close();
        return bytearrayoutputstream.toByteArray();
    }

    public static Pattern[] getConfigurationPatterns(Map<String, String> cfgMap) {
        String[] astring = cfgMap.keySet().toArray(new String[0]);
        Pattern[] apattern = new Pattern[astring.length];
        for (int i = 0; i < astring.length; ++i) {
            String s = astring[i];
            apattern[i] = Pattern.compile(s);
        }
        return apattern;
    }

    public static Map<String, String> getConfigurationMap(ZipFile modZip) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (modZip == null) {
            return map;
        }
        ZipEntry zipentry = modZip.getEntry(CONFIG_FILE);
        if (zipentry == null) {
            return map;
        }
        InputStream inputstream = modZip.getInputStream(zipentry);
        String[] astring = Utils.readLines(inputstream, "ASCII");
        inputstream.close();
        for (int i = 0; i < astring.length; ++i) {
            String s = astring[i].trim();
            if (s.startsWith("#") || s.length() <= 0) continue;
            String[] astring1 = Utils.tokenize(s, "=");
            if (astring1.length != 2) {
                throw new IOException("Invalid patch configuration: " + s);
            }
            String s1 = astring1[0].trim();
            String s2 = astring1[1].trim();
            map.put(s1, s2);
        }
        return map;
    }

    public static String getPatchBase(String name, Pattern[] patterns, Map<String, String> cfgMap) {
        name = Utils.removePrefix(name, "/");
        for (int i = 0; i < patterns.length; ++i) {
            Pattern pattern = patterns[i];
            Matcher matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            String s = cfgMap.get(pattern.pattern());
            if (s != null && s.trim().equals("*")) {
                return name;
            }
            return s;
        }
        return null;
    }
}

