/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class Utils {
    public static final String MAC_OS_HOME_PREFIX = "Library/Application Support";
    private static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static File getWorkingDirectory() {
        return Utils.getWorkingDirectory("minecraft");
    }

    public static File getWorkingDirectory(String applicationName) {
        String s = System.getProperty("user.home", ".");
        File file1 = null;
        switch (Utils.getPlatform().ordinal()) {
            case 1: 
            case 2: {
                file1 = new File(s, '.' + applicationName + '/');
                break;
            }
            case 3: {
                String s1 = System.getenv("APPDATA");
                if (s1 != null) {
                    file1 = new File(s1, "." + applicationName + '/');
                    break;
                }
                file1 = new File(s, '.' + applicationName + '/');
                break;
            }
            case 4: {
                file1 = new File(s, "Library/Application Support/" + applicationName);
                break;
            }
            default: {
                file1 = new File(s, applicationName + '/');
            }
        }
        if (!file1.exists() && !file1.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file1);
        }
        return file1;
    }

    public static OS getPlatform() {
        String s = System.getProperty("os.name").toLowerCase();
        return s.contains("win") ? OS.WINDOWS : (s.contains("mac") ? OS.MACOS : (s.contains("solaris") ? OS.SOLARIS : (s.contains("sunos") ? OS.SOLARIS : (s.contains("linux") ? OS.LINUX : (s.contains("unix") ? OS.LINUX : OS.UNKNOWN)))));
    }

    public static int find(byte[] buf, byte[] pattern) {
        return Utils.find(buf, 0, pattern);
    }

    public static int find(byte[] buf, int index, byte[] pattern) {
        for (int i = index; i < buf.length - pattern.length; ++i) {
            boolean flag = true;
            for (int j = 0; j < pattern.length; ++j) {
                if (pattern[j] == buf[i + j]) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return i;
        }
        return -1;
    }

    public static byte[] readAll(InputStream is) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        byte[] abyte = new byte[1024];
        while (true) {
            int i;
            if ((i = is.read(abyte)) < 0) {
                is.close();
                byte[] abyte1 = bytearrayoutputstream.toByteArray();
                return abyte1;
            }
            bytearrayoutputstream.write(abyte, 0, i);
        }
    }

    public static void dbg(String str) {
        System.out.println(str);
    }

    public static String[] tokenize(String str, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer stringtokenizer = new StringTokenizer(str, delim);
        while (stringtokenizer.hasMoreTokens()) {
            String s = stringtokenizer.nextToken();
            list.add(s);
        }
        String[] astring = list.toArray(new String[list.size()]);
        return astring;
    }

    public static String getExceptionStackTrace(Throwable e) {
        StringWriter stringwriter = new StringWriter();
        PrintWriter printwriter = new PrintWriter(stringwriter);
        e.printStackTrace(printwriter);
        printwriter.close();
        try {
            stringwriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringwriter.getBuffer().toString();
    }

    public static void copyFile(File fileSrc, File fileDest) throws IOException {
        if (!fileSrc.getCanonicalPath().equals(fileDest.getCanonicalPath())) {
            FileInputStream fileinputstream = new FileInputStream(fileSrc);
            FileOutputStream fileoutputstream = new FileOutputStream(fileDest);
            Utils.copyAll(fileinputstream, fileoutputstream);
            fileoutputstream.flush();
            fileinputstream.close();
            fileoutputstream.close();
        }
    }

    public static void copyAll(InputStream is, OutputStream os) throws IOException {
        byte[] abyte = new byte[1024];
        int i;
        while ((i = is.read(abyte)) >= 0) {
            os.write(abyte, 0, i);
        }
        return;
    }

    public static void showMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg, "OptiFine", 1);
    }

    public static void showErrorMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error", 0);
    }

    public static String readFile(File file) throws IOException {
        return Utils.readFile(file, "ASCII");
    }

    public static String readFile(File file, String encoding) throws IOException {
        FileInputStream fileinputstream = new FileInputStream(file);
        return Utils.readText(fileinputstream, encoding);
    }

    public static String readText(InputStream in, String encoding) throws IOException {
        InputStreamReader inputstreamreader = new InputStreamReader(in, encoding);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        StringBuffer stringbuffer = new StringBuffer();
        while (true) {
            String s;
            if ((s = bufferedreader.readLine()) == null) {
                bufferedreader.close();
                inputstreamreader.close();
                in.close();
                return stringbuffer.toString();
            }
            stringbuffer.append(s);
            stringbuffer.append("\n");
        }
    }

    public static String[] readLines(InputStream in, String encoding) throws IOException {
        String s = Utils.readText(in, encoding);
        String[] astring = Utils.tokenize(s, "\n\r");
        return astring;
    }

    public static void centerWindow(Component c, Component par) {
        if (c != null) {
            Rectangle rectangle1;
            Rectangle rectangle = c.getBounds();
            if (par != null && par.isVisible()) {
                rectangle1 = par.getBounds();
            } else {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                rectangle1 = new Rectangle(0, 0, dimension.width, dimension.height);
            }
            int j = rectangle1.x + (rectangle1.width - rectangle.width) / 2;
            int i = rectangle1.y + (rectangle1.height - rectangle.height) / 2;
            if (j < 0) {
                j = 0;
            }
            if (i < 0) {
                i = 0;
            }
            c.setBounds(j, i, rectangle.width, rectangle.height);
        }
    }

    public static String byteArrayToHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b0 = bytes[i];
            stringbuffer.append(hexTable[b0 >> 4 & 0xF]);
            stringbuffer.append(hexTable[b0 & 0xF]);
        }
        return stringbuffer.toString();
    }

    public static String arrayToCommaSeparatedString(Object[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            Object object = arr[i];
            if (i > 0) {
                stringbuffer.append(", ");
            }
            if (object == null) {
                stringbuffer.append("null");
                continue;
            }
            if (!object.getClass().isArray()) {
                stringbuffer.append(arr[i]);
                continue;
            }
            stringbuffer.append("[");
            if (object instanceof Object[]) {
                Object[] aobject = (Object[])object;
                stringbuffer.append(Utils.arrayToCommaSeparatedString(aobject));
            } else {
                for (int j = 0; j < Array.getLength(object); ++j) {
                    if (j > 0) {
                        stringbuffer.append(", ");
                    }
                    stringbuffer.append(Array.get(object, j));
                }
            }
            stringbuffer.append("]");
        }
        return stringbuffer.toString();
    }

    public static String removePrefix(String str, String prefix) {
        if (str != null && prefix != null) {
            if (str.startsWith(prefix)) {
                str = str.substring(prefix.length());
            }
            return str;
        }
        return str;
    }

    public static String ensurePrefix(String str, String prefix) {
        if (str != null && prefix != null) {
            if (!str.startsWith(prefix)) {
                str = prefix + str;
            }
            return str;
        }
        return str;
    }

    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS,
        MACOS,
        UNKNOWN;

    }
}

