/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCauldron
extends Block {
    public static final PropertyInteger LEVEL = PropertyInteger.create("level", 0, 3);
    protected static final AxisAlignedBB field_185596_b = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB field_185597_c = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB field_185598_d = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185599_e = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185600_f = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockCauldron() {
        super(Material.iron, MapColor.stoneColor);
        this.setDefaultState(this.blockState.getBaseState().withProperty(LEVEL, Integer.valueOf(0)));
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB p_185477_4_, List<AxisAlignedBB> p_185477_5_, Entity p_185477_6_) {
        BlockCauldron.func_185492_a(pos, p_185477_4_, p_185477_5_, field_185596_b);
        BlockCauldron.func_185492_a(pos, p_185477_4_, p_185477_5_, field_185600_f);
        BlockCauldron.func_185492_a(pos, p_185477_4_, p_185477_5_, field_185597_c);
        BlockCauldron.func_185492_a(pos, p_185477_4_, p_185477_5_, field_185599_e);
        BlockCauldron.func_185492_a(pos, p_185477_4_, p_185477_5_, field_185598_d);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FULL_BLOCK_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_149662_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @Override
    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int i = state.getValue(LEVEL);
        float f = (float)pos.getY() + (6.0f + (float)(3 * i)) / 16.0f;
        if (!worldIn.isRemote && entityIn.isBurning() && i > 0 && entityIn.getEntityBoundingBox().minY <= (double)f) {
            entityIn.extinguish();
            this.setWaterLevel(worldIn, pos, state, i - 1);
        }
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand side, ItemStack hitX, EnumFacing hitY, float hitZ, float p_180639_9_, float p_180639_10_) {
        ItemArmor itemarmor;
        if (hitX == null) {
            return true;
        }
        int i = state.getValue(LEVEL);
        Item item = hitX.getItem();
        if (item == Items.water_bucket) {
            if (i < 3 && !worldIn.isRemote) {
                if (!playerIn.capabilities.isCreativeMode) {
                    playerIn.setHeldItem(side, new ItemStack(Items.bucket));
                }
                playerIn.triggerAchievement(StatList.field_188077_K);
                this.setWaterLevel(worldIn, pos, state, 3);
            }
            return true;
        }
        if (item == Items.bucket) {
            if (i == 3 && !worldIn.isRemote) {
                if (!playerIn.capabilities.isCreativeMode) {
                    --hitX.stackSize;
                    if (hitX.stackSize == 0) {
                        playerIn.setHeldItem(side, new ItemStack(Items.water_bucket));
                    } else if (!playerIn.inventory.addItemStackToInventory(new ItemStack(Items.water_bucket))) {
                        playerIn.dropPlayerItemWithRandomChoice(new ItemStack(Items.water_bucket), false);
                    }
                }
                playerIn.triggerAchievement(StatList.field_188078_L);
                this.setWaterLevel(worldIn, pos, state, 0);
            }
            return true;
        }
        if (item == Items.glass_bottle) {
            if (i > 0 && !worldIn.isRemote) {
                if (!playerIn.capabilities.isCreativeMode) {
                    ItemStack itemstack1 = PotionUtils.func_185188_a(new ItemStack(Items.potionitem), PotionTypes.water);
                    playerIn.triggerAchievement(StatList.field_188078_L);
                    if (--hitX.stackSize == 0) {
                        playerIn.setHeldItem(side, itemstack1);
                    } else if (!playerIn.inventory.addItemStackToInventory(itemstack1)) {
                        playerIn.dropPlayerItemWithRandomChoice(itemstack1, false);
                    } else if (playerIn instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)playerIn).sendContainerToPlayer(playerIn.inventoryContainer);
                    }
                }
                this.setWaterLevel(worldIn, pos, state, i - 1);
            }
            return true;
        }
        if (i > 0 && item instanceof ItemArmor && (itemarmor = (ItemArmor)item).getArmorMaterial() == ItemArmor.ArmorMaterial.LEATHER && itemarmor.hasColor(hitX) && !worldIn.isRemote) {
            itemarmor.removeColor(hitX);
            this.setWaterLevel(worldIn, pos, state, i - 1);
            playerIn.triggerAchievement(StatList.field_188079_M);
            return true;
        }
        if (i > 0 && item instanceof ItemBanner) {
            if (TileEntityBanner.getPatterns(hitX) > 0 && !worldIn.isRemote) {
                ItemStack itemstack = hitX.copy();
                itemstack.stackSize = 1;
                TileEntityBanner.removeBannerData(itemstack);
                playerIn.triggerAchievement(StatList.field_188080_N);
                if (!playerIn.capabilities.isCreativeMode) {
                    --hitX.stackSize;
                }
                if (hitX.stackSize == 0) {
                    playerIn.setHeldItem(side, itemstack);
                } else if (!playerIn.inventory.addItemStackToInventory(itemstack)) {
                    playerIn.dropPlayerItemWithRandomChoice(itemstack, false);
                } else if (playerIn instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)playerIn).sendContainerToPlayer(playerIn.inventoryContainer);
                }
                if (!playerIn.capabilities.isCreativeMode) {
                    this.setWaterLevel(worldIn, pos, state, i - 1);
                }
            }
            return true;
        }
        return false;
    }

    public void setWaterLevel(World worldIn, BlockPos pos, IBlockState state, int level) {
        worldIn.setBlockState(pos, state.withProperty(LEVEL, Integer.valueOf(MathHelper.clamp_int(level, 0, 3))), 2);
        worldIn.updateComparatorOutputLevel(pos, this);
    }

    @Override
    public void fillWithRain(World worldIn, BlockPos pos) {
        if (worldIn.rand.nextInt(20) == 1) {
            IBlockState iblockstate;
            float f = worldIn.getBiomeGenForCoords(pos).getFloatTemperature(pos);
            if (worldIn.getWorldChunkManager().getTemperatureAtHeight(f, pos.getY()) >= 0.15f && (iblockstate = worldIn.getBlockState(pos)).getValue(LEVEL) < 3) {
                worldIn.setBlockState(pos, iblockstate.cycleProperty(LEVEL), 2);
            }
        }
    }

    @Override
    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Items.cauldron;
    }

    @Override
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Items.cauldron);
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState worldIn, World pos, BlockPos p_180641_3_) {
        return worldIn.getValue(LEVEL);
    }

    @Override
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(LEVEL, Integer.valueOf(meta));
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        return state.getValue(LEVEL);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer(this, LEVEL);
    }

    @Override
    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }
}

