/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChorusPlant
extends Block {
    public static final PropertyBool NORTH = PropertyBool.create("north");
    public static final PropertyBool EAST = PropertyBool.create("east");
    public static final PropertyBool SOUTH = PropertyBool.create("south");
    public static final PropertyBool WEST = PropertyBool.create("west");
    public static final PropertyBool UP = PropertyBool.create("up");
    public static final PropertyBool DOWN = PropertyBool.create("down");

    protected BlockChorusPlant() {
        super(Material.plants);
        this.setCreativeTab(CreativeTabs.tabDecorations);
        this.setDefaultState(this.blockState.getBaseState().withProperty(NORTH, Boolean.valueOf(false)).withProperty(EAST, Boolean.valueOf(false)).withProperty(SOUTH, Boolean.valueOf(false)).withProperty(WEST, Boolean.valueOf(false)).withProperty(UP, Boolean.valueOf(false)).withProperty(DOWN, Boolean.valueOf(false)));
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.getBlockState(pos.down()).getBlock();
        Block block1 = worldIn.getBlockState(pos.up()).getBlock();
        Block block2 = worldIn.getBlockState(pos.north()).getBlock();
        Block block3 = worldIn.getBlockState(pos.east()).getBlock();
        Block block4 = worldIn.getBlockState(pos.south()).getBlock();
        Block block5 = worldIn.getBlockState(pos.west()).getBlock();
        return state.withProperty(DOWN, Boolean.valueOf(block == this || block == Blocks.chorus_flower || block == Blocks.end_stone)).withProperty(UP, Boolean.valueOf(block1 == this || block1 == Blocks.chorus_flower)).withProperty(NORTH, Boolean.valueOf(block2 == this || block2 == Blocks.chorus_flower)).withProperty(EAST, Boolean.valueOf(block3 == this || block3 == Blocks.chorus_flower)).withProperty(SOUTH, Boolean.valueOf(block4 == this || block4 == Blocks.chorus_flower)).withProperty(WEST, Boolean.valueOf(block5 == this || block5 == Blocks.chorus_flower));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.getActualState(source, pos);
        float f = 0.1875f;
        float f1 = state.getValue(WEST) != false ? 0.0f : 0.1875f;
        float f2 = state.getValue(DOWN) != false ? 0.0f : 0.1875f;
        float f3 = state.getValue(NORTH) != false ? 0.0f : 0.1875f;
        float f4 = state.getValue(EAST) != false ? 1.0f : 0.8125f;
        float f5 = state.getValue(UP) != false ? 1.0f : 0.8125f;
        float f6 = state.getValue(SOUTH) != false ? 1.0f : 0.8125f;
        return new AxisAlignedBB(f1, f2, f3, f4, f5, f6);
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB p_185477_4_, List<AxisAlignedBB> p_185477_5_, Entity p_185477_6_) {
        state = state.getActualState(worldIn, pos);
        float f = 0.1875f;
        float f1 = 0.8125f;
        BlockChorusPlant.func_185492_a(pos, p_185477_4_, p_185477_5_, new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125));
        if (state.getValue(WEST).booleanValue()) {
            BlockChorusPlant.func_185492_a(pos, p_185477_4_, p_185477_5_, new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.1875, 0.8125, 0.8125));
        }
        if (state.getValue(EAST).booleanValue()) {
            BlockChorusPlant.func_185492_a(pos, p_185477_4_, p_185477_5_, new AxisAlignedBB(0.8125, 0.1875, 0.1875, 1.0, 0.8125, 0.8125));
        }
        if (state.getValue(UP).booleanValue()) {
            BlockChorusPlant.func_185492_a(pos, p_185477_4_, p_185477_5_, new AxisAlignedBB(0.1875, 0.8125, 0.1875, 0.8125, 1.0, 0.8125));
        }
        if (state.getValue(DOWN).booleanValue()) {
            BlockChorusPlant.func_185492_a(pos, p_185477_4_, p_185477_5_, new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125));
        }
        if (state.getValue(NORTH).booleanValue()) {
            BlockChorusPlant.func_185492_a(pos, p_185477_4_, p_185477_5_, new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.1875));
        }
        if (state.getValue(SOUTH).booleanValue()) {
            BlockChorusPlant.func_185492_a(pos, p_185477_4_, p_185477_5_, new AxisAlignedBB(0.1875, 0.1875, 0.8125, 0.8125, 0.8125, 1.0));
        }
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    @Override
    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.func_185608_b(worldIn, pos)) {
            worldIn.destroyBlock(pos, true);
        }
    }

    @Override
    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Items.chorus_fruit;
    }

    @Override
    public int quantityDropped(Random random) {
        return random.nextInt(2);
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_149662_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return super.canPlaceBlockAt(worldIn, pos) ? this.func_185608_b(worldIn, pos) : false;
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!this.func_185608_b(worldIn, pos)) {
            worldIn.scheduleUpdate(pos, this, 1);
        }
    }

    public boolean func_185608_b(World p_185608_1_, BlockPos p_185608_2_) {
        boolean flag = p_185608_1_.isAirBlock(p_185608_2_.up());
        boolean flag1 = p_185608_1_.isAirBlock(p_185608_2_.down());
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = p_185608_2_.offset(enumfacing);
            Block block = p_185608_1_.getBlockState(blockpos).getBlock();
            if (block != this) continue;
            if (!flag && !flag1) {
                return false;
            }
            Block block1 = p_185608_1_.getBlockState(blockpos.down()).getBlock();
            if (block1 != this && block1 != Blocks.end_stone) continue;
            return true;
        }
        Block block2 = p_185608_1_.getBlockState(p_185608_2_.down()).getBlock();
        return block2 == this || block2 == Blocks.end_stone;
    }

    @Override
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockState worldIn, IBlockAccess pos, BlockPos side, EnumFacing facing) {
        Block block = pos.getBlockState(side.offset(facing)).getBlock();
        return block != this && block != Blocks.chorus_flower && (facing != EnumFacing.DOWN || block != Blocks.end_stone);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer(this, NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }

    @Override
    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }
}

