/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import tk.wurst_client.WurstClient;
import tk.wurst_client.hooks.ServerHook;

public class GuiDisconnected
extends GuiScreen {
    private String reason;
    private ITextComponent message;
    private List<String> multilineMessage;
    private final GuiScreen parentScreen;
    private int field_175353_i;
    private int autoReconnectTimer;

    public GuiDisconnected(GuiScreen screen, String reasonLocalizationKey, ITextComponent chatComp) {
        this.parentScreen = screen;
        this.reason = I18n.format(reasonLocalizationKey, new Object[0]);
        this.message = chatComp;
        LogManager.getLogger().info("Disconnected.\n    Message: " + (this.message == null ? null : this.message.getUnformattedText()) + "\n    Reason: " + this.reason);
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
    }

    @Override
    public void initGui() {
        this.buttonList.clear();
        this.multilineMessage = this.fontRendererObj.listFormattedStringToWidth(this.message.getFormattedText(), this.width - 50);
        this.field_175353_i = this.multilineMessage.size() * this.fontRendererObj.FONT_HEIGHT;
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 2 + this.field_175353_i / 2 + this.fontRendererObj.FONT_HEIGHT, I18n.format("gui.toMenu", new Object[0])));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 2 + this.field_175353_i / 2 + this.fontRendererObj.FONT_HEIGHT + 24, "Reconnect"));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 100, this.height / 2 + this.field_175353_i / 2 + this.fontRendererObj.FONT_HEIGHT + 48, "AutoReconnect"));
        if ((this.message.getUnformattedText().toLowerCase().contains("whitelist") || this.message.getUnformattedText().toLowerCase().contains("white-list")) && this.parentScreen instanceof GuiMultiplayer && ((GuiMultiplayer)this.parentScreen).serverListSelector.getSelectedServer() != -1) {
            this.buttonList.add(new GuiButton(3, this.width / 2 - 100, this.height / 2 + this.field_175353_i / 2 + this.fontRendererObj.FONT_HEIGHT + 72, "\u00a74Delete Server\u00a7r"));
        }
        if (WurstClient.INSTANCE.options.autoReconnect) {
            this.autoReconnectTimer = 100;
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (WurstClient.INSTANCE.options.autoReconnect) {
            if (this.buttonList.size() < 2) {
                return;
            }
            ((GuiButton)this.buttonList.get((int)2)).displayString = "AutoReconnect (" + (this.autoReconnectTimer / 20 + 1) + ")";
            if (this.autoReconnectTimer > 0) {
                --this.autoReconnectTimer;
            } else {
                try {
                    this.actionPerformed((GuiButton)this.buttonList.get(1));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ((GuiButton)this.buttonList.get((int)2)).displayString = "AutoReconnect";
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.id == 0) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (button.id == 1) {
            ServerHook.reconnectToLastServer(this);
        } else if (button.id == 2) {
            WurstClient.INSTANCE.options.autoReconnect = !WurstClient.INSTANCE.options.autoReconnect;
            WurstClient.INSTANCE.files.saveOptions();
            if (WurstClient.INSTANCE.options.autoReconnect) {
                this.autoReconnectTimer = 100;
            }
        } else if (button.id == 3) {
            GuiMultiplayer servers = (GuiMultiplayer)this.parentScreen;
            servers.savedServerList.removeServerData(servers.serverListSelector.getSelectedServer());
            servers.savedServerList.saveServerList();
            servers.serverListSelector.setSelectedSlotIndex(-1);
            servers.serverListSelector.func_148195_a(servers.savedServerList);
            this.mc.displayGuiScreen(servers);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.reason, this.width / 2, this.height / 2 - this.field_175353_i / 2 - this.fontRendererObj.FONT_HEIGHT * 2, 0xAAAAAA);
        int i = this.height / 2 - this.field_175353_i / 2;
        if (this.multilineMessage != null) {
            for (String s : this.multilineMessage) {
                this.drawCenteredString(this.fontRendererObj, s, this.width / 2, i, 0xFFFFFF);
                i += this.fontRendererObj.FONT_HEIGHT;
            }
        }
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

