/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityRainFX
extends EntityFX {
    protected EntityRainFX(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.field_187129_i *= (double)0.3f;
        this.field_187130_j = Math.random() * (double)0.2f + (double)0.1f;
        this.field_187131_k *= (double)0.3f;
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.setParticleTextureIndex(19 + this.field_187136_p.nextInt(4));
        this.func_187115_a(0.01f, 0.01f);
        this.particleGravity = 0.06f;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public void func_189213_a() {
        BlockPos blockpos;
        IBlockState iblockstate;
        Material material;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_187130_j -= (double)this.particleGravity;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)0.98f;
        this.field_187130_j *= (double)0.98f;
        this.field_187131_k *= (double)0.98f;
        if (this.particleMaxAge-- <= 0) {
            this.func_187112_i();
        }
        if (this.field_187132_l) {
            if (Math.random() < 0.5) {
                this.func_187112_i();
            }
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
        if ((material = (iblockstate = this.field_187122_b.getBlockState(blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h))).getMaterial()).isLiquid() || material.isSolid()) {
            double d0 = 0.0;
            d0 = iblockstate.getBlock() instanceof BlockLiquid ? (double)(1.0f - BlockLiquid.getLiquidHeightPercent(iblockstate.getValue(BlockLiquid.LEVEL))) : iblockstate.func_185900_c((IBlockAccess)this.field_187122_b, (BlockPos)blockpos).maxY;
            double d1 = (double)MathHelper.floor_double(this.field_187127_g) + d0;
            if (this.field_187127_g < d1) {
                this.func_187112_i();
            }
        }
    }

    public static class Factory
    implements IParticleFactory {
        @Override
        public EntityFX getEntityFX(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new EntityRainFX(worldIn, xCoordIn, yCoordIn, zCoordIn);
        }
    }
}

