/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.MapData;

public class ItemRenderer {
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    private static final ResourceLocation RES_UNDERWATER_OVERLAY = new ResourceLocation("textures/misc/underwater.png");
    private final Minecraft mc;
    private ItemStack field_187467_d;
    private ItemStack field_187468_e;
    private float field_187469_f;
    private float field_187470_g;
    private float field_187471_h;
    private float field_187472_i;
    private final RenderManager renderManager;
    private final RenderItem itemRenderer;

    public ItemRenderer(Minecraft mcIn) {
        this.mc = mcIn;
        this.renderManager = mcIn.getRenderManager();
        this.itemRenderer = mcIn.getRenderItem();
    }

    public void renderItem(EntityLivingBase entityIn, ItemStack heldStack, ItemCameraTransforms.TransformType transform) {
        this.func_187462_a(entityIn, heldStack, transform, false);
    }

    public void func_187462_a(EntityLivingBase p_187462_1_, ItemStack p_187462_2_, ItemCameraTransforms.TransformType p_187462_3_, boolean p_187462_4_) {
        if (p_187462_2_ != null) {
            boolean flag;
            Item item = p_187462_2_.getItem();
            Block block = Block.getBlockFromItem(item);
            GlStateManager.pushMatrix();
            boolean bl = flag = this.itemRenderer.shouldRenderItemIn3D(p_187462_2_) && this.isBlockTranslucent(block);
            if (flag) {
                GlStateManager.depthMask(false);
            }
            this.itemRenderer.func_184392_a(p_187462_2_, p_187462_1_, p_187462_3_, p_187462_4_);
            if (flag) {
                GlStateManager.depthMask(true);
            }
            GlStateManager.popMatrix();
        }
    }

    private boolean isBlockTranslucent(Block blockIn) {
        return blockIn != null && blockIn.getBlockLayer() == BlockRenderLayer.TRANSLUCENT;
    }

    private void rotateArroundXAndY(float angle, float angleY) {
        GlStateManager.pushMatrix();
        GlStateManager.rotate(angle, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(angleY, 0.0f, 1.0f, 0.0f);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
    }

    private void func_187464_b() {
        EntityPlayerSP abstractclientplayer = this.mc.thePlayer;
        int i = this.mc.theWorld.getCombinedLight(new BlockPos(abstractclientplayer.posX, abstractclientplayer.posY + (double)abstractclientplayer.getEyeHeight(), abstractclientplayer.posZ), 0);
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, f, f1);
    }

    private void func_187458_c(float p_187458_1_) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        float f = entityplayersp.prevRenderArmPitch + (entityplayersp.renderArmPitch - entityplayersp.prevRenderArmPitch) * p_187458_1_;
        float f1 = entityplayersp.prevRenderArmYaw + (entityplayersp.renderArmYaw - entityplayersp.prevRenderArmYaw) * p_187458_1_;
        GlStateManager.rotate((entityplayersp.rotationPitch - f) * 0.1f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate((entityplayersp.rotationYaw - f1) * 0.1f, 0.0f, 1.0f, 0.0f);
    }

    private float getMapAngleFromPitch(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.clamp_float(f, 0.0f, 1.0f);
        f = -MathHelper.cos(f * (float)Math.PI) * 0.5f + 0.5f;
        return f;
    }

    private void func_187466_c() {
        if (!this.mc.thePlayer.isInvisible()) {
            GlStateManager.disableCull();
            GlStateManager.pushMatrix();
            GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            this.func_187455_a(EnumHandSide.RIGHT);
            this.func_187455_a(EnumHandSide.LEFT);
            GlStateManager.popMatrix();
            GlStateManager.enableCull();
        }
    }

    private void func_187455_a(EnumHandSide p_187455_1_) {
        this.mc.getTextureManager().bindTexture(this.mc.thePlayer.getLocationSkin());
        Render<EntityPlayerSP> render = this.renderManager.getEntityRenderObject(this.mc.thePlayer);
        RenderPlayer renderplayer = (RenderPlayer)render;
        GlStateManager.pushMatrix();
        float f = p_187455_1_ == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.rotate(92.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(45.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(f * -41.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.translate(f * 0.3f, -1.1f, 0.45f);
        if (p_187455_1_ == EnumHandSide.RIGHT) {
            renderplayer.renderRightArm(this.mc.thePlayer);
        } else {
            renderplayer.renderLeftArm(this.mc.thePlayer);
        }
        GlStateManager.popMatrix();
    }

    private void func_187465_a(float p_187465_1_, EnumHandSide p_187465_2_, float p_187465_3_, ItemStack p_187465_4_) {
        float f = p_187465_2_ == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.translate(f * 0.125f, -0.125f, 0.0f);
        if (!this.mc.thePlayer.isInvisible()) {
            GlStateManager.pushMatrix();
            GlStateManager.rotate(f * 10.0f, 0.0f, 0.0f, 1.0f);
            this.func_187456_a(p_187465_1_, p_187465_3_, p_187465_2_);
            GlStateManager.popMatrix();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate(f * 0.51f, -0.08f + p_187465_1_ * -1.2f, -0.75f);
        float f1 = MathHelper.sqrt_float(p_187465_3_);
        float f2 = MathHelper.sin(f1 * (float)Math.PI);
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.sin(f1 * ((float)Math.PI * 2));
        float f5 = -0.3f * MathHelper.sin(p_187465_3_ * (float)Math.PI);
        GlStateManager.translate(f * f3, f4 - 0.3f * f2, f5);
        GlStateManager.rotate(f2 * -45.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(f * f2 * -30.0f, 0.0f, 1.0f, 0.0f);
        this.func_187461_a(p_187465_4_);
        GlStateManager.popMatrix();
    }

    private void func_187463_a(float p_187463_1_, float p_187463_2_, float p_187463_3_) {
        float f = MathHelper.sqrt_float(p_187463_3_);
        float f1 = -0.2f * MathHelper.sin(p_187463_3_ * (float)Math.PI);
        float f2 = -0.4f * MathHelper.sin(f * (float)Math.PI);
        GlStateManager.translate(0.0f, -f1 / 2.0f, f2);
        float f3 = this.getMapAngleFromPitch(p_187463_1_);
        GlStateManager.translate(0.0f, 0.04f + p_187463_2_ * -1.2f + f3 * -0.5f, -0.72f);
        GlStateManager.rotate(f3 * -85.0f, 1.0f, 0.0f, 0.0f);
        this.func_187466_c();
        float f4 = MathHelper.sin(f * (float)Math.PI);
        GlStateManager.rotate(f4 * 20.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.scale(2.0f, 2.0f, 2.0f);
        this.func_187461_a(this.field_187467_d);
    }

    private void func_187461_a(ItemStack p_187461_1_) {
        GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(180.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.scale(0.38f, 0.38f, 0.38f);
        GlStateManager.disableLighting();
        this.mc.getTextureManager().bindTexture(RES_MAP_BACKGROUND);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        GlStateManager.translate(-0.5f, -0.5f, 0.0f);
        GlStateManager.scale(0.0078125f, 0.0078125f, 0.0078125f);
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos(-7.0, 135.0, 0.0).tex(0.0, 1.0).endVertex();
        vertexbuffer.pos(135.0, 135.0, 0.0).tex(1.0, 1.0).endVertex();
        vertexbuffer.pos(135.0, -7.0, 0.0).tex(1.0, 0.0).endVertex();
        vertexbuffer.pos(-7.0, -7.0, 0.0).tex(0.0, 0.0).endVertex();
        tessellator.draw();
        MapData mapdata = Items.filled_map.getMapData(p_187461_1_, this.mc.theWorld);
        if (mapdata != null) {
            this.mc.entityRenderer.getMapItemRenderer().renderMap(mapdata, false);
        }
        GlStateManager.enableLighting();
    }

    private void func_187456_a(float p_187456_1_, float p_187456_2_, EnumHandSide p_187456_3_) {
        boolean flag = p_187456_3_ != EnumHandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.sqrt_float(p_187456_2_);
        float f2 = -0.3f * MathHelper.sin(f1 * (float)Math.PI);
        float f3 = 0.4f * MathHelper.sin(f1 * ((float)Math.PI * 2));
        float f4 = -0.4f * MathHelper.sin(p_187456_2_ * (float)Math.PI);
        GlStateManager.translate(f * (f2 + 0.64000005f), f3 + -0.6f + p_187456_1_ * -0.6f, f4 + -0.71999997f);
        GlStateManager.rotate(f * 45.0f, 0.0f, 1.0f, 0.0f);
        float f5 = MathHelper.sin(p_187456_2_ * p_187456_2_ * (float)Math.PI);
        float f6 = MathHelper.sin(f1 * (float)Math.PI);
        GlStateManager.rotate(f * f6 * 70.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(f * f5 * -20.0f, 0.0f, 0.0f, 1.0f);
        EntityPlayerSP abstractclientplayer = this.mc.thePlayer;
        this.mc.getTextureManager().bindTexture(abstractclientplayer.getLocationSkin());
        GlStateManager.translate(f * -1.0f, 3.6f, 3.5f);
        GlStateManager.rotate(f * 120.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.rotate(200.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(f * -135.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.translate(f * 5.6f, 0.0f, 0.0f);
        RenderPlayer renderplayer = (RenderPlayer)this.renderManager.getEntityRenderObject(abstractclientplayer);
        GlStateManager.disableCull();
        if (flag) {
            renderplayer.renderRightArm(abstractclientplayer);
        } else {
            renderplayer.renderLeftArm(abstractclientplayer);
        }
        GlStateManager.enableCull();
    }

    private void func_187454_a(float p_187454_1_, EnumHandSide p_187454_2_, ItemStack p_187454_3_) {
        float f = (float)this.mc.thePlayer.getItemInUseCount() - p_187454_1_ + 1.0f;
        float f1 = f / (float)p_187454_3_.getMaxItemUseDuration();
        if (f1 < 0.8f) {
            float f2 = MathHelper.abs(MathHelper.cos(f / 4.0f * (float)Math.PI) * 0.1f);
            GlStateManager.translate(0.0f, f2, 0.0f);
        }
        float f3 = 1.0f - (float)Math.pow(f1, 27.0);
        int i = p_187454_2_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.translate(f3 * 0.6f * (float)i, f3 * -0.5f, f3 * 0.0f);
        GlStateManager.rotate((float)i * f3 * 90.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(f3 * 10.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate((float)i * f3 * 30.0f, 0.0f, 0.0f, 1.0f);
    }

    private void func_187453_a(EnumHandSide p_187453_1_, float p_187453_2_) {
        int i = p_187453_1_ == EnumHandSide.RIGHT ? 1 : -1;
        float f = MathHelper.sin(p_187453_2_ * p_187453_2_ * (float)Math.PI);
        GlStateManager.rotate((float)i * (45.0f + f * -20.0f), 0.0f, 1.0f, 0.0f);
        float f1 = MathHelper.sin(MathHelper.sqrt_float(p_187453_2_) * (float)Math.PI);
        GlStateManager.rotate((float)i * f1 * -20.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.rotate(f1 * -80.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate((float)i * -45.0f, 0.0f, 1.0f, 0.0f);
    }

    private void func_187459_b(EnumHandSide p_187459_1_, float p_187459_2_) {
        int i = p_187459_1_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.translate((float)i * 0.56f, -0.52f + p_187459_2_ * -0.6f, -0.72f);
    }

    public void renderItemInFirstPerson(float partialTicks) {
        ItemStack itemstack;
        EntityPlayerSP abstractclientplayer = this.mc.thePlayer;
        float f = abstractclientplayer.getSwingProgress(partialTicks);
        EnumHand enumhand = (EnumHand)((Object)Objects.firstNonNull((Object)((Object)abstractclientplayer.field_184622_au), (Object)((Object)EnumHand.MAIN_HAND)));
        float f1 = abstractclientplayer.prevRotationPitch + (abstractclientplayer.rotationPitch - abstractclientplayer.prevRotationPitch) * partialTicks;
        float f2 = abstractclientplayer.prevRotationYaw + (abstractclientplayer.rotationYaw - abstractclientplayer.prevRotationYaw) * partialTicks;
        boolean flag = true;
        boolean flag1 = true;
        if (((EntityLivingBase)abstractclientplayer).isUsingItem() && (itemstack = abstractclientplayer.func_184607_cu()).getItem() == Items.bow) {
            EnumHand enumhand1 = ((EntityLivingBase)abstractclientplayer).func_184600_cs();
            flag = enumhand1 == EnumHand.MAIN_HAND;
            flag1 = !flag;
        }
        this.rotateArroundXAndY(f1, f2);
        this.func_187464_b();
        this.func_187458_c(partialTicks);
        GlStateManager.enableRescaleNormal();
        if (flag) {
            float f3 = enumhand == EnumHand.MAIN_HAND ? f : 0.0f;
            float f5 = 1.0f - (this.field_187470_g + (this.field_187469_f - this.field_187470_g) * partialTicks);
            this.func_187457_a(abstractclientplayer, partialTicks, f1, EnumHand.MAIN_HAND, f3, this.field_187467_d, f5);
        }
        if (flag1) {
            float f4 = enumhand == EnumHand.OFF_HAND ? f : 0.0f;
            float f6 = 1.0f - (this.field_187472_i + (this.field_187471_h - this.field_187472_i) * partialTicks);
            this.func_187457_a(abstractclientplayer, partialTicks, f1, EnumHand.OFF_HAND, f4, this.field_187468_e, f6);
        }
        GlStateManager.disableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
    }

    public void func_187457_a(AbstractClientPlayer p_187457_1_, float p_187457_2_, float p_187457_3_, EnumHand p_187457_4_, float p_187457_5_, ItemStack p_187457_6_, float p_187457_7_) {
        boolean flag = p_187457_4_ == EnumHand.MAIN_HAND;
        EnumHandSide enumhandside = flag ? p_187457_1_.getPrimaryHand() : p_187457_1_.getPrimaryHand().opposite();
        GlStateManager.pushMatrix();
        if (p_187457_6_ == null) {
            if (flag && !p_187457_1_.isInvisible()) {
                this.func_187456_a(p_187457_7_, p_187457_5_, enumhandside);
            }
        } else if (p_187457_6_.getItem() == Items.filled_map) {
            if (flag && this.field_187468_e == null) {
                this.func_187463_a(p_187457_3_, p_187457_7_, p_187457_5_);
            } else {
                this.func_187465_a(p_187457_7_, enumhandside, p_187457_5_, p_187457_6_);
            }
        } else {
            boolean flag1;
            boolean bl = flag1 = enumhandside == EnumHandSide.RIGHT;
            if (p_187457_1_.isUsingItem() && p_187457_1_.getItemInUseCount() > 0 && p_187457_1_.func_184600_cs() == p_187457_4_) {
                int j = flag1 ? 1 : -1;
                switch (p_187457_6_.getItemUseAction()) {
                    case NONE: {
                        this.func_187459_b(enumhandside, p_187457_7_);
                        break;
                    }
                    case EAT: 
                    case DRINK: {
                        this.func_187454_a(p_187457_2_, enumhandside, p_187457_6_);
                        this.func_187459_b(enumhandside, p_187457_7_);
                        break;
                    }
                    case BLOCK: {
                        this.func_187459_b(enumhandside, p_187457_7_);
                        break;
                    }
                    case BOW: {
                        this.func_187459_b(enumhandside, p_187457_7_);
                        GlStateManager.translate((float)j * -0.2785682f, 0.18344387f, 0.15731531f);
                        GlStateManager.rotate(-13.935f, 1.0f, 0.0f, 0.0f);
                        GlStateManager.rotate((float)j * 35.3f, 0.0f, 1.0f, 0.0f);
                        GlStateManager.rotate((float)j * -9.785f, 0.0f, 0.0f, 1.0f);
                        float f5 = (float)p_187457_6_.getMaxItemUseDuration() - ((float)this.mc.thePlayer.getItemInUseCount() - p_187457_2_ + 1.0f);
                        float f6 = f5 / 20.0f;
                        f6 = (f6 * f6 + f6 * 2.0f) / 3.0f;
                        if (f6 > 1.0f) {
                            f6 = 1.0f;
                        }
                        if (f6 > 0.1f) {
                            float f7 = MathHelper.sin((f5 - 0.1f) * 1.3f);
                            float f3 = f6 - 0.1f;
                            float f4 = f7 * f3;
                            GlStateManager.translate(f4 * 0.0f, f4 * 0.004f, f4 * 0.0f);
                        }
                        GlStateManager.translate(f6 * 0.0f, f6 * 0.0f, f6 * 0.04f);
                        GlStateManager.scale(1.0f, 1.0f, 1.0f + f6 * 0.2f);
                        GlStateManager.rotate((float)j * 45.0f, 0.0f, -1.0f, 0.0f);
                    }
                }
            } else {
                float f = -0.4f * MathHelper.sin(MathHelper.sqrt_float(p_187457_5_) * (float)Math.PI);
                float f1 = 0.2f * MathHelper.sin(MathHelper.sqrt_float(p_187457_5_) * ((float)Math.PI * 2));
                float f2 = -0.2f * MathHelper.sin(p_187457_5_ * (float)Math.PI);
                int i = flag1 ? 1 : -1;
                GlStateManager.translate((float)i * f, f1, f2);
                this.func_187459_b(enumhandside, p_187457_7_);
                this.func_187453_a(enumhandside, p_187457_5_);
            }
            this.func_187462_a(p_187457_1_, p_187457_6_, flag1 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag1);
        }
        GlStateManager.popMatrix();
    }

    public void renderOverlays(float partialTicks) {
        GlStateManager.disableAlpha();
        if (this.mc.thePlayer.isEntityInsideOpaqueBlock()) {
            IBlockState iblockstate = this.mc.theWorld.getBlockState(new BlockPos(this.mc.thePlayer));
            EntityPlayerSP entityplayer = this.mc.thePlayer;
            int i = 0;
            while (i < 8) {
                double d0 = entityplayer.posX + (double)(((float)((i >> 0) % 2) - 0.5f) * entityplayer.width * 0.8f);
                double d1 = entityplayer.posY + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
                double d2 = entityplayer.posZ + (double)(((float)((i >> 2) % 2) - 0.5f) * entityplayer.width * 0.8f);
                BlockPos blockpos = new BlockPos(d0, d1 + (double)entityplayer.getEyeHeight(), d2);
                IBlockState iblockstate1 = this.mc.theWorld.getBlockState(blockpos);
                if (iblockstate1.getBlock().isVisuallyOpaque()) {
                    iblockstate = iblockstate1;
                }
                ++i;
            }
            if (iblockstate.getRenderType() != EnumBlockRenderType.INVISIBLE) {
                this.renderBlockInHand(partialTicks, this.mc.getBlockRendererDispatcher().getBlockModelShapes().getTexture(iblockstate));
            }
        }
        if (!this.mc.thePlayer.isSpectator()) {
            if (this.mc.thePlayer.isInsideOfMaterial(Material.water)) {
                this.renderWaterOverlayTexture(partialTicks);
            }
            if (this.mc.thePlayer.isBurning()) {
                this.renderFireInFirstPerson(partialTicks);
            }
        }
        GlStateManager.enableAlpha();
    }

    private void renderBlockInHand(float partialTicks, TextureAtlasSprite atlas) {
        this.mc.getTextureManager().bindTexture(TextureMap.locationBlocksTexture);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        float f = 0.1f;
        GlStateManager.color(0.1f, 0.1f, 0.1f, 0.5f);
        GlStateManager.pushMatrix();
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = atlas.getMinU();
        float f7 = atlas.getMaxU();
        float f8 = atlas.getMinV();
        float f9 = atlas.getMaxV();
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos(-1.0, -1.0, -0.5).tex(f7, f9).endVertex();
        vertexbuffer.pos(1.0, -1.0, -0.5).tex(f6, f9).endVertex();
        vertexbuffer.pos(1.0, 1.0, -0.5).tex(f6, f8).endVertex();
        vertexbuffer.pos(-1.0, 1.0, -0.5).tex(f7, f8).endVertex();
        tessellator.draw();
        GlStateManager.popMatrix();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderWaterOverlayTexture(float partialTicks) {
        this.mc.getTextureManager().bindTexture(RES_UNDERWATER_OVERLAY);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        float f = this.mc.thePlayer.getBrightness(partialTicks);
        GlStateManager.color(f, f, f, 0.5f);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -this.mc.thePlayer.rotationYaw / 64.0f;
        float f8 = this.mc.thePlayer.rotationPitch / 64.0f;
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos(-1.0, -1.0, -0.5).tex(4.0f + f7, 4.0f + f8).endVertex();
        vertexbuffer.pos(1.0, -1.0, -0.5).tex(0.0f + f7, 4.0f + f8).endVertex();
        vertexbuffer.pos(1.0, 1.0, -0.5).tex(0.0f + f7, 0.0f + f8).endVertex();
        vertexbuffer.pos(-1.0, 1.0, -0.5).tex(4.0f + f7, 0.0f + f8).endVertex();
        tessellator.draw();
        GlStateManager.popMatrix();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
    }

    private void renderFireInFirstPerson(float partialTicks) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 0.9f);
        GlStateManager.depthFunc(519);
        GlStateManager.depthMask(false);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        float f = 1.0f;
        int i = 0;
        while (i < 2) {
            GlStateManager.pushMatrix();
            TextureAtlasSprite textureatlassprite = this.mc.getTextureMapBlocks().getAtlasSprite("minecraft:blocks/fire_layer_1");
            this.mc.getTextureManager().bindTexture(TextureMap.locationBlocksTexture);
            float f1 = textureatlassprite.getMinU();
            float f2 = textureatlassprite.getMaxU();
            float f3 = textureatlassprite.getMinV();
            float f4 = textureatlassprite.getMaxV();
            float f5 = -0.5f;
            float f6 = 0.5f;
            float f7 = -0.5f;
            float f8 = 0.5f;
            float f9 = -0.5f;
            GlStateManager.translate((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            GlStateManager.rotate((float)(i * 2 - 1) * 10.0f, 0.0f, 1.0f, 0.0f);
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            vertexbuffer.pos(-0.5, -0.5, -0.5).tex(f2, f4).endVertex();
            vertexbuffer.pos(0.5, -0.5, -0.5).tex(f1, f4).endVertex();
            vertexbuffer.pos(0.5, 0.5, -0.5).tex(f1, f3).endVertex();
            vertexbuffer.pos(-0.5, 0.5, -0.5).tex(f2, f3).endVertex();
            tessellator.draw();
            GlStateManager.popMatrix();
            ++i;
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask(true);
        GlStateManager.depthFunc(515);
    }

    public void updateEquippedItem() {
        this.field_187470_g = this.field_187469_f;
        this.field_187472_i = this.field_187471_h;
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        ItemStack itemstack = entityplayersp.getHeldItemMainhand();
        ItemStack itemstack1 = entityplayersp.getHeldItemOffhand();
        if (entityplayersp.func_184838_M()) {
            this.field_187469_f = MathHelper.clamp_float(this.field_187469_f - 0.4f, 0.0f, 1.0f);
            this.field_187471_h = MathHelper.clamp_float(this.field_187471_h - 0.4f, 0.0f, 1.0f);
        } else {
            float f = entityplayersp.getSwordCooldown(1.0f);
            this.field_187469_f += MathHelper.clamp_float((Objects.equal((Object)this.field_187467_d, (Object)itemstack) ? f * f * f : 0.0f) - this.field_187469_f, -0.4f, 0.4f);
            this.field_187471_h += MathHelper.clamp_float((float)(Objects.equal((Object)this.field_187468_e, (Object)itemstack1) ? 1 : 0) - this.field_187471_h, -0.4f, 0.4f);
        }
        if (this.field_187469_f < 0.1f) {
            this.field_187467_d = itemstack;
        }
        if (this.field_187471_h < 0.1f) {
            this.field_187468_e = itemstack1;
        }
    }

    public void func_187460_a(EnumHand p_187460_1_) {
        if (p_187460_1_ == EnumHand.MAIN_HAND) {
            this.field_187469_f = 0.0f;
        } else {
            this.field_187471_h = 0.0f;
        }
    }
}

