/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldSettings;

public class CommandGameMode
extends CommandBase {
    @Override
    public String getCommandName() {
        return "gamemode";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandUsage(ICommandSender sender) {
        return "commands.gamemode.usage";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 0) {
            throw new WrongUsageException("commands.gamemode.usage", new Object[0]);
        }
        WorldSettings.GameType worldsettings$gametype = this.getGameModeFromCommand(sender, args[0]);
        EntityPlayerMP entityplayer = args.length >= 2 ? CommandGameMode.getPlayer(server, sender, args[1]) : CommandGameMode.getCommandSenderAsPlayer(sender);
        ((EntityPlayer)entityplayer).setGameType(worldsettings$gametype);
        TextComponentTranslation itextcomponent = new TextComponentTranslation("gameMode." + worldsettings$gametype.getName(), new Object[0]);
        if (sender.getEntityWorld().getGameRules().getBoolean("sendCommandFeedback")) {
            ((Entity)entityplayer).addChatMessage(new TextComponentTranslation("gameMode.changed", itextcomponent));
        }
        if (entityplayer != sender) {
            CommandGameMode.notifyOperators(sender, (ICommand)this, 1, "commands.gamemode.success.other", entityplayer.getName(), itextcomponent);
        } else {
            CommandGameMode.notifyOperators(sender, (ICommand)this, 1, "commands.gamemode.success.self", itextcomponent);
        }
    }

    protected WorldSettings.GameType getGameModeFromCommand(ICommandSender p_71539_1_, String p_71539_2_) throws CommandException, NumberInvalidException {
        WorldSettings.GameType worldsettings$gametype = WorldSettings.GameType.func_185328_a(p_71539_2_, WorldSettings.GameType.NOT_SET);
        return worldsettings$gametype == WorldSettings.GameType.NOT_SET ? WorldSettings.getGameTypeById(CommandGameMode.parseInt(p_71539_2_, 0, WorldSettings.GameType.values().length - 2)) : worldsettings$gametype;
    }

    @Override
    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? CommandGameMode.getListOfStringsMatchingLastWord(args, "survival", "creative", "adventure", "spectator") : (args.length == 2 ? CommandGameMode.getListOfStringsMatchingLastWord(args, server.getAllUsernames()) : Collections.emptyList());
    }

    @Override
    public boolean isUsernameIndex(String[] args, int index) {
        return index == 1;
    }
}

