/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.PotionTypes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityAreaEffectCloud
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.FLOAT);
    private static final DataParameter<Integer> field_184499_b = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.VARINT);
    private static final DataParameter<Boolean> field_184500_c = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.BOOLEAN);
    private static final DataParameter<Integer> PARTICLE = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.VARINT);
    private PotionType field_184502_e = PotionTypes.empty;
    private final List<PotionEffect> field_184503_f = Lists.newArrayList();
    private final Map<Entity, Integer> field_184504_g = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean field_184508_au;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private EntityLivingBase field_184512_ay;
    private UUID ownerUniqueId;

    public EntityAreaEffectCloud(World worldIn) {
        super(worldIn);
        this.noClip = true;
        this.isImmuneToFire = true;
        this.setRadius(3.0f);
    }

    public EntityAreaEffectCloud(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.setPosition(x, y, z);
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(field_184499_b, 0);
        this.getDataManager().register(RADIUS, Float.valueOf(0.5f));
        this.getDataManager().register(field_184500_c, false);
        this.getDataManager().register(PARTICLE, EnumParticleTypes.SPELL_MOB.getParticleID());
    }

    public void setRadius(float p_184483_1_) {
        double d0 = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        this.setSize(p_184483_1_ * 2.0f, 0.5f);
        this.setPosition(d0, d1, d2);
        if (!this.worldObj.isRemote) {
            this.getDataManager().set(RADIUS, Float.valueOf(p_184483_1_));
        }
    }

    public float getRadius() {
        return this.getDataManager().get(RADIUS).floatValue();
    }

    public void func_184484_a(PotionType p_184484_1_) {
        this.field_184502_e = p_184484_1_;
        if (!this.field_184508_au) {
            if (p_184484_1_ == PotionTypes.empty && this.field_184503_f.isEmpty()) {
                this.getDataManager().set(field_184499_b, 0);
            } else {
                this.getDataManager().set(field_184499_b, PotionUtils.func_185181_a(PotionUtils.func_185186_a(p_184484_1_, this.field_184503_f)));
            }
        }
    }

    public void func_184496_a(PotionEffect p_184496_1_) {
        this.field_184503_f.add(p_184496_1_);
        if (!this.field_184508_au) {
            this.getDataManager().set(field_184499_b, PotionUtils.func_185181_a(PotionUtils.func_185186_a(this.field_184502_e, this.field_184503_f)));
        }
    }

    public int func_184492_k() {
        return this.getDataManager().get(field_184499_b);
    }

    public void func_184482_a(int p_184482_1_) {
        this.field_184508_au = true;
        this.getDataManager().set(field_184499_b, p_184482_1_);
    }

    public EnumParticleTypes func_184493_l() {
        return EnumParticleTypes.getParticleFromId(this.getDataManager().get(PARTICLE));
    }

    public void func_184491_a(EnumParticleTypes p_184491_1_) {
        this.getDataManager().set(PARTICLE, p_184491_1_.getParticleID());
    }

    protected void func_184488_a(boolean p_184488_1_) {
        this.getDataManager().set(field_184500_c, p_184488_1_);
    }

    public boolean func_184497_n() {
        return this.getDataManager().get(field_184500_c);
    }

    public int func_184489_o() {
        return this.duration;
    }

    public void func_184486_b(int p_184486_1_) {
        this.duration = p_184486_1_;
    }

    @Override
    public void onUpdate() {
        block24: {
            boolean flag1;
            float f;
            boolean flag;
            block22: {
                EnumParticleTypes enumparticletypes;
                block23: {
                    super.onUpdate();
                    flag = this.func_184497_n();
                    f = this.getRadius();
                    if (!this.worldObj.isRemote) break block22;
                    enumparticletypes = this.func_184493_l();
                    if (!flag) break block23;
                    if (!this.rand.nextBoolean()) break block24;
                    int[] aint = new int[enumparticletypes.getArgumentCount()];
                    int i = 0;
                    while (i < 2) {
                        float f1 = this.rand.nextFloat() * ((float)Math.PI * 2);
                        float f2 = MathHelper.sqrt_float(this.rand.nextFloat()) * 0.2f;
                        float f3 = MathHelper.cos(f1) * f2;
                        float f4 = MathHelper.sin(f1) * f2;
                        if (enumparticletypes == EnumParticleTypes.SPELL_MOB) {
                            int j = this.rand.nextBoolean() ? 0xFFFFFF : this.func_184492_k();
                            int k = j >> 16 & 0xFF;
                            int l = j >> 8 & 0xFF;
                            int i1 = j & 0xFF;
                            this.worldObj.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + (double)f3, this.posY, this.posZ + (double)f4, (double)((float)k / 255.0f), (double)((float)l / 255.0f), (double)((float)i1 / 255.0f), new int[0]);
                        } else {
                            this.worldObj.spawnParticle(enumparticletypes, this.posX + (double)f3, this.posY, this.posZ + (double)f4, 0.0, 0.0, 0.0, aint);
                        }
                        ++i;
                    }
                    break block24;
                }
                float f5 = (float)Math.PI * f * f;
                int[] aint1 = new int[enumparticletypes.getArgumentCount()];
                int k1 = 0;
                while ((float)k1 < f5) {
                    float f6 = this.rand.nextFloat() * ((float)Math.PI * 2);
                    float f7 = MathHelper.sqrt_float(this.rand.nextFloat()) * f;
                    float f8 = MathHelper.cos(f6) * f7;
                    float f9 = MathHelper.sin(f6) * f7;
                    if (enumparticletypes == EnumParticleTypes.SPELL_MOB) {
                        int l1 = this.func_184492_k();
                        int i2 = l1 >> 16 & 0xFF;
                        int j2 = l1 >> 8 & 0xFF;
                        int j1 = l1 & 0xFF;
                        this.worldObj.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + (double)f8, this.posY, this.posZ + (double)f9, (double)((float)i2 / 255.0f), (double)((float)j2 / 255.0f), (double)((float)j1 / 255.0f), new int[0]);
                    } else {
                        this.worldObj.spawnParticle(enumparticletypes, this.posX + (double)f8, this.posY, this.posZ + (double)f9, (0.5 - this.rand.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.rand.nextDouble()) * 0.15, aint1);
                    }
                    ++k1;
                }
                break block24;
            }
            if (this.ticksExisted >= this.waitTime + this.duration) {
                this.setDead();
                return;
            }
            boolean bl = flag1 = this.ticksExisted < this.waitTime;
            if (flag != flag1) {
                this.func_184488_a(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.setDead();
                    return;
                }
                this.setRadius(f);
            }
            if (this.ticksExisted % 5 == 0) {
                Iterator<Map.Entry<Entity, Integer>> iterator = this.field_184504_g.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Entity, Integer> entry = iterator.next();
                    if (this.ticksExisted < entry.getValue()) continue;
                    iterator.remove();
                }
                ArrayList potions = Lists.newArrayList();
                for (PotionEffect potioneffect1 : this.field_184502_e.getEffects()) {
                    potions.add(new PotionEffect(potioneffect1.getPotion(), potioneffect1.getDuration() / 4, potioneffect1.getAmplifier(), potioneffect1.getIsAmbient(), potioneffect1.func_188418_e()));
                }
                potions.addAll(this.field_184503_f);
                if (potions.isEmpty()) {
                    this.field_184504_g.clear();
                } else {
                    List<EntityLivingBase> list = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox());
                    if (!list.isEmpty()) {
                        for (EntityLivingBase entitylivingbase : list) {
                            double d1;
                            double d0;
                            double d2;
                            if (this.field_184504_g.containsKey(entitylivingbase) || !entitylivingbase.func_184603_cC() || !((d2 = (d0 = entitylivingbase.posX - this.posX) * d0 + (d1 = entitylivingbase.posZ - this.posZ) * d1) <= (double)(f * f))) continue;
                            this.field_184504_g.put(entitylivingbase, this.ticksExisted + this.reapplicationDelay);
                            for (PotionEffect potioneffect : potions) {
                                if (potioneffect.getPotion().isInstant()) {
                                    potioneffect.getPotion().affectEntity(this, this.func_184494_w(), entitylivingbase, potioneffect.getAmplifier(), 0.5);
                                    continue;
                                }
                                entitylivingbase.addPotionEffect(new PotionEffect(potioneffect));
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((f += this.radiusOnUse) < 0.5f) {
                                    this.setDead();
                                    return;
                                }
                                this.setRadius(f);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration > 0) continue;
                            this.setDead();
                            return;
                        }
                    }
                }
            }
        }
    }

    public void func_184495_b(float p_184495_1_) {
        this.radiusOnUse = p_184495_1_;
    }

    public void func_184487_c(float p_184487_1_) {
        this.radiusPerTick = p_184487_1_;
    }

    public void func_184485_d(int p_184485_1_) {
        this.waitTime = p_184485_1_;
    }

    public void func_184481_a(EntityLivingBase p_184481_1_) {
        this.field_184512_ay = p_184481_1_;
        this.ownerUniqueId = p_184481_1_ == null ? null : p_184481_1_.getUniqueID();
    }

    public EntityLivingBase func_184494_w() {
        Entity entity;
        if (this.field_184512_ay == null && this.ownerUniqueId != null && this.worldObj instanceof WorldServer && (entity = ((WorldServer)this.worldObj).getEntityFromUuid(this.ownerUniqueId)) instanceof EntityLivingBase) {
            this.field_184512_ay = (EntityLivingBase)entity;
        }
        return this.field_184512_ay;
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound tagCompund) {
        EnumParticleTypes enumparticletypes;
        this.ticksExisted = tagCompund.getInteger("Age");
        this.duration = tagCompund.getInteger("Duration");
        this.waitTime = tagCompund.getInteger("WaitTime");
        this.reapplicationDelay = tagCompund.getInteger("ReapplicationDelay");
        this.durationOnUse = tagCompund.getInteger("DurationOnUse");
        this.radiusOnUse = tagCompund.getFloat("RadiusOnUse");
        this.radiusPerTick = tagCompund.getFloat("RadiusPerTick");
        this.setRadius(tagCompund.getFloat("Radius"));
        this.ownerUniqueId = tagCompund.getUniqueId("OwnerUUID");
        if (tagCompund.hasKey("Particle", 8) && (enumparticletypes = EnumParticleTypes.func_186831_a(tagCompund.getString("Particle"))) != null) {
            this.func_184491_a(enumparticletypes);
        }
        if (tagCompund.hasKey("Color", 99)) {
            this.func_184482_a(tagCompund.getInteger("Color"));
        }
        if (tagCompund.hasKey("Potion", 8)) {
            this.func_184484_a(PotionUtils.func_185187_c(tagCompund));
        }
        if (tagCompund.hasKey("Effects", 9)) {
            NBTTagList nbttaglist = tagCompund.getTagList("Effects", 10);
            this.field_184503_f.clear();
            int i = 0;
            while (i < nbttaglist.tagCount()) {
                PotionEffect potioneffect = PotionEffect.readCustomPotionEffectFromNBT(nbttaglist.getCompoundTagAt(i));
                if (potioneffect != null) {
                    this.func_184496_a(potioneffect);
                }
                ++i;
            }
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound tagCompound) {
        tagCompound.setInteger("Age", this.ticksExisted);
        tagCompound.setInteger("Duration", this.duration);
        tagCompound.setInteger("WaitTime", this.waitTime);
        tagCompound.setInteger("ReapplicationDelay", this.reapplicationDelay);
        tagCompound.setInteger("DurationOnUse", this.durationOnUse);
        tagCompound.setFloat("RadiusOnUse", this.radiusOnUse);
        tagCompound.setFloat("RadiusPerTick", this.radiusPerTick);
        tagCompound.setFloat("Radius", this.getRadius());
        tagCompound.setString("Particle", this.func_184493_l().getParticleName());
        if (this.ownerUniqueId != null) {
            tagCompound.setUniqueId("OwnerUUID", this.ownerUniqueId);
        }
        if (this.field_184508_au) {
            tagCompound.setInteger("Color", this.func_184492_k());
        }
        if (this.field_184502_e != PotionTypes.empty && this.field_184502_e != null) {
            tagCompound.setString("Potion", PotionType.REGISTRY.getNameForObject(this.field_184502_e).toString());
        }
        if (!this.field_184503_f.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.field_184503_f) {
                nbttaglist.appendTag(potioneffect.writeCustomPotionEffectToNBT(new NBTTagCompound()));
            }
            tagCompound.setTag("Effects", nbttaglist);
        }
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> key) {
        if (RADIUS.equals(key)) {
            this.setRadius(this.getRadius());
        }
        super.notifyDataManagerChange(key);
    }

    @Override
    public EnumPushReaction getPushReaction() {
        return EnumPushReaction.IGNORE;
    }
}

