/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class EntityMinecart
extends Entity
implements IWorldNameable {
    private static final DataParameter<Integer> field_184265_a = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> field_184266_b = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.VARINT);
    private static final DataParameter<Float> field_184267_c = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.FLOAT);
    private static final DataParameter<Integer> field_184268_d = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> field_184269_e = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.VARINT);
    private static final DataParameter<Boolean> field_184270_f = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.BOOLEAN);
    private boolean isInReverse;
    private static final int[][][] matrix;
    private int turnProgress;
    private double minecartX;
    private double minecartY;
    private double minecartZ;
    private double minecartYaw;
    private double minecartPitch;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    static {
        int[][][] nArrayArray = new int[10][][];
        int[][] nArrayArray2 = new int[2][];
        int[] nArray = new int[3];
        nArray[2] = -1;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 1;
        nArrayArray2[1] = nArray2;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[2][];
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        nArrayArray3[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArrayArray3[1] = nArray4;
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[2][];
        int[] nArray5 = new int[3];
        nArray5[0] = -1;
        nArray5[1] = -1;
        nArrayArray4[0] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArrayArray4[1] = nArray6;
        nArrayArray[2] = nArrayArray4;
        int[][] nArrayArray5 = new int[2][];
        int[] nArray7 = new int[3];
        nArray7[0] = -1;
        nArrayArray5[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 1;
        nArray8[1] = -1;
        nArrayArray5[1] = nArray8;
        nArrayArray[3] = nArrayArray5;
        int[][] nArrayArray6 = new int[2][];
        int[] nArray9 = new int[3];
        nArray9[2] = -1;
        nArrayArray6[0] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[1] = -1;
        nArray10[2] = 1;
        nArrayArray6[1] = nArray10;
        nArrayArray[4] = nArrayArray6;
        int[][] nArrayArray7 = new int[2][];
        int[] nArray11 = new int[3];
        nArray11[1] = -1;
        nArray11[2] = -1;
        nArrayArray7[0] = nArray11;
        int[] nArray12 = new int[3];
        nArray12[2] = 1;
        nArrayArray7[1] = nArray12;
        nArrayArray[5] = nArrayArray7;
        int[][] nArrayArray8 = new int[2][];
        int[] nArray13 = new int[3];
        nArray13[2] = 1;
        nArrayArray8[0] = nArray13;
        int[] nArray14 = new int[3];
        nArray14[0] = 1;
        nArrayArray8[1] = nArray14;
        nArrayArray[6] = nArrayArray8;
        int[][] nArrayArray9 = new int[2][];
        int[] nArray15 = new int[3];
        nArray15[2] = 1;
        nArrayArray9[0] = nArray15;
        int[] nArray16 = new int[3];
        nArray16[0] = -1;
        nArrayArray9[1] = nArray16;
        nArrayArray[7] = nArrayArray9;
        int[][] nArrayArray10 = new int[2][];
        int[] nArray17 = new int[3];
        nArray17[2] = -1;
        nArrayArray10[0] = nArray17;
        int[] nArray18 = new int[3];
        nArray18[0] = -1;
        nArrayArray10[1] = nArray18;
        nArrayArray[8] = nArrayArray10;
        int[][] nArrayArray11 = new int[2][];
        int[] nArray19 = new int[3];
        nArray19[2] = -1;
        nArrayArray11[0] = nArray19;
        int[] nArray20 = new int[3];
        nArray20[0] = 1;
        nArrayArray11[1] = nArray20;
        nArrayArray[9] = nArrayArray11;
        matrix = nArrayArray;
    }

    public EntityMinecart(World worldIn) {
        super(worldIn);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.7f);
    }

    public static EntityMinecart func_184263_a(World p_184263_0_, double p_184263_1_, double p_184263_3_, double p_184263_5_, Type p_184263_7_) {
        switch (p_184263_7_) {
            case CHEST: {
                return new EntityMinecartChest(p_184263_0_, p_184263_1_, p_184263_3_, p_184263_5_);
            }
            case FURNACE: {
                return new EntityMinecartFurnace(p_184263_0_, p_184263_1_, p_184263_3_, p_184263_5_);
            }
            case TNT: {
                return new EntityMinecartTNT(p_184263_0_, p_184263_1_, p_184263_3_, p_184263_5_);
            }
            case SPAWNER: {
                return new EntityMinecartMobSpawner(p_184263_0_, p_184263_1_, p_184263_3_, p_184263_5_);
            }
            case HOPPER: {
                return new EntityMinecartHopper(p_184263_0_, p_184263_1_, p_184263_3_, p_184263_5_);
            }
            case COMMAND_BLOCK: {
                return new EntityMinecartCommandBlock(p_184263_0_, p_184263_1_, p_184263_3_, p_184263_5_);
            }
        }
        return new EntityMinecartEmpty(p_184263_0_, p_184263_1_, p_184263_3_, p_184263_5_);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.register(field_184265_a, 0);
        this.dataWatcher.register(field_184266_b, 1);
        this.dataWatcher.register(field_184267_c, Float.valueOf(0.0f));
        this.dataWatcher.register(field_184268_d, 0);
        this.dataWatcher.register(field_184269_e, 6);
        this.dataWatcher.register(field_184270_f, false);
    }

    @Override
    public AxisAlignedBB getCollisionBox(Entity entityIn) {
        return entityIn.canBePushed() ? entityIn.getEntityBoundingBox() : null;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBox() {
        return null;
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    public EntityMinecart(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.setPosition(x, y, z);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
    }

    @Override
    public double getMountedYOffset() {
        return 0.0;
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (!this.worldObj.isRemote && !this.isDead) {
            boolean flag;
            if (this.isEntityInvulnerable(source)) {
                return false;
            }
            this.setRollingDirection(-this.getRollingDirection());
            this.setRollingAmplitude(10);
            this.setBeenAttacked();
            this.setDamage(this.getDamage() + amount * 10.0f);
            boolean bl = flag = source.getEntity() instanceof EntityPlayer && ((EntityPlayer)source.getEntity()).capabilities.isCreativeMode;
            if (flag || this.getDamage() > 40.0f) {
                this.removePassengers();
                if (flag && !this.hasCustomName()) {
                    this.setDead();
                } else {
                    this.killMinecart(source);
                }
            }
            return true;
        }
        return true;
    }

    public void killMinecart(DamageSource source) {
        this.setDead();
        if (this.worldObj.getGameRules().getBoolean("doEntityDrops")) {
            ItemStack itemstack = new ItemStack(Items.minecart, 1);
            if (this.getName() != null) {
                itemstack.setStackDisplayName(this.getName());
            }
            this.entityDropItem(itemstack, 0.0f);
        }
    }

    @Override
    public void performHurtAnimation() {
        this.setRollingDirection(-this.getRollingDirection());
        this.setRollingAmplitude(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void setDead() {
        super.setDead();
    }

    @Override
    public EnumFacing func_184172_bi() {
        return this.isInReverse ? this.getHorizontalFacing().getOpposite().rotateY() : this.getHorizontalFacing().rotateY();
    }

    @Override
    public void onUpdate() {
        if (this.getRollingAmplitude() > 0) {
            this.setRollingAmplitude(this.getRollingAmplitude() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (!this.worldObj.isRemote && this.worldObj instanceof WorldServer) {
            this.worldObj.theProfiler.startSection("portal");
            MinecraftServer minecraftserver = this.worldObj.getMinecraftServer();
            int i = this.getMaxInPortalTime();
            if (this.inPortal) {
                if (minecraftserver.getAllowNether()) {
                    if (!this.isRiding() && this.portalCounter++ >= i) {
                        this.portalCounter = i;
                        this.timeUntilPortal = this.getPortalCooldown();
                        int j = this.worldObj.provider.getDimensionType().getId() == -1 ? 0 : -1;
                        this.changeDimension(j);
                    }
                    this.inPortal = false;
                }
            } else {
                if (this.portalCounter > 0) {
                    this.portalCounter -= 4;
                }
                if (this.portalCounter < 0) {
                    this.portalCounter = 0;
                }
            }
            if (this.timeUntilPortal > 0) {
                --this.timeUntilPortal;
            }
            this.worldObj.theProfiler.endSection();
        }
        if (this.worldObj.isRemote) {
            if (this.turnProgress > 0) {
                double d4 = this.posX + (this.minecartX - this.posX) / (double)this.turnProgress;
                double d5 = this.posY + (this.minecartY - this.posY) / (double)this.turnProgress;
                double d6 = this.posZ + (this.minecartZ - this.posZ) / (double)this.turnProgress;
                double d1 = MathHelper.wrapAngleTo180_double(this.minecartYaw - (double)this.rotationYaw);
                this.rotationYaw = (float)((double)this.rotationYaw + d1 / (double)this.turnProgress);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.minecartPitch - (double)this.rotationPitch) / (double)this.turnProgress);
                --this.turnProgress;
                this.setPosition(d4, d5, d6);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            }
        } else {
            double d3;
            BlockPos blockpos;
            IBlockState iblockstate;
            int i1;
            int l;
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.motionY -= (double)0.04f;
            int k = MathHelper.floor_double(this.posX);
            if (BlockRailBase.isRailBlock(this.worldObj, new BlockPos(k, (l = MathHelper.floor_double(this.posY)) - 1, i1 = MathHelper.floor_double(this.posZ)))) {
                --l;
            }
            if (BlockRailBase.isRailBlock(iblockstate = this.worldObj.getBlockState(blockpos = new BlockPos(k, l, i1)))) {
                this.func_180460_a(blockpos, iblockstate);
                if (iblockstate.getBlock() == Blocks.activator_rail) {
                    this.onActivatorRailPass(k, l, i1, iblockstate.getValue(BlockRailPowered.POWERED));
                }
            } else {
                this.moveDerailedMinecart();
            }
            this.doBlockCollisions();
            this.rotationPitch = 0.0f;
            double d0 = this.prevPosX - this.posX;
            double d2 = this.prevPosZ - this.posZ;
            if (d0 * d0 + d2 * d2 > 0.001) {
                this.rotationYaw = (float)(MathHelper.atan2(d2, d0) * 180.0 / Math.PI);
                if (this.isInReverse) {
                    this.rotationYaw += 180.0f;
                }
            }
            if ((d3 = (double)MathHelper.wrapAngleTo180_float(this.rotationYaw - this.prevRotationYaw)) < -170.0 || d3 >= 170.0) {
                this.rotationYaw += 180.0f;
                this.isInReverse = !this.isInReverse;
            }
            this.setRotation(this.rotationYaw, this.rotationPitch);
            for (Entity entity : this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.getEntityBoundingBox().expand(0.2f, 0.0, 0.2f))) {
                if (this.isPassenger(entity) || !entity.canBePushed() || !(entity instanceof EntityMinecart)) continue;
                entity.applyEntityCollision(this);
            }
            this.handleWaterMovement();
        }
    }

    protected double getMaximumSpeed() {
        return 0.4;
    }

    public void onActivatorRailPass(int x, int y, int z, boolean receivingPower) {
    }

    protected void moveDerailedMinecart() {
        double d0 = this.getMaximumSpeed();
        this.motionX = MathHelper.clamp_double(this.motionX, -d0, d0);
        this.motionZ = MathHelper.clamp_double(this.motionZ, -d0, d0);
        if (this.onGround) {
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        if (!this.onGround) {
            this.motionX *= (double)0.95f;
            this.motionY *= (double)0.95f;
            this.motionZ *= (double)0.95f;
        }
    }

    protected void func_180460_a(BlockPos p_180460_1_, IBlockState p_180460_2_) {
        double d6;
        Entity entity;
        double d5;
        this.fallDistance = 0.0f;
        Vec3d vec3d = this.func_70489_a(this.posX, this.posY, this.posZ);
        this.posY = p_180460_1_.getY();
        boolean flag = false;
        boolean flag1 = false;
        BlockRailBase blockrailbase = (BlockRailBase)p_180460_2_.getBlock();
        if (blockrailbase == Blocks.golden_rail) {
            flag = p_180460_2_.getValue(BlockRailPowered.POWERED);
            flag1 = !flag;
        }
        double d0 = 0.0078125;
        BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = p_180460_2_.getValue(blockrailbase.getShapeProperty());
        switch (blockrailbase$enumraildirection) {
            case ASCENDING_EAST: {
                this.motionX -= 0.0078125;
                this.posY += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.motionX += 0.0078125;
                this.posY += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.motionZ += 0.0078125;
                this.posY += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.motionZ -= 0.0078125;
                this.posY += 1.0;
            }
        }
        int[][] aint = matrix[blockrailbase$enumraildirection.getMetadata()];
        double d1 = aint[1][0] - aint[0][0];
        double d2 = aint[1][2] - aint[0][2];
        double d3 = Math.sqrt(d1 * d1 + d2 * d2);
        double d4 = this.motionX * d1 + this.motionZ * d2;
        if (d4 < 0.0) {
            d1 = -d1;
            d2 = -d2;
        }
        if ((d5 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ)) > 2.0) {
            d5 = 2.0;
        }
        this.motionX = d5 * d1 / d3;
        this.motionZ = d5 * d2 / d3;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : this.getPassengers().get(0);
        if (entity instanceof EntityLivingBase && (d6 = (double)((EntityLivingBase)entity).moveForward) > 0.0) {
            double d7 = -Math.sin(entity.rotationYaw * ((float)Math.PI / 180));
            double d8 = Math.cos(entity.rotationYaw * ((float)Math.PI / 180));
            double d9 = this.motionX * this.motionX + this.motionZ * this.motionZ;
            if (d9 < 0.01) {
                this.motionX += d7 * 0.1;
                this.motionZ += d8 * 0.1;
                flag1 = false;
            }
        }
        if (flag1) {
            double d17 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (d17 < 0.03) {
                this.motionX *= 0.0;
                this.motionY *= 0.0;
                this.motionZ *= 0.0;
            } else {
                this.motionX *= 0.5;
                this.motionY *= 0.0;
                this.motionZ *= 0.5;
            }
        }
        double d18 = 0.0;
        double d19 = (double)p_180460_1_.getX() + 0.5 + (double)aint[0][0] * 0.5;
        double d20 = (double)p_180460_1_.getZ() + 0.5 + (double)aint[0][2] * 0.5;
        double d21 = (double)p_180460_1_.getX() + 0.5 + (double)aint[1][0] * 0.5;
        double d10 = (double)p_180460_1_.getZ() + 0.5 + (double)aint[1][2] * 0.5;
        d1 = d21 - d19;
        d2 = d10 - d20;
        if (d1 == 0.0) {
            this.posX = (double)p_180460_1_.getX() + 0.5;
            d18 = this.posZ - (double)p_180460_1_.getZ();
        } else if (d2 == 0.0) {
            this.posZ = (double)p_180460_1_.getZ() + 0.5;
            d18 = this.posX - (double)p_180460_1_.getX();
        } else {
            double d11 = this.posX - d19;
            double d12 = this.posZ - d20;
            d18 = (d11 * d1 + d12 * d2) * 2.0;
        }
        this.posX = d19 + d1 * d18;
        this.posZ = d20 + d2 * d18;
        this.setPosition(this.posX, this.posY, this.posZ);
        double d22 = this.motionX;
        double d23 = this.motionZ;
        if (this.isBeingRidden()) {
            d22 *= 0.75;
            d23 *= 0.75;
        }
        double d13 = this.getMaximumSpeed();
        d22 = MathHelper.clamp_double(d22, -d13, d13);
        d23 = MathHelper.clamp_double(d23, -d13, d13);
        this.moveEntity(d22, 0.0, d23);
        if (aint[0][1] != 0 && MathHelper.floor_double(this.posX) - p_180460_1_.getX() == aint[0][0] && MathHelper.floor_double(this.posZ) - p_180460_1_.getZ() == aint[0][2]) {
            this.setPosition(this.posX, this.posY + (double)aint[0][1], this.posZ);
        } else if (aint[1][1] != 0 && MathHelper.floor_double(this.posX) - p_180460_1_.getX() == aint[1][0] && MathHelper.floor_double(this.posZ) - p_180460_1_.getZ() == aint[1][2]) {
            this.setPosition(this.posX, this.posY + (double)aint[1][1], this.posZ);
        }
        this.applyDrag();
        Vec3d vec3d1 = this.func_70489_a(this.posX, this.posY, this.posZ);
        if (vec3d1 != null && vec3d != null) {
            double d14 = (vec3d.yCoord - vec3d1.yCoord) * 0.05;
            d5 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (d5 > 0.0) {
                this.motionX = this.motionX / d5 * (d5 + d14);
                this.motionZ = this.motionZ / d5 * (d5 + d14);
            }
            this.setPosition(this.posX, vec3d1.yCoord, this.posZ);
        }
        int j = MathHelper.floor_double(this.posX);
        int i = MathHelper.floor_double(this.posZ);
        if (j != p_180460_1_.getX() || i != p_180460_1_.getZ()) {
            d5 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.motionX = d5 * (double)(j - p_180460_1_.getX());
            this.motionZ = d5 * (double)(i - p_180460_1_.getZ());
        }
        if (flag) {
            double d15 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (d15 > 0.01) {
                double d16 = 0.06;
                this.motionX += this.motionX / d15 * d16;
                this.motionZ += this.motionZ / d15 * d16;
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.EAST_WEST) {
                if (this.worldObj.getBlockState(p_180460_1_.west()).isNormalCube()) {
                    this.motionX = 0.02;
                } else if (this.worldObj.getBlockState(p_180460_1_.east()).isNormalCube()) {
                    this.motionX = -0.02;
                }
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                if (this.worldObj.getBlockState(p_180460_1_.north()).isNormalCube()) {
                    this.motionZ = 0.02;
                } else if (this.worldObj.getBlockState(p_180460_1_.south()).isNormalCube()) {
                    this.motionZ = -0.02;
                }
            }
        }
    }

    protected void applyDrag() {
        if (this.isBeingRidden()) {
            this.motionX *= (double)0.997f;
            this.motionY *= 0.0;
            this.motionZ *= (double)0.997f;
        } else {
            this.motionX *= (double)0.96f;
            this.motionY *= 0.0;
            this.motionZ *= (double)0.96f;
        }
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        float f = this.width / 2.0f;
        float f1 = this.height;
        this.setEntityBoundingBox(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public Vec3d func_70495_a(double p_70495_1_, double p_70495_3_, double p_70495_5_, double p_70495_7_) {
        IBlockState iblockstate;
        int k;
        int j;
        int i = MathHelper.floor_double(p_70495_1_);
        if (BlockRailBase.isRailBlock(this.worldObj, new BlockPos(i, (j = MathHelper.floor_double(p_70495_3_)) - 1, k = MathHelper.floor_double(p_70495_5_)))) {
            --j;
        }
        if (BlockRailBase.isRailBlock(iblockstate = this.worldObj.getBlockState(new BlockPos(i, j, k)))) {
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = iblockstate.getValue(((BlockRailBase)iblockstate.getBlock()).getShapeProperty());
            p_70495_3_ = j;
            if (blockrailbase$enumraildirection.isAscending()) {
                p_70495_3_ = j + 1;
            }
            int[][] aint = matrix[blockrailbase$enumraildirection.getMetadata()];
            double d0 = aint[1][0] - aint[0][0];
            double d1 = aint[1][2] - aint[0][2];
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            if (aint[0][1] != 0 && MathHelper.floor_double(p_70495_1_ += (d0 /= d2) * p_70495_7_) - i == aint[0][0] && MathHelper.floor_double(p_70495_5_ += (d1 /= d2) * p_70495_7_) - k == aint[0][2]) {
                p_70495_3_ += (double)aint[0][1];
            } else if (aint[1][1] != 0 && MathHelper.floor_double(p_70495_1_) - i == aint[1][0] && MathHelper.floor_double(p_70495_5_) - k == aint[1][2]) {
                p_70495_3_ += (double)aint[1][1];
            }
            return this.func_70489_a(p_70495_1_, p_70495_3_, p_70495_5_);
        }
        return null;
    }

    public Vec3d func_70489_a(double p_70489_1_, double p_70489_3_, double p_70489_5_) {
        IBlockState iblockstate;
        int k;
        int j;
        int i = MathHelper.floor_double(p_70489_1_);
        if (BlockRailBase.isRailBlock(this.worldObj, new BlockPos(i, (j = MathHelper.floor_double(p_70489_3_)) - 1, k = MathHelper.floor_double(p_70489_5_)))) {
            --j;
        }
        if (BlockRailBase.isRailBlock(iblockstate = this.worldObj.getBlockState(new BlockPos(i, j, k)))) {
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = iblockstate.getValue(((BlockRailBase)iblockstate.getBlock()).getShapeProperty());
            int[][] aint = matrix[blockrailbase$enumraildirection.getMetadata()];
            double d0 = 0.0;
            double d1 = (double)i + 0.5 + (double)aint[0][0] * 0.5;
            double d2 = (double)j + 0.0625 + (double)aint[0][1] * 0.5;
            double d3 = (double)k + 0.5 + (double)aint[0][2] * 0.5;
            double d4 = (double)i + 0.5 + (double)aint[1][0] * 0.5;
            double d5 = (double)j + 0.0625 + (double)aint[1][1] * 0.5;
            double d6 = (double)k + 0.5 + (double)aint[1][2] * 0.5;
            double d7 = d4 - d1;
            double d8 = (d5 - d2) * 2.0;
            double d9 = d6 - d3;
            if (d7 == 0.0) {
                p_70489_1_ = (double)i + 0.5;
                d0 = p_70489_5_ - (double)k;
            } else if (d9 == 0.0) {
                p_70489_5_ = (double)k + 0.5;
                d0 = p_70489_1_ - (double)i;
            } else {
                double d10 = p_70489_1_ - d1;
                double d11 = p_70489_5_ - d3;
                d0 = (d10 * d7 + d11 * d9) * 2.0;
            }
            p_70489_1_ = d1 + d7 * d0;
            p_70489_3_ = d2 + d8 * d0;
            p_70489_5_ = d3 + d9 * d0;
            if (d8 < 0.0) {
                p_70489_3_ += 1.0;
            }
            if (d8 > 0.0) {
                p_70489_3_ += 0.5;
            }
            return new Vec3d(p_70489_1_, p_70489_3_, p_70489_5_);
        }
        return null;
    }

    @Override
    public AxisAlignedBB func_184177_bl() {
        AxisAlignedBB axisalignedbb = this.getEntityBoundingBox();
        return this.hasDisplayTile() ? axisalignedbb.func_186662_g((double)Math.abs(this.getDisplayTileOffset()) / 16.0) : axisalignedbb;
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound tagCompund) {
        if (tagCompund.getBoolean("CustomDisplayTile")) {
            Block block = tagCompund.hasKey("DisplayTile", 8) ? Block.getBlockFromName(tagCompund.getString("DisplayTile")) : Block.getBlockById(tagCompund.getInteger("DisplayTile"));
            int i = tagCompund.getInteger("DisplayData");
            this.func_174899_a(block == null ? Blocks.air.getDefaultState() : block.getStateFromMeta(i));
            this.setDisplayTileOffset(tagCompund.getInteger("DisplayOffset"));
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound tagCompound) {
        if (this.hasDisplayTile()) {
            tagCompound.setBoolean("CustomDisplayTile", true);
            IBlockState iblockstate = this.getDisplayTile();
            ResourceLocation resourcelocation = Block.blockRegistry.getNameForObject(iblockstate.getBlock());
            tagCompound.setString("DisplayTile", resourcelocation == null ? "" : resourcelocation.toString());
            tagCompound.setInteger("DisplayData", iblockstate.getBlock().getMetaFromState(iblockstate));
            tagCompound.setInteger("DisplayOffset", this.getDisplayTileOffset());
        }
    }

    @Override
    public void applyEntityCollision(Entity entityIn) {
        if (!(this.worldObj.isRemote || entityIn.noClip || this.noClip || this.isPassenger(entityIn))) {
            double d1;
            double d0;
            double d2;
            if (entityIn instanceof EntityLivingBase && this.func_184264_v() == Type.RIDEABLE && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.01 && !(entityIn instanceof EntityPlayer) && !(entityIn instanceof EntityIronGolem) && !this.isBeingRidden() && !entityIn.isRiding()) {
                entityIn.startRiding(this);
            }
            if ((d2 = (d0 = entityIn.posX - this.posX) * d0 + (d1 = entityIn.posZ - this.posZ) * d1) >= (double)1.0E-4f) {
                d2 = MathHelper.sqrt_double(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= (double)(1.0f - this.entityCollisionReduction);
                d1 *= (double)(1.0f - this.entityCollisionReduction);
                d0 *= 0.5;
                d1 *= 0.5;
                if (entityIn instanceof EntityMinecart) {
                    Vec3d vec3d1;
                    double d4 = entityIn.posX - this.posX;
                    double d5 = entityIn.posZ - this.posZ;
                    Vec3d vec3d = new Vec3d(d4, 0.0, d5).normalize();
                    double d6 = Math.abs(vec3d.dotProduct(vec3d1 = new Vec3d(MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)), 0.0, MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180))).normalize()));
                    if (d6 < (double)0.8f) {
                        return;
                    }
                    double d7 = entityIn.motionX + this.motionX;
                    double d8 = entityIn.motionZ + this.motionZ;
                    if (((EntityMinecart)entityIn).func_184264_v() == Type.FURNACE && this.func_184264_v() != Type.FURNACE) {
                        this.motionX *= (double)0.2f;
                        this.motionZ *= (double)0.2f;
                        this.addVelocity(entityIn.motionX - d0, 0.0, entityIn.motionZ - d1);
                        entityIn.motionX *= (double)0.95f;
                        entityIn.motionZ *= (double)0.95f;
                    } else if (((EntityMinecart)entityIn).func_184264_v() != Type.FURNACE && this.func_184264_v() == Type.FURNACE) {
                        entityIn.motionX *= (double)0.2f;
                        entityIn.motionZ *= (double)0.2f;
                        entityIn.addVelocity(this.motionX + d0, 0.0, this.motionZ + d1);
                        this.motionX *= (double)0.95f;
                        this.motionZ *= (double)0.95f;
                    } else {
                        this.motionX *= (double)0.2f;
                        this.motionZ *= (double)0.2f;
                        this.addVelocity((d7 /= 2.0) - d0, 0.0, (d8 /= 2.0) - d1);
                        entityIn.motionX *= (double)0.2f;
                        entityIn.motionZ *= (double)0.2f;
                        entityIn.addVelocity(d7 + d0, 0.0, d8 + d1);
                    }
                } else {
                    this.addVelocity(-d0, 0.0, -d1);
                    entityIn.addVelocity(d0 / 4.0, 0.0, d1 / 4.0);
                }
            }
        }
    }

    @Override
    public void setPositionAndRotation2(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean p_180426_10_) {
        this.minecartX = x;
        this.minecartY = y;
        this.minecartZ = z;
        this.minecartYaw = yaw;
        this.minecartPitch = pitch;
        this.turnProgress = posRotationIncrements + 2;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @Override
    public void setVelocity(double x, double y, double z) {
        this.velocityX = this.motionX = x;
        this.velocityY = this.motionY = y;
        this.velocityZ = this.motionZ = z;
    }

    public void setDamage(float p_70492_1_) {
        this.dataWatcher.set(field_184267_c, Float.valueOf(p_70492_1_));
    }

    public float getDamage() {
        return this.dataWatcher.get(field_184267_c).floatValue();
    }

    public void setRollingAmplitude(int p_70497_1_) {
        this.dataWatcher.set(field_184265_a, p_70497_1_);
    }

    public int getRollingAmplitude() {
        return this.dataWatcher.get(field_184265_a);
    }

    public void setRollingDirection(int p_70494_1_) {
        this.dataWatcher.set(field_184266_b, p_70494_1_);
    }

    public int getRollingDirection() {
        return this.dataWatcher.get(field_184266_b);
    }

    public abstract Type func_184264_v();

    public IBlockState getDisplayTile() {
        return !this.hasDisplayTile() ? this.getDefaultDisplayTile() : Block.getStateById(this.getDataManager().get(field_184268_d));
    }

    public IBlockState getDefaultDisplayTile() {
        return Blocks.air.getDefaultState();
    }

    public int getDisplayTileOffset() {
        return !this.hasDisplayTile() ? this.getDefaultDisplayTileOffset() : this.getDataManager().get(field_184269_e).intValue();
    }

    public int getDefaultDisplayTileOffset() {
        return 6;
    }

    public void func_174899_a(IBlockState p_174899_1_) {
        this.getDataManager().set(field_184268_d, Block.getStateId(p_174899_1_));
        this.setHasDisplayTile(true);
    }

    public void setDisplayTileOffset(int p_94086_1_) {
        this.getDataManager().set(field_184269_e, p_94086_1_);
        this.setHasDisplayTile(true);
    }

    public boolean hasDisplayTile() {
        return this.getDataManager().get(field_184270_f);
    }

    public void setHasDisplayTile(boolean p_94096_1_) {
        this.getDataManager().set(field_184270_f, p_94096_1_);
    }

    public static enum Type {
        RIDEABLE(0, "MinecartRideable"),
        CHEST(1, "MinecartChest"),
        FURNACE(2, "MinecartFurnace"),
        TNT(3, "MinecartTNT"),
        SPAWNER(4, "MinecartSpawner"),
        HOPPER(5, "MinecartHopper"),
        COMMAND_BLOCK(6, "MinecartCommandBlock");

        private static final Map<Integer, Type> field_184965_h;
        private final int field_184966_i;
        private final String field_184967_j;

        static {
            field_184965_h = Maps.newHashMap();
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type entityminecart$type = typeArray[n2];
                field_184965_h.put(entityminecart$type.func_184956_a(), entityminecart$type);
                ++n2;
            }
        }

        private Type(int p_i47005_3_, String p_i47005_4_) {
            this.field_184966_i = p_i47005_3_;
            this.field_184967_j = p_i47005_4_;
        }

        public int func_184956_a() {
            return this.field_184966_i;
        }

        public String func_184954_b() {
            return this.field_184967_j;
        }

        public static Type func_184955_a(int p_184955_0_) {
            Type entityminecart$type = field_184965_h.get(p_184955_0_);
            return entityminecart$type == null ? RIDEABLE : entityminecart$type;
        }
    }
}

