/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySpider
extends EntityMob {
    private static final DataParameter<Byte> field_184729_a = EntityDataManager.createKey(EntitySpider.class, DataSerializers.BYTE);

    public EntitySpider(World worldIn) {
        super(worldIn);
        this.setSize(1.4f, 0.9f);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(3, new EntityAILeapAtTarget(this, 0.4f));
        this.tasks.addTask(4, new AISpiderAttack(this));
        this.tasks.addTask(5, new EntityAIWander(this, 0.8));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, new AISpiderTarget<EntityPlayer>(this, EntityPlayer.class));
        this.targetTasks.addTask(3, new AISpiderTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    public double getMountedYOffset() {
        return this.height * 0.5f;
    }

    @Override
    protected PathNavigate getNewNavigator(World worldIn) {
        return new PathNavigateClimber(this, worldIn);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.register(field_184729_a, (byte)0);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            this.setBesideClimbableBlock(this.isCollidedHorizontally);
        }
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(16.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3f);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.entity_spider_ambient;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.entity_spider_hurt;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.entity_spider_death;
    }

    @Override
    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.playSound(SoundEvents.entity_spider_step, 0.15f, 1.0f);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableList.ENTITIES_SPIDER;
    }

    @Override
    public boolean isOnLadder() {
        return this.isBesideClimbableBlock();
    }

    @Override
    public void setInWeb() {
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean isPotionApplicable(PotionEffect potioneffectIn) {
        return potioneffectIn.getPotion() == MobEffects.poison ? false : super.isPotionApplicable(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return (this.dataWatcher.get(field_184729_a) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean p_70839_1_) {
        byte b0 = this.dataWatcher.get(field_184729_a);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.dataWatcher.set(field_184729_a, b0);
    }

    @Override
    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        Potion potion;
        livingdata = super.onInitialSpawn(difficulty, livingdata);
        if (this.worldObj.rand.nextInt(100) == 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(this.worldObj);
            entityskeleton.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, 0.0f);
            entityskeleton.onInitialSpawn(difficulty, null);
            this.worldObj.spawnEntityInWorld(entityskeleton);
            entityskeleton.startRiding(this);
        }
        if (livingdata == null) {
            livingdata = new GroupData();
            if (this.worldObj.getDifficulty() == EnumDifficulty.HARD && this.worldObj.rand.nextFloat() < 0.1f * difficulty.getClampedAdditionalDifficulty()) {
                ((GroupData)livingdata).func_111104_a(this.worldObj.rand);
            }
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).field_188478_a) != null) {
            this.addPotionEffect(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    @Override
    public float getEyeHeight() {
        return 0.65f;
    }

    static class AISpiderAttack
    extends EntityAIAttackMelee {
        public AISpiderAttack(EntitySpider p_i46676_1_) {
            super(p_i46676_1_, 1.0, true);
        }

        @Override
        public boolean continueExecuting() {
            float f = this.attacker.getBrightness(1.0f);
            if (f >= 0.5f && this.attacker.getRNG().nextInt(100) == 0) {
                this.attacker.setAttackTarget(null);
                return false;
            }
            return super.continueExecuting();
        }

        @Override
        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.width;
        }
    }

    static class AISpiderTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpiderTarget(EntitySpider spider, Class<T> classTarget) {
            super((EntityCreature)spider, classTarget, true);
        }

        @Override
        public boolean shouldExecute() {
            float f = this.taskOwner.getBrightness(1.0f);
            return f >= 0.5f ? false : super.shouldExecute();
        }
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion field_188478_a;

        public void func_111104_a(Random rand) {
            int i = rand.nextInt(5);
            if (i <= 1) {
                this.field_188478_a = MobEffects.moveSpeed;
            } else if (i <= 2) {
                this.field_188478_a = MobEffects.damageBoost;
            } else if (i <= 3) {
                this.field_188478_a = MobEffects.regeneration;
            } else if (i <= 4) {
                this.field_188478_a = MobEffects.invisibility;
            }
        }
    }
}

