/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemSnow
extends ItemBlock {
    public ItemSnow(Block block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand side, EnumFacing hitX, float hitY, float hitZ, float p_180614_9_) {
        if (stack.stackSize != 0 && playerIn.canPlayerEdit(pos, hitX, stack)) {
            IBlockState iblockstate1;
            AxisAlignedBB axisalignedbb;
            int i;
            IBlockState iblockstate = worldIn.getBlockState(pos);
            Block block = iblockstate.getBlock();
            BlockPos blockpos = pos;
            if (!(hitX == EnumFacing.UP && block == this.block || block.isReplaceable(worldIn, pos))) {
                blockpos = pos.offset(hitX);
                iblockstate = worldIn.getBlockState(blockpos);
                block = iblockstate.getBlock();
            }
            if (block == this.block && (i = iblockstate.getValue(BlockSnow.LAYERS).intValue()) <= 7 && (axisalignedbb = (iblockstate1 = iblockstate.withProperty(BlockSnow.LAYERS, Integer.valueOf(i + 1))).getSelectedBoundingBox(worldIn, blockpos)) != Block.NULL_AABB && worldIn.checkNoEntityCollision(axisalignedbb.offset(blockpos)) && worldIn.setBlockState(blockpos, iblockstate1, 10)) {
                SoundType soundtype = this.block.getStepSound();
                worldIn.func_184133_a(playerIn, blockpos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                --stack.stackSize;
                return EnumActionResult.SUCCESS;
            }
            return super.onItemUse(stack, playerIn, worldIn, blockpos, side, hitX, hitY, hitZ, p_180614_9_);
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public int getMetadata(int damage) {
        return damage;
    }
}

