/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Validate;

public class SPacketSoundEffect
implements Packet<INetHandlerPlayClient> {
    private SoundEvent sound;
    private SoundCategory category;
    private int posX;
    private int posY;
    private int posZ;
    private float soundVolume;
    private int soundPitch;

    public SPacketSoundEffect() {
    }

    public SPacketSoundEffect(SoundEvent soundIn, SoundCategory categoryIn, double xIn, double yIn, double zIn, float volumeIn, float pitchIn) {
        Validate.notNull((Object)soundIn, (String)"sound", (Object[])new Object[0]);
        this.sound = soundIn;
        this.category = categoryIn;
        this.posX = (int)(xIn * 8.0);
        this.posY = (int)(yIn * 8.0);
        this.posZ = (int)(zIn * 8.0);
        this.soundVolume = volumeIn;
        this.soundPitch = (int)(pitchIn * 63.5f);
        pitchIn = MathHelper.clamp_float(pitchIn, 0.0f, 255.0f);
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.sound = SoundEvent.soundEventRegistry.getObjectById(buf.readVarIntFromBuffer());
        this.category = buf.readEnumValue(SoundCategory.class);
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.soundVolume = buf.readFloat();
        this.soundPitch = buf.readUnsignedByte();
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeVarIntToBuffer(SoundEvent.soundEventRegistry.getIDForObject(this.sound));
        buf.writeEnumValue(this.category);
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeFloat(this.soundVolume);
        buf.writeByte(this.soundPitch);
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public SoundCategory getCategory() {
        return this.category;
    }

    public double getX() {
        return (float)this.posX / 8.0f;
    }

    public double getY() {
        return (float)this.posY / 8.0f;
    }

    public double getZ() {
        return (float)this.posZ / 8.0f;
    }

    public float getVolume() {
        return this.soundVolume;
    }

    public float getPitch() {
        return (float)this.soundPitch / 63.5f;
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleSoundEffect(this);
    }
}

