/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;

public abstract class PathNavigate {
    private static int field_188556_f = 20;
    protected EntityLiving theEntity;
    protected World worldObj;
    protected PathEntity currentPath;
    protected double speed;
    private final IAttributeInstance pathSearchRange;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3d lastPosCheck = Vec3d.ZERO;
    private Vec3d field_188557_k = Vec3d.ZERO;
    private long field_188558_l = 0L;
    private long field_188559_m = 0L;
    private double field_188560_n;
    private float field_188561_o = 0.5f;
    private boolean field_188562_p;
    private long field_188563_q;
    protected NodeProcessor nodeProcessor;
    private BlockPos field_188564_r;
    private final PathFinder pathFinder;

    public PathNavigate(EntityLiving entitylivingIn, World worldIn) {
        this.theEntity = entitylivingIn;
        this.worldObj = worldIn;
        this.pathSearchRange = entitylivingIn.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE);
        this.pathFinder = this.getPathFinder();
        this.worldObj.func_184140_C().func_184379_a(this);
    }

    protected abstract PathFinder getPathFinder();

    public void setSpeed(double speedIn) {
        this.speed = speedIn;
    }

    public float getPathSearchRange() {
        return (float)this.pathSearchRange.getAttributeValue();
    }

    public boolean func_188553_i() {
        return this.field_188562_p;
    }

    public void func_188554_j() {
        if (this.worldObj.getTotalWorldTime() - this.field_188563_q > (long)field_188556_f) {
            if (this.field_188564_r != null) {
                this.currentPath = null;
                this.currentPath = this.getPathToPos(this.field_188564_r);
                this.field_188563_q = this.worldObj.getTotalWorldTime();
                this.field_188562_p = false;
            }
        } else {
            this.field_188562_p = true;
        }
    }

    public final PathEntity getPathToXYZ(double x, double y, double z) {
        return this.getPathToPos(new BlockPos(MathHelper.floor_double(x), (int)y, MathHelper.floor_double(z)));
    }

    public PathEntity getPathToPos(BlockPos pos) {
        if (!this.canNavigate()) {
            return null;
        }
        if (this.currentPath != null && !this.currentPath.isFinished() && pos.equals(this.field_188564_r)) {
            return this.currentPath;
        }
        this.field_188564_r = pos;
        float f = this.getPathSearchRange();
        this.worldObj.theProfiler.startSection("pathfind");
        BlockPos blockpos = new BlockPos(this.theEntity);
        int i = (int)(f + 8.0f);
        ChunkCache chunkcache = new ChunkCache(this.worldObj, blockpos.add(-i, -i, -i), blockpos.add(i, i, i), 0);
        PathEntity pathentity = this.pathFinder.func_186336_a(chunkcache, this.theEntity, this.field_188564_r, f);
        this.worldObj.theProfiler.endSection();
        return pathentity;
    }

    public PathEntity getPathToEntityLiving(Entity entityIn) {
        if (!this.canNavigate()) {
            return null;
        }
        BlockPos blockpos = new BlockPos(entityIn);
        if (this.currentPath != null && !this.currentPath.isFinished() && blockpos.equals(this.field_188564_r)) {
            return this.currentPath;
        }
        this.field_188564_r = blockpos;
        float f = this.getPathSearchRange();
        this.worldObj.theProfiler.startSection("pathfind");
        BlockPos blockpos1 = new BlockPos(this.theEntity).up();
        int i = (int)(f + 16.0f);
        ChunkCache chunkcache = new ChunkCache(this.worldObj, blockpos1.add(-i, -i, -i), blockpos1.add(i, i, i), 0);
        PathEntity pathentity = this.pathFinder.func_186333_a(chunkcache, this.theEntity, entityIn, f);
        this.worldObj.theProfiler.endSection();
        return pathentity;
    }

    public boolean tryMoveToXYZ(double x, double y, double z, double speedIn) {
        PathEntity pathentity = this.getPathToXYZ(MathHelper.floor_double(x), (int)y, MathHelper.floor_double(z));
        return this.setPath(pathentity, speedIn);
    }

    public boolean tryMoveToEntityLiving(Entity entityIn, double speedIn) {
        PathEntity pathentity = this.getPathToEntityLiving(entityIn);
        return pathentity != null ? this.setPath(pathentity, speedIn) : false;
    }

    public boolean setPath(PathEntity pathentityIn, double speedIn) {
        if (pathentityIn == null) {
            this.currentPath = null;
            return false;
        }
        if (!pathentityIn.isSamePath(this.currentPath)) {
            this.currentPath = pathentityIn;
        }
        this.removeSunnyPath();
        if (this.currentPath.getCurrentPathLength() == 0) {
            return false;
        }
        this.speed = speedIn;
        Vec3d vec3d = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck = vec3d;
        return true;
    }

    public PathEntity getPath() {
        return this.currentPath;
    }

    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (this.field_188562_p) {
            this.func_188554_j();
        }
        if (!this.noPath()) {
            Vec3d vec3d2;
            if (this.canNavigate()) {
                this.pathFollow();
            } else if (this.currentPath != null && this.currentPath.getCurrentPathIndex() < this.currentPath.getCurrentPathLength()) {
                Vec3d vec3d = this.getEntityPosition();
                Vec3d vec3d1 = this.currentPath.getVectorFromIndex(this.theEntity, this.currentPath.getCurrentPathIndex());
                if (vec3d.yCoord > vec3d1.yCoord && !this.theEntity.onGround && MathHelper.floor_double(vec3d.xCoord) == MathHelper.floor_double(vec3d1.xCoord) && MathHelper.floor_double(vec3d.zCoord) == MathHelper.floor_double(vec3d1.zCoord)) {
                    this.currentPath.setCurrentPathIndex(this.currentPath.getCurrentPathIndex() + 1);
                }
            }
            if (!this.noPath() && (vec3d2 = this.currentPath.getPosition(this.theEntity)) != null) {
                BlockPos blockpos = new BlockPos(vec3d2).down();
                AxisAlignedBB axisalignedbb = this.worldObj.getBlockState(blockpos).func_185900_c(this.worldObj, blockpos);
                vec3d2 = vec3d2.subtract(0.0, 1.0 - axisalignedbb.maxY, 0.0);
                this.theEntity.getMoveHelper().setMoveTo(vec3d2.xCoord, vec3d2.yCoord, vec3d2.zCoord, this.speed);
            }
        }
    }

    protected void pathFollow() {
        Vec3d vec3d = this.getEntityPosition();
        int i = this.currentPath.getCurrentPathLength();
        int j = this.currentPath.getCurrentPathIndex();
        while (j < this.currentPath.getCurrentPathLength()) {
            if ((double)this.currentPath.getPathPointFromIndex((int)j).yCoord != Math.floor(vec3d.yCoord)) {
                i = j;
                break;
            }
            ++j;
        }
        this.field_188561_o = this.theEntity.width > 0.75f ? this.theEntity.width / 2.0f : 0.75f - this.theEntity.width / 2.0f;
        Vec3d vec3d1 = this.currentPath.func_186310_f();
        if (MathHelper.abs((float)(this.theEntity.posX - (vec3d1.xCoord + 0.5))) < this.field_188561_o && MathHelper.abs((float)(this.theEntity.posZ - (vec3d1.zCoord + 0.5))) < this.field_188561_o) {
            this.currentPath.setCurrentPathIndex(this.currentPath.getCurrentPathIndex() + 1);
        }
        int k = MathHelper.ceiling_float_int(this.theEntity.width);
        int l = (int)this.theEntity.height + 1;
        int i1 = k;
        int j1 = i - 1;
        while (j1 >= this.currentPath.getCurrentPathIndex()) {
            if (this.isDirectPathBetweenPoints(vec3d, this.currentPath.getVectorFromIndex(this.theEntity, j1), k, l, i1)) {
                this.currentPath.setCurrentPathIndex(j1);
                break;
            }
            --j1;
        }
        this.checkForStuck(vec3d);
    }

    protected void checkForStuck(Vec3d positionVec3) {
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (positionVec3.squareDistanceTo(this.lastPosCheck) < 2.25) {
                this.clearPathEntity();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck = positionVec3;
        }
        if (this.currentPath != null && !this.currentPath.isFinished()) {
            Vec3d vec3d = this.currentPath.func_186310_f();
            if (!vec3d.equals(this.field_188557_k)) {
                this.field_188557_k = vec3d;
                double d0 = positionVec3.distanceTo(this.field_188557_k);
                this.field_188560_n = this.theEntity.getAIMoveSpeed() > 0.0f ? d0 / (double)this.theEntity.getAIMoveSpeed() * 1000.0 : 0.0;
            } else {
                this.field_188558_l += System.currentTimeMillis() - this.field_188559_m;
            }
            if (this.field_188560_n > 0.0 && (double)this.field_188558_l > this.field_188560_n * 3.0) {
                this.field_188557_k = Vec3d.ZERO;
                this.field_188558_l = 0L;
                this.field_188560_n = 0.0;
                this.clearPathEntity();
            }
            this.field_188559_m = System.currentTimeMillis();
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.isFinished();
    }

    public void clearPathEntity() {
        this.currentPath = null;
    }

    protected abstract Vec3d getEntityPosition();

    protected abstract boolean canNavigate();

    protected boolean isInLiquid() {
        return this.theEntity.isInWater() || this.theEntity.isInLava();
    }

    protected void removeSunnyPath() {
    }

    protected abstract boolean isDirectPathBetweenPoints(Vec3d var1, Vec3d var2, int var3, int var4, int var5);

    public boolean func_188555_b(BlockPos p_188555_1_) {
        return this.worldObj.getBlockState(p_188555_1_.down()).isFullBlock();
    }
}

