/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.ComparisonChain;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PotionEffect
implements Comparable<PotionEffect> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Potion potion;
    private int duration;
    private int amplifier;
    private boolean isSplashPotion;
    private boolean isAmbient;
    private boolean isPotionDurationMax;
    private boolean field_188421_h;

    public PotionEffect(Potion p_i46811_1_) {
        this(p_i46811_1_, 0, 0);
    }

    public PotionEffect(Potion p_i46812_1_, int p_i46812_2_) {
        this(p_i46812_1_, p_i46812_2_, 0);
    }

    public PotionEffect(Potion p_i46813_1_, int p_i46813_2_, int p_i46813_3_) {
        this(p_i46813_1_, p_i46813_2_, p_i46813_3_, false, true);
    }

    public PotionEffect(Potion p_i46814_1_, int p_i46814_2_, int p_i46814_3_, boolean p_i46814_4_, boolean p_i46814_5_) {
        this.potion = p_i46814_1_;
        this.duration = p_i46814_2_;
        this.amplifier = p_i46814_3_;
        this.isAmbient = p_i46814_4_;
        this.field_188421_h = p_i46814_5_;
    }

    public PotionEffect(PotionEffect other) {
        this.potion = other.potion;
        this.duration = other.duration;
        this.amplifier = other.amplifier;
        this.isAmbient = other.isAmbient;
        this.field_188421_h = other.field_188421_h;
    }

    public void combine(PotionEffect other) {
        if (this.potion != other.potion) {
            LOGGER.warn("This method should only be called for matching effects!");
        }
        if (other.amplifier > this.amplifier) {
            this.amplifier = other.amplifier;
            this.duration = other.duration;
        } else if (other.amplifier == this.amplifier && this.duration < other.duration) {
            this.duration = other.duration;
        } else if (!other.isAmbient && this.isAmbient) {
            this.isAmbient = other.isAmbient;
        }
        this.field_188421_h = other.field_188421_h;
    }

    public Potion getPotion() {
        return this.potion;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean getIsAmbient() {
        return this.isAmbient;
    }

    public boolean func_188418_e() {
        return this.field_188421_h;
    }

    public boolean onUpdate(EntityLivingBase entityIn) {
        if (this.duration > 0) {
            if (this.potion.isReady(this.duration, this.amplifier)) {
                this.performEffect(entityIn);
            }
            this.deincrementDuration();
        }
        return this.duration > 0;
    }

    private int deincrementDuration() {
        return --this.duration;
    }

    public void performEffect(EntityLivingBase entityIn) {
        if (this.duration > 0) {
            this.potion.performEffect(entityIn, this.amplifier);
        }
    }

    public String getEffectName() {
        return this.potion.getName();
    }

    public String toString() {
        String s = "";
        s = this.amplifier > 0 ? String.valueOf(this.getEffectName()) + " x " + (this.amplifier + 1) + ", Duration: " + this.duration : String.valueOf(this.getEffectName()) + ", Duration: " + this.duration;
        if (this.isSplashPotion) {
            s = String.valueOf(s) + ", Splash: true";
        }
        if (!this.field_188421_h) {
            s = String.valueOf(s) + ", Particles: false";
        }
        return s;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof PotionEffect)) {
            return false;
        }
        PotionEffect potioneffect = (PotionEffect)p_equals_1_;
        return this.duration == potioneffect.duration && this.amplifier == potioneffect.amplifier && this.isSplashPotion == potioneffect.isSplashPotion && this.isAmbient == potioneffect.isAmbient && this.potion.equals(potioneffect.potion);
    }

    public int hashCode() {
        int i = this.potion.hashCode();
        i = 31 * i + this.duration;
        i = 31 * i + this.amplifier;
        i = 31 * i + (this.isSplashPotion ? 1 : 0);
        i = 31 * i + (this.isAmbient ? 1 : 0);
        return i;
    }

    public NBTTagCompound writeCustomPotionEffectToNBT(NBTTagCompound nbt) {
        nbt.setByte("Id", (byte)Potion.getIdFromPotion(this.getPotion()));
        nbt.setByte("Amplifier", (byte)this.getAmplifier());
        nbt.setInteger("Duration", this.getDuration());
        nbt.setBoolean("Ambient", this.getIsAmbient());
        nbt.setBoolean("ShowParticles", this.func_188418_e());
        return nbt;
    }

    public static PotionEffect readCustomPotionEffectFromNBT(NBTTagCompound nbt) {
        byte i = nbt.getByte("Id");
        Potion potion = Potion.getPotionById(i);
        if (potion == null) {
            return null;
        }
        byte j = nbt.getByte("Amplifier");
        int k = nbt.getInteger("Duration");
        boolean flag = nbt.getBoolean("Ambient");
        boolean flag1 = true;
        if (nbt.hasKey("ShowParticles", 1)) {
            flag1 = nbt.getBoolean("ShowParticles");
        }
        return new PotionEffect(potion, k, j, flag, flag1);
    }

    public void setPotionDurationMax(boolean maxDuration) {
        this.isPotionDurationMax = maxDuration;
    }

    public boolean getIsPotionDurationMax() {
        return this.isPotionDurationMax;
    }

    @Override
    public int compareTo(PotionEffect p_compareTo_1_) {
        int i = 32147;
        return !(this.getDuration() > 32147 && p_compareTo_1_.getDuration() > 32147 || this.getIsAmbient() && p_compareTo_1_.getIsAmbient()) ? ComparisonChain.start().compare((Comparable)Boolean.valueOf(this.getIsAmbient()), (Comparable)Boolean.valueOf(p_compareTo_1_.getIsAmbient())).compare(this.getDuration(), p_compareTo_1_.getDuration()).compare(this.getPotion().getLiquidColor(), p_compareTo_1_.getPotion().getLiquidColor()).result() : ComparisonChain.start().compare((Comparable)Boolean.valueOf(this.getIsAmbient()), (Comparable)Boolean.valueOf(p_compareTo_1_.getIsAmbient())).compare(this.getPotion().getLiquidColor(), p_compareTo_1_.getPotion().getLiquidColor()).result();
    }
}

