/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateSign;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;

public class TileEntitySign
extends TileEntity {
    public ITextComponent[] signText = new ITextComponent[]{new TextComponentString(""), new TextComponentString(""), new TextComponentString(""), new TextComponentString("")};
    public int lineBeingEdited = -1;
    private boolean isEditable = true;
    private EntityPlayer player;
    private final CommandResultStats stats = new CommandResultStats();

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        int i = 0;
        while (i < 4) {
            String s = ITextComponent.Serializer.componentToJson(this.signText[i]);
            compound.setString("Text" + (i + 1), s);
            ++i;
        }
        this.stats.writeStatsToNBT(compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.isEditable = false;
        super.readFromNBT(compound);
        ICommandSender icommandsender = new ICommandSender(){

            @Override
            public String getName() {
                return "Sign";
            }

            @Override
            public ITextComponent getDisplayName() {
                return new TextComponentString(this.getName());
            }

            @Override
            public void addChatMessage(ITextComponent component) {
            }

            @Override
            public boolean canCommandSenderUseCommand(int permLevel, String commandName) {
                return true;
            }

            @Override
            public BlockPos getPosition() {
                return TileEntitySign.this.pos;
            }

            @Override
            public Vec3d getPositionVector() {
                return new Vec3d((double)TileEntitySign.this.pos.getX() + 0.5, (double)TileEntitySign.this.pos.getY() + 0.5, (double)TileEntitySign.this.pos.getZ() + 0.5);
            }

            @Override
            public World getEntityWorld() {
                return TileEntitySign.this.worldObj;
            }

            @Override
            public Entity getCommandSenderEntity() {
                return null;
            }

            @Override
            public boolean sendCommandFeedback() {
                return false;
            }

            @Override
            public void setCommandStat(CommandResultStats.Type type, int amount) {
            }

            @Override
            public MinecraftServer getServer() {
                return TileEntitySign.this.worldObj.getMinecraftServer();
            }
        };
        int i = 0;
        while (i < 4) {
            String s = compound.getString("Text" + (i + 1));
            ITextComponent itextcomponent = ITextComponent.Serializer.jsonToComponent(s);
            try {
                this.signText[i] = TextComponentUtils.processComponent(icommandsender, itextcomponent, null);
            }
            catch (CommandException var7) {
                this.signText[i] = itextcomponent;
            }
            ++i;
        }
        this.stats.readStatsFromNBT(compound);
    }

    @Override
    public Packet<?> getDescriptionPacket() {
        ITextComponent[] aitextcomponent = new ITextComponent[4];
        System.arraycopy(this.signText, 0, aitextcomponent, 0, 4);
        return new SPacketUpdateSign(this.worldObj, this.pos, aitextcomponent);
    }

    @Override
    public boolean func_183000_F() {
        return true;
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditableIn) {
        this.isEditable = isEditableIn;
        if (!isEditableIn) {
            this.player = null;
        }
    }

    public void setPlayer(EntityPlayer playerIn) {
        this.player = playerIn;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean executeCommand(final EntityPlayer playerIn) {
        ICommandSender icommandsender = new ICommandSender(){

            @Override
            public String getName() {
                return playerIn.getName();
            }

            @Override
            public ITextComponent getDisplayName() {
                return playerIn.getDisplayName();
            }

            @Override
            public void addChatMessage(ITextComponent component) {
            }

            @Override
            public boolean canCommandSenderUseCommand(int permLevel, String commandName) {
                return permLevel <= 2;
            }

            @Override
            public BlockPos getPosition() {
                return TileEntitySign.this.pos;
            }

            @Override
            public Vec3d getPositionVector() {
                return new Vec3d((double)TileEntitySign.this.pos.getX() + 0.5, (double)TileEntitySign.this.pos.getY() + 0.5, (double)TileEntitySign.this.pos.getZ() + 0.5);
            }

            @Override
            public World getEntityWorld() {
                return playerIn.getEntityWorld();
            }

            @Override
            public Entity getCommandSenderEntity() {
                return playerIn;
            }

            @Override
            public boolean sendCommandFeedback() {
                return false;
            }

            @Override
            public void setCommandStat(CommandResultStats.Type type, int amount) {
                if (TileEntitySign.this.worldObj != null && !TileEntitySign.this.worldObj.isRemote) {
                    TileEntitySign.this.stats.func_184932_a(TileEntitySign.this.worldObj.getMinecraftServer(), this, type, amount);
                }
            }

            @Override
            public MinecraftServer getServer() {
                return playerIn.getServer();
            }
        };
        int i = 0;
        while (i < this.signText.length) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = this.signText[i] == null ? null : this.signText[i].getChatStyle();
            if (style != null && style.getChatClickEvent() != null && (clickevent = style.getChatClickEvent()).getAction() == ClickEvent.Action.RUN_COMMAND) {
                playerIn.getServer().getCommandManager().executeCommand(icommandsender, clickevent.getValue());
            }
            ++i;
        }
        return true;
    }

    public CommandResultStats getStats() {
        return this.stats;
    }
}

