/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeColorHelper {
    private static final ColorResolver GRASS_COLOR = new ColorResolver(){

        @Override
        public int getColorAtPos(BiomeGenBase biome, BlockPos blockPosition) {
            return biome.getGrassColorAtPos(blockPosition);
        }
    };
    private static final ColorResolver FOLIAGE_COLOR = new ColorResolver(){

        @Override
        public int getColorAtPos(BiomeGenBase biome, BlockPos blockPosition) {
            return biome.getFoliageColorAtPos(blockPosition);
        }
    };
    private static final ColorResolver WATER_COLOR = new ColorResolver(){

        @Override
        public int getColorAtPos(BiomeGenBase biome, BlockPos blockPosition) {
            return biome.getWaterColor();
        }
    };

    private static int getColorAtPos(IBlockAccess blockAccess, BlockPos pos, ColorResolver colorResolver) {
        int i = 0;
        int j = 0;
        int k = 0;
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.getAllInBoxMutable(pos.add(-1, 0, -1), pos.add(1, 0, 1))) {
            int l = colorResolver.getColorAtPos(blockAccess.getBiomeGenForCoords(blockpos$mutableblockpos), blockpos$mutableblockpos);
            i += (l & 0xFF0000) >> 16;
            j += (l & 0xFF00) >> 8;
            k += l & 0xFF;
        }
        return (i / 9 & 0xFF) << 16 | (j / 9 & 0xFF) << 8 | k / 9 & 0xFF;
    }

    public static int getGrassColorAtPos(IBlockAccess p_180286_0_, BlockPos p_180286_1_) {
        return BiomeColorHelper.getColorAtPos(p_180286_0_, p_180286_1_, GRASS_COLOR);
    }

    public static int getFoliageColorAtPos(IBlockAccess p_180287_0_, BlockPos p_180287_1_) {
        return BiomeColorHelper.getColorAtPos(p_180287_0_, p_180287_1_, FOLIAGE_COLOR);
    }

    public static int getWaterColorAtPos(IBlockAccess p_180288_0_, BlockPos p_180288_1_) {
        return BiomeColorHelper.getColorAtPos(p_180288_0_, p_180288_1_, WATER_COLOR);
    }

    static interface ColorResolver {
        public int getColorAtPos(BiomeGenBase var1, BlockPos var2);
    }
}

