/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.wurst;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import org.darkstorm.minecraft.gui.component.Component;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.layout.Constraint;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import org.darkstorm.minecraft.gui.util.GuiManagerDisplayScreen;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.opengl.GL11;

public class WurstFrameUI
extends AbstractComponentUI<Frame> {
    private final WurstTheme theme;

    WurstFrameUI(WurstTheme theme) {
        super(Frame.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(64, 64, 64, 128);
    }

    @Override
    protected void renderComponent(Frame component) {
        this.translateComponent(component, false);
        int fontHeight = this.theme.getFontRenderer().FONT_HEIGHT;
        Rectangle area = new Rectangle(component.getArea());
        if (component.isMinimized()) {
            area.height = fontHeight + 4;
        }
        Point mouse = RenderUtil.calculateMouseLocation();
        Container parent = component;
        while (parent != null) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
            parent = parent.getParent();
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        GL11.glColor4f((float)0.03125f, (float)0.03125f, (float)0.03125f, (float)0.5f);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)(fontHeight + 4));
        GL11.glVertex2d((double)0.0, (double)(fontHeight + 4));
        GL11.glEnd();
        RenderUtil.setColor(this.background);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)(fontHeight + 4));
        GL11.glVertex2d((double)area.width, (double)(fontHeight + 4));
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        RenderUtil.boxShadow(0.0, 0.0, area.width, area.height);
        int offset = component.getWidth() - 2;
        boolean[] checks = new boolean[]{component.isClosable(), component.isPinnable(), component.isMinimizable()};
        boolean[] overlays = new boolean[]{component.isClosable(), !component.isPinned(), component.isMinimized()};
        int i = 0;
        while (i < checks.length) {
            if (checks[i]) {
                boolean hovering = mouse.x >= offset - fontHeight && mouse.x <= offset && mouse.y >= 2 && mouse.y <= fontHeight + 2 && Minecraft.getMinecraft().currentScreen instanceof GuiManagerDisplayScreen;
                Color green = new Color(0.0f, 1.0f, 0.0f, hovering ? 0.5f : 0.375f);
                Color red = new Color(1.0f, 0.0f, 0.0f, hovering ? 0.5f : 0.375f);
                Color silver = new Color(1.0f, 1.0f, 1.0f, hovering ? 0.5f : 0.375f);
                Color shadow = new Color(0.125f, 0.125f, 0.125f, hovering ? 0.75f : 0.5f);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f);
                GL11.glBegin((int)7);
                GL11.glVertex2d((double)(offset - fontHeight), (double)2.0);
                GL11.glVertex2d((double)offset, (double)2.0);
                GL11.glVertex2d((double)offset, (double)(fontHeight + 2));
                GL11.glVertex2d((double)(offset - fontHeight), (double)(fontHeight + 2));
                GL11.glEnd();
                RenderUtil.boxShadow(offset - fontHeight, 2.0, offset, fontHeight + 2);
                if (i == 1 && overlays[i]) {
                    RenderUtil.setColor(green);
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)(offset - fontHeight / 3), (double)2.0);
                    GL11.glVertex2d((double)offset, (double)(fontHeight / 3 + 2));
                    GL11.glVertex2d((double)(offset - fontHeight / 3), (double)(fontHeight / 3 * 2 + 2));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2), (double)(fontHeight / 3 + 2));
                    GL11.glEnd();
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2 - 1), (double)(fontHeight / 3 + 1));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 + 1), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glVertex2d((double)(offset - fontHeight / 3), (double)(fontHeight / 3 * 2 + 4));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2 - 2), (double)(fontHeight / 3 + 2));
                    GL11.glEnd();
                    RenderUtil.setColor(silver);
                    GL11.glBegin((int)4);
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2), (double)(fontHeight / 3 + 4));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 - 2), (double)(fontHeight / 3 * 2 + 2));
                    GL11.glVertex2d((double)((double)(offset - fontHeight) + 1.5), (double)((double)fontHeight + 0.5));
                    GL11.glEnd();
                    GL11.glLineWidth((float)1.0f);
                    RenderUtil.setColor(shadow);
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)(offset - fontHeight / 3), (double)2.0);
                    GL11.glVertex2d((double)offset, (double)(fontHeight / 3 + 2));
                    GL11.glVertex2d((double)(offset - fontHeight / 3), (double)(fontHeight / 3 * 2 + 2));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2), (double)(fontHeight / 3 + 2));
                    GL11.glEnd();
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2 - 1), (double)(fontHeight / 3 + 1));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 + 1), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glVertex2d((double)(offset - fontHeight / 3), (double)(fontHeight / 3 * 2 + 4));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2 - 2), (double)(fontHeight / 3 + 2));
                    GL11.glEnd();
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2), (double)(fontHeight / 3 + 4));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 - 2), (double)(fontHeight / 3 * 2 + 2));
                    GL11.glVertex2d((double)((double)(offset - fontHeight) + 1.5), (double)((double)fontHeight + 0.5));
                    GL11.glEnd();
                } else if (i == 1) {
                    RenderUtil.setColor(red);
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) - 1.5), (double)(fontHeight / 3 + 1));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3) + 0.5), (double)(fontHeight / 3 + 1));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3) + 0.5), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) - 1.5), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glEnd();
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) - 2.5), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3) + 1.5), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3) + 1.5), (double)((double)(fontHeight / 3 * 2) + 4.5));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) - 2.5), (double)((double)(fontHeight / 3 * 2) + 4.5));
                    GL11.glEnd();
                    RenderUtil.setColor(silver);
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2), (double)((double)(fontHeight / 3 * 2) + 4.5));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) + 1.5), (double)((double)(fontHeight / 3 * 2) + 4.5));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) + 1.5), (double)(fontHeight + 2));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2), (double)(fontHeight + 2));
                    GL11.glEnd();
                    GL11.glLineWidth((float)1.0f);
                    RenderUtil.setColor(shadow);
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) - 1.5), (double)(fontHeight / 3 + 1));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3) + 0.5), (double)(fontHeight / 3 + 1));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3) + 0.5), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) - 1.5), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glEnd();
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) - 2.5), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3) + 1.5), (double)(fontHeight / 3 * 2 + 3));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3) + 1.5), (double)((double)(fontHeight / 3 * 2) + 4.5));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) - 2.5), (double)((double)(fontHeight / 3 * 2) + 4.5));
                    GL11.glEnd();
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2), (double)((double)(fontHeight / 3 * 2) + 4.5));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) + 1.5), (double)((double)(fontHeight / 3 * 2) + 4.5));
                    GL11.glVertex2d((double)((double)(offset - fontHeight / 3 * 2) + 1.5), (double)(fontHeight + 2));
                    GL11.glVertex2d((double)(offset - fontHeight / 3 * 2), (double)(fontHeight + 2));
                    GL11.glEnd();
                }
                if (i == 2 && overlays[i]) {
                    RenderUtil.setColor(green);
                    GL11.glBegin((int)4);
                    GL11.glVertex2d((double)(offset - fontHeight + 1), (double)4.5);
                    GL11.glVertex2d((double)(offset - 1), (double)4.5);
                    GL11.glVertex2d((double)(offset - fontHeight / 2), (double)((double)fontHeight - 0.5));
                    GL11.glEnd();
                    GL11.glLineWidth((float)1.0f);
                    RenderUtil.setColor(shadow);
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)(offset - fontHeight + 1), (double)4.5);
                    GL11.glVertex2d((double)(offset - 1), (double)4.5);
                    GL11.glVertex2d((double)(offset - fontHeight / 2), (double)((double)fontHeight - 0.5));
                    GL11.glEnd();
                } else if (i == 2) {
                    RenderUtil.setColor(red);
                    GL11.glBegin((int)4);
                    GL11.glVertex2d((double)(offset - fontHeight + 1), (double)(fontHeight - 1));
                    GL11.glVertex2d((double)(offset - 1), (double)(fontHeight - 1));
                    GL11.glVertex2d((double)(offset - fontHeight / 2), (double)4.0);
                    GL11.glEnd();
                    GL11.glLineWidth((float)1.0f);
                    RenderUtil.setColor(shadow);
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)(offset - fontHeight + 1), (double)(fontHeight - 1));
                    GL11.glVertex2d((double)(offset - 1), (double)(fontHeight - 1));
                    GL11.glVertex2d((double)(offset - fontHeight / 2), (double)4.0);
                    GL11.glEnd();
                }
                if (i == 0) {
                    RenderUtil.setColor(red);
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)(offset - fontHeight + 2), (double)5.0);
                    GL11.glVertex2d((double)(offset - fontHeight + 3), (double)4.0);
                    GL11.glVertex2d((double)(offset - 2), (double)(fontHeight - 1));
                    GL11.glVertex2d((double)(offset - 3), (double)fontHeight);
                    GL11.glEnd();
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)(offset - 2), (double)5.0);
                    GL11.glVertex2d((double)(offset - 3), (double)4.0);
                    GL11.glVertex2d((double)(offset - fontHeight / 2), (double)(fontHeight / 2 + 1));
                    GL11.glVertex2d((double)(offset - fontHeight / 2 + 1), (double)(fontHeight / 2 + 2));
                    GL11.glEnd();
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)(offset - fontHeight / 2), (double)(fontHeight / 2 + 3));
                    GL11.glVertex2d((double)(offset - fontHeight / 2 - 1), (double)(fontHeight / 2 + 2));
                    GL11.glVertex2d((double)(offset - fontHeight + 2), (double)(fontHeight - 1));
                    GL11.glVertex2d((double)(offset - fontHeight + 3), (double)fontHeight);
                    GL11.glEnd();
                    GL11.glLineWidth((float)1.0f);
                    RenderUtil.setColor(shadow);
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)(offset - fontHeight + 2), (double)5.0);
                    GL11.glVertex2d((double)(offset - fontHeight + 3), (double)4.0);
                    GL11.glVertex2d((double)(offset - fontHeight / 2), (double)(fontHeight / 2 + 1));
                    GL11.glVertex2d((double)(offset - 3), (double)4.0);
                    GL11.glVertex2d((double)(offset - 2), (double)5.0);
                    GL11.glVertex2d((double)(offset - fontHeight / 2 + 1), (double)(fontHeight / 2 + 2));
                    GL11.glVertex2d((double)(offset - 2), (double)(fontHeight - 1));
                    GL11.glVertex2d((double)(offset - 3), (double)fontHeight);
                    GL11.glVertex2d((double)(offset - fontHeight / 2), (double)(fontHeight / 2 + 3));
                    GL11.glVertex2d((double)(offset - fontHeight + 3), (double)fontHeight);
                    GL11.glVertex2d((double)(offset - fontHeight + 2), (double)(fontHeight - 1));
                    GL11.glVertex2d((double)(offset - fontHeight / 2 - 1), (double)(fontHeight / 2 + 2));
                    GL11.glEnd();
                }
                offset -= fontHeight + 2;
            }
            ++i;
        }
        if (!component.isMinimized()) {
            RenderUtil.downShadow(0.0, fontHeight + 4, area.width, fontHeight + 5);
        }
        GL11.glEnable((int)3553);
        this.theme.getFontRenderer().drawStringWithShadow(component.getTitle(), 2.0f, 1.0f, RenderUtil.toRGBA(component.getForegroundColor()));
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        this.translateComponent(component, true);
    }

    @Override
    protected Rectangle getContainerChildRenderArea(Frame container) {
        Rectangle area = new Rectangle(container.getArea());
        area.x = 2;
        area.y = this.theme.getFontRenderer().FONT_HEIGHT + 6;
        area.width -= 4;
        area.height -= this.theme.getFontRenderer().FONT_HEIGHT + 8;
        return area;
    }

    @Override
    protected Dimension getDefaultComponentSize(Frame component) {
        Component[] children = component.getChildren();
        Rectangle[] areas = new Rectangle[children.length];
        Constraint[][] constraints = new Constraint[children.length][];
        int i = 0;
        while (i < children.length) {
            Component child = children[i];
            Dimension size = child.getTheme().getUIForComponent(child).getDefaultSize(child);
            areas[i] = new Rectangle(0, 0, size.width, size.height);
            constraints[i] = component.getConstraints(child);
            ++i;
        }
        Dimension size = component.getLayoutManager().getOptimalPositionedSize(areas, constraints);
        size.width += 4;
        size.height += this.theme.getFontRenderer().FONT_HEIGHT + 8;
        return size;
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(Frame component) {
        return new Rectangle[]{new Rectangle(0, 0, component.getWidth(), this.theme.getFontRenderer().FONT_HEIGHT + 4)};
    }

    @Override
    protected void handleComponentInteraction(Frame component, Point location, int button) {
        if (button != 0) {
            return;
        }
        int offset = component.getWidth() - 2;
        int textHeight = this.theme.getFontRenderer().FONT_HEIGHT;
        if (component.isClosable()) {
            if (location.x >= offset - textHeight && location.x <= offset && location.y >= 2 && location.y <= textHeight + 2) {
                component.close();
                return;
            }
            offset -= textHeight + 2;
        }
        if (component.isPinnable()) {
            if (location.x >= offset - textHeight && location.x <= offset && location.y >= 2 && location.y <= textHeight + 2) {
                component.setPinned(!component.isPinned());
                return;
            }
            offset -= textHeight + 2;
        }
        if (component.isMinimizable()) {
            if (location.x >= offset - textHeight && location.x <= offset && location.y >= 2 && location.y <= textHeight + 2) {
                component.setMinimized(!component.isMinimized());
                return;
            }
            offset -= textHeight + 2;
        }
        if (location.x >= 0 && location.x <= offset && location.y >= 0 && location.y <= textHeight + 4) {
            component.setDragging(true);
            return;
        }
    }
}

