/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import tk.wurst_client.commands.Cmd;

@Cmd.Info(help="Allows you to copy items that other people are holding\nor wearing. Requires creative mode.", name="copyitem", syntax={"<player> (hand|head|chest|legs|feet)"})
public class CopyItemCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length != 2) {
            this.syntaxError();
        }
        if (!CopyItemCmd.mc.thePlayer.capabilities.isCreativeMode) {
            this.error("Creative mode only.");
        }
        ItemStack item = null;
        for (Object entity : CopyItemCmd.mc.theWorld.loadedEntityList) {
            EntityOtherPlayerMP player;
            if (!(entity instanceof EntityOtherPlayerMP) || !(player = (EntityOtherPlayerMP)entity).getName().equalsIgnoreCase(args[0])) continue;
            switch (args[1].toLowerCase()) {
                case "hand": {
                    item = player.inventory.getCurrentItem();
                    break;
                }
                case "head": {
                    item = player.inventory.armorItemInSlot(3);
                    break;
                }
                case "chest": {
                    item = player.inventory.armorItemInSlot(2);
                    break;
                }
                case "legs": {
                    item = player.inventory.armorItemInSlot(1);
                    break;
                }
                case "feet": {
                    item = player.inventory.armorItemInSlot(0);
                    break;
                }
                default: {
                    this.syntaxError();
                    break;
                }
            }
            break;
        }
        if (item == null) {
            this.error("Player \"" + args[0] + "\" could not be found.");
        }
        int i = 0;
        while (i < 9) {
            if (CopyItemCmd.mc.thePlayer.inventory.getStackInSlot(i) == null) {
                CopyItemCmd.mc.thePlayer.sendQueue.addToSendQueue(new CPacketCreativeInventoryAction(36 + i, item));
                CopyItemCmd.wurst.chat.message("Item copied.");
                return;
            }
            ++i;
        }
        this.error("Please clear a slot in your hotbar.");
    }
}

