/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.ChatOutputEvent;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.special.Spf;

@Cmd.Info(help="Shows the feature count and some over statistics.", name="features", syntax={})
public class FeaturesCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length != 0) {
            this.syntaxError();
        }
        FeaturesCmd.wurst.chat.message("> All features: " + FeaturesCmd.wurst.navigator.countAllFeatures());
        FeaturesCmd.wurst.chat.message("> Mods: " + FeaturesCmd.wurst.mods.countMods());
        FeaturesCmd.wurst.chat.message("> Commands: " + FeaturesCmd.wurst.commands.countCommands());
        FeaturesCmd.wurst.chat.message("> Special features: " + FeaturesCmd.wurst.special.countFeatures());
        int settings = 0;
        int bypasses = 0;
        for (Mod mod : FeaturesCmd.wurst.mods.getAllMods()) {
            settings += mod.getSettings().size();
            if (!mod.getClass().getAnnotation(Mod.Info.class).noCheatCompatible()) continue;
            ++bypasses;
        }
        FeaturesCmd.wurst.chat.message("> NoCheat bypasses (mods only): " + bypasses);
        for (Cmd cmd : FeaturesCmd.wurst.commands.getAllCommands()) {
            settings += cmd.getSettings().size();
        }
        for (Spf spf : FeaturesCmd.wurst.special.getAllFeatures()) {
            settings += spf.getSettings().size();
        }
        FeaturesCmd.wurst.chat.message("> Settings: " + settings);
    }

    @Override
    public String getPrimaryAction() {
        return "Show Statistics";
    }

    @Override
    public void doPrimaryAction() {
        FeaturesCmd.wurst.commands.onSentMessage(new ChatOutputEvent(".features", true));
    }
}

