/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.ChatOutputEvent;
import tk.wurst_client.hooks.ServerHook;

@Cmd.Info(help="Shows the IP of the server you are currently playing on or copies it to the clipboard.", name="ip", syntax={"[copy]"})
public class IpCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length == 0) {
            IpCmd.wurst.chat.message("IP: " + ServerHook.getCurrentServerIP());
        } else if (args[0].toLowerCase().equals("copy")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ServerHook.getCurrentServerIP()), null);
            IpCmd.wurst.chat.message("IP copied to clipboard.");
        } else {
            this.syntaxError();
        }
    }

    @Override
    public String getPrimaryAction() {
        return "Get IP";
    }

    @Override
    public void doPrimaryAction() {
        IpCmd.wurst.commands.onSentMessage(new ChatOutputEvent(".ip", true));
    }
}

