/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.List;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(help="Changes the effects of the held potion.", name="potion", syntax={"add (<effect> <amplifier> <duration>)...", "set (<effect> <amplifier> <duration>)...", "remove <effect>"})
public class PotionCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        ItemStack currentItem;
        if (args.length == 0) {
            this.syntaxError();
        }
        if (!PotionCmd.mc.thePlayer.capabilities.isCreativeMode) {
            this.error("Creative mode only.");
        }
        if ((currentItem = PotionCmd.mc.thePlayer.inventory.getCurrentItem()) == null || !(currentItem.getItem() instanceof ItemPotion) && !(currentItem.getItem() instanceof ItemSplashPotion)) {
            this.error("You are not holding a potion in your hand.");
        }
        NBTTagList newEffects = new NBTTagList();
        if (args[0].equalsIgnoreCase("remove")) {
            if (args.length != 2) {
                this.syntaxError();
            }
            int id = 0;
            id = this.parsePotionEffectId(args[1]);
            List<PotionEffect> oldEffects = PotionUtils.getEffectsFromStack(currentItem);
            if (oldEffects != null) {
                int i = 0;
                while (i < oldEffects.size()) {
                    PotionEffect temp = oldEffects.get(i);
                    if (Potion.getIdFromPotion(temp.getPotion()) != id) {
                        NBTTagCompound effect = new NBTTagCompound();
                        effect.setInteger("Id", Potion.getIdFromPotion(temp.getPotion()));
                        effect.setInteger("Amplifier", temp.getAmplifier());
                        effect.setInteger("Duration", temp.getDuration());
                        newEffects.appendTag(effect);
                    }
                    ++i;
                }
            }
            currentItem.setTagInfo("CustomPotionEffects", newEffects);
            return;
        }
        if ((args.length - 1) % 3 != 0) {
            this.syntaxError();
        }
        if (args[0].equalsIgnoreCase("add")) {
            List<PotionEffect> oldEffects = PotionUtils.getEffectsFromStack(currentItem);
            if (oldEffects != null) {
                int i = 0;
                while (i < oldEffects.size()) {
                    PotionEffect temp = oldEffects.get(i);
                    NBTTagCompound effect = new NBTTagCompound();
                    effect.setInteger("Id", Potion.getIdFromPotion(temp.getPotion()));
                    effect.setInteger("Amplifier", temp.getAmplifier());
                    effect.setInteger("Duration", temp.getDuration());
                    newEffects.appendTag(effect);
                    ++i;
                }
            }
        } else if (!args[0].equalsIgnoreCase("set")) {
            this.syntaxError();
        }
        int i = 0;
        while (i < (args.length - 1) / 3) {
            int id = this.parsePotionEffectId(args[1 + i * 3]);
            int amplifier = 0;
            int duration = 0;
            if (MiscUtils.isInteger(args[2 + i * 3]) && MiscUtils.isInteger(args[3 + i * 3])) {
                amplifier = Integer.parseInt(args[2 + i * 3]) - 1;
                duration = Integer.parseInt(args[3 + i * 3]);
            } else {
                this.syntaxError();
            }
            NBTTagCompound effect = new NBTTagCompound();
            effect.setInteger("Id", id);
            effect.setInteger("Amplifier", amplifier);
            effect.setInteger("Duration", duration * 20);
            newEffects.appendTag(effect);
            ++i;
        }
        System.out.println(newEffects);
        currentItem.setTagInfo("CustomPotionEffects", newEffects);
    }

    public int parsePotionEffectId(String input) throws Cmd.SyntaxError {
        int id = 0;
        try {
            id = Integer.parseInt(input);
        }
        catch (NumberFormatException var11) {
            try {
                id = Potion.getIdFromPotion(Potion.getPotionFromResourceLocation(input));
            }
            catch (NullPointerException e) {
                this.syntaxError();
            }
        }
        if (id < 1) {
            this.syntaxError();
        }
        return id;
    }
}

