/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.ChatOutputEvent;

@Cmd.Info(help="Repairs the held item. Requires creative mode.", name="repair", syntax={})
public class RepairCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        ItemStack item;
        if (args.length > 0) {
            this.syntaxError();
        }
        EntityPlayerSP player = RepairCmd.mc.thePlayer;
        if (!player.capabilities.isCreativeMode) {
            this.error("Creative mode only.");
        }
        if ((item = player.inventory.getCurrentItem()) == null) {
            this.error("You need an item in your hand.");
        }
        if (!item.isItemStackDamageable()) {
            this.error("This item can't take damage.");
        }
        if (!item.isItemDamaged()) {
            this.error("This item is not damaged.");
        }
        item.setItemDamage(0);
        player.sendQueue.addToSendQueue(new CPacketCreativeInventoryAction(36 + player.inventory.currentItem, item));
    }

    @Override
    public String getPrimaryAction() {
        return "Repair Current Item";
    }

    @Override
    public void doPrimaryAction() {
        RepairCmd.wurst.commands.onSentMessage(new ChatOutputEvent(".repair", true));
    }
}

