/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.block.Block;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(help="Changes the settings of Search or toggles it.", name="search", syntax={"id <block_id>", "name <block_name>"})
public class SearchCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length == 0) {
            SearchCmd.wurst.mods.searchMod.toggle();
            SearchCmd.wurst.chat.message("Search turned " + (SearchCmd.wurst.mods.searchMod.isEnabled() ? "on" : "off") + ".");
        } else if (args.length == 2) {
            if (args[0].toLowerCase().equals("id")) {
                if (MiscUtils.isInteger(args[1])) {
                    SearchCmd.wurst.options.searchID = Integer.valueOf(args[1]);
                } else {
                    this.syntaxError("ID must be a number.");
                }
                SearchCmd.wurst.files.saveOptions();
                SearchCmd.wurst.mods.searchMod.notify = true;
                SearchCmd.wurst.chat.message("Search ID set to " + args[1] + ".");
            } else if (args[0].equalsIgnoreCase("name")) {
                int newID = Block.getIdFromBlock(Block.getBlockFromName(args[1]));
                if (newID == -1) {
                    this.error("Block \"" + args[1] + "\" could not be found.");
                }
                SearchCmd.wurst.options.searchID = newID;
                SearchCmd.wurst.files.saveOptions();
                SearchCmd.wurst.mods.searchMod.notify = true;
                SearchCmd.wurst.chat.message("Search ID set to " + newID + " (" + args[1] + ").");
            }
        } else {
            this.syntaxError();
        }
    }
}

