/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.mods.XRayMod;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(help="Manages or toggles X-Ray.", name="xray", syntax={"add (id <block_id>|name <block_name>)", "remove (id <block_id>|name <block_name>)", "list [<page>]"})
public class XRayCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length == 0) {
            this.syntaxError();
        } else if (args[0].equalsIgnoreCase("list")) {
            if (args.length == 1) {
                this.execute(new String[]{"list", "1"});
                return;
            }
            int pages = (int)Math.ceil((double)XRayMod.xrayBlocks.size() / 8.0);
            if (MiscUtils.isInteger(args[1])) {
                int page = Integer.valueOf(args[1]);
                if (page > pages || page < 1) {
                    this.syntaxError("Invalid page: " + page);
                }
                XRayCmd.wurst.chat.message("Current X-Ray blocks: " + XRayMod.xrayBlocks.size());
                XRayCmd.wurst.chat.message("X-Ray blocks list (page " + page + "/" + pages + "):");
                Iterator<Block> itr = XRayMod.xrayBlocks.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    Block block = itr.next();
                    if (i >= (page - 1) * 8 && i < (page - 1) * 8 + 8) {
                        XRayCmd.wurst.chat.message(new ItemStack(Item.getItemFromBlock(block)).getDisplayName());
                    }
                    ++i;
                }
            } else {
                this.syntaxError();
            }
        } else if (args.length < 2) {
            this.syntaxError();
        } else if (args[0].equalsIgnoreCase("add")) {
            if (args[1].equalsIgnoreCase("id") && MiscUtils.isInteger(args[2])) {
                if (XRayMod.xrayBlocks.contains(Block.getBlockById(Integer.valueOf(args[2])))) {
                    XRayCmd.wurst.chat.error("\"" + args[2] + "\" is already in your X-Ray blocks list.");
                    return;
                }
                XRayMod.xrayBlocks.add(Block.getBlockById(Integer.valueOf(args[2])));
                XRayCmd.wurst.files.saveXRayBlocks();
                XRayCmd.wurst.chat.message("Added block " + args[2] + ".");
                XRayCmd.mc.renderGlobal.loadRenderers();
            } else if (args[1].equalsIgnoreCase("name")) {
                int newID = Block.getIdFromBlock(Block.getBlockFromName(args[2]));
                if (newID == -1) {
                    XRayCmd.wurst.chat.message("The block \"" + args[1] + "\" could not be found.");
                    return;
                }
                XRayMod.xrayBlocks.add(Block.getBlockById(newID));
                XRayCmd.wurst.files.saveXRayBlocks();
                XRayCmd.wurst.chat.message("Added block " + newID + " (\"" + args[2] + "\").");
                XRayCmd.mc.renderGlobal.loadRenderers();
            } else {
                this.syntaxError();
            }
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (args[1].equalsIgnoreCase("id") && MiscUtils.isInteger(args[2])) {
                int i = 0;
                while (i < XRayMod.xrayBlocks.size()) {
                    if (Integer.toString(Block.getIdFromBlock(XRayMod.xrayBlocks.get(i))).toLowerCase().equals(args[2].toLowerCase())) {
                        XRayMod.xrayBlocks.remove(i);
                        XRayCmd.wurst.files.saveXRayBlocks();
                        XRayCmd.wurst.chat.message("Removed block " + args[2] + ".");
                        XRayCmd.mc.renderGlobal.loadRenderers();
                        return;
                    }
                    ++i;
                }
                XRayCmd.wurst.chat.error("Block " + args[2] + " is not in your X-Ray blocks list.");
            } else if (args[1].equalsIgnoreCase("name")) {
                int newID = Block.getIdFromBlock(Block.getBlockFromName(args[2]));
                if (newID == -1) {
                    XRayCmd.wurst.chat.message("The block \"" + args[2] + "\" could not be found.");
                    return;
                }
                int i = 0;
                while (i < XRayMod.xrayBlocks.size()) {
                    if (Block.getIdFromBlock(XRayMod.xrayBlocks.get(i)) == newID) {
                        XRayMod.xrayBlocks.remove(i);
                        XRayCmd.wurst.files.saveXRayBlocks();
                        XRayCmd.wurst.chat.message("Removed block " + newID + " (\"" + args[2] + "\").");
                        XRayCmd.mc.renderGlobal.loadRenderers();
                        return;
                    }
                    ++i;
                }
                XRayCmd.wurst.chat.error("Block " + newID + " (\"" + args[2] + "\") is not in your X-Ray blocks list.");
            } else {
                this.syntaxError();
            }
        } else {
            this.syntaxError();
        }
    }
}

