/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui.main;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import tk.wurst_client.WurstClient;
import tk.wurst_client.gui.main.GuiWurstMainMenu;
import tk.wurst_client.utils.MiscUtils;

public class GuiMessage
extends GuiScreen {
    private String title;
    private String body;
    private JsonObject buttons;
    private String cancel;

    public GuiMessage(JsonObject json) {
        this.title = json.get("title").getAsString();
        this.body = json.get("body").getAsString();
        this.buttons = json.get("buttons").getAsJsonObject();
        this.cancel = json.get("cancel").getAsString();
    }

    @Override
    public void initGui() {
        int i = 0;
        for (Map.Entry entry : this.buttons.entrySet()) {
            this.buttonList.add(new GuiButton(i, this.width / 2 - 100, this.height / 3 * 2 + i * 24, 200, 20, (String)entry.getKey()));
            ++i;
        }
        if (this.cancel.equals("allowed") || this.cancel.equals("prompt")) {
            this.buttonList.add(new GuiButton(i, this.width / 2 - 50, this.height / 3 * 2 + i * 24, 100, 20, "Cancel"));
        }
        WurstClient.INSTANCE.analytics.trackPageView("/message/v3.0", this.title);
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.id == this.buttons.entrySet().size()) {
            if (this.cancel.equals("allowed")) {
                this.mc.displayGuiScreen(new GuiWurstMainMenu());
            } else if (this.cancel.equals("prompt")) {
                this.mc.displayGuiScreen(new GuiYesNo(this, "Are you sure you want to cancel?", "", 0));
            }
        } else {
            MiscUtils.openLink(this.buttons.get(button.displayString).getAsString());
            WurstClient.INSTANCE.analytics.trackEvent("message", "click", "v3.0", button.id);
        }
    }

    @Override
    public void confirmClicked(boolean result, int id) {
        super.confirmClicked(result, id);
        if (result) {
            this.mc.displayGuiScreen(new GuiWurstMainMenu());
            WurstClient.INSTANCE.analytics.trackEvent("message", "cancel", "v3.0");
        } else {
            this.mc.displayGuiScreen(this);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, this.height / 4, -1);
        int i = 0;
        String[] stringArray = this.body.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.drawCenteredString(this.fontRendererObj, line, this.width / 2, this.height / 4 + 16 + i * 12, -1);
            ++i;
            ++n2;
        }
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

