/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui.main;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.util.xml.XMLElement;
import org.newdawn.slick.util.xml.XMLElementList;
import org.newdawn.slick.util.xml.XMLParser;
import tk.wurst_client.WurstClient;
import tk.wurst_client.gui.alts.GuiAlts;
import tk.wurst_client.gui.main.GuiMessage;
import tk.wurst_client.utils.JsonUtils;
import tk.wurst_client.utils.MiscUtils;

public class GuiWurstMainMenu
extends GuiMainMenu {
    private static final ResourceLocation title = new ResourceLocation("wurst/wurst_380.png");
    private static final ResourceLocation santaHat = new ResourceLocation("wurst/santa_hat.png");
    private XMLElementList news;
    private String newsTicker;
    private int newsWidth;
    private String noticeText = "";
    private String noticeLink = "https://www.wurst-client.tk/minecraft-1-9/";
    private int noticeWidth2;
    private int noticeWidth1;
    private int noticeX1;
    private int noticeY1;
    private int noticeX2;
    private int noticeY2;

    public GuiWurstMainMenu() {
        if (WurstClient.INSTANCE.options.wurstNews) {
            this.downloadWurstNews();
        }
        WurstClient.INSTANCE.analytics.trackPageView("/", "Main Menu");
    }

    private void downloadWurstNews() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpsURLConnection connection = (HttpsURLConnection)new URL("https://www.wurst-client.tk/news/feed.xml").openConnection();
                    connection.connect();
                    XMLElement xml = new XMLParser().parse("", connection.getInputStream());
                    GuiWurstMainMenu.this.news = xml.getChildrenByName("channel").get(0).getChildrenByName("item");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @Override
    public void initGui() {
        super.initGui();
        int i = 3;
        while (i <= 5) {
            ((GuiButton)this.buttonList.get((int)i)).yPosition = Math.min(((GuiButton)this.buttonList.get((int)i)).yPosition, this.height - 56);
            ++i;
        }
        this.noticeWidth1 = this.fontRendererObj.getStringWidth(this.noticeText);
        this.noticeWidth2 = this.fontRendererObj.getStringWidth(GuiMainMenu.field_96138_a);
        int noticeWidth = Math.max(this.noticeWidth1, this.noticeWidth2);
        this.noticeX1 = (this.width - noticeWidth) / 2;
        this.noticeY1 = ((GuiButton)this.buttonList.get((int)0)).yPosition - 24;
        this.noticeX2 = this.noticeX1 + noticeWidth;
        this.noticeY2 = this.noticeY1 + 24;
        this.newsTicker = "";
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (GuiWurstMainMenu.this.news == null) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                try {
                    int i = 0;
                    while (i < GuiWurstMainMenu.this.news.size()) {
                        GuiWurstMainMenu guiWurstMainMenu = GuiWurstMainMenu.this;
                        guiWurstMainMenu.newsTicker = String.valueOf(guiWurstMainMenu.newsTicker) + GuiWurstMainMenu.this.news.get(i).getChildrenByName("title").get(0).getContent() + "\u00a7e+++\u00a7r";
                        ++i;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                GuiWurstMainMenu.this.newsWidth = GuiWurstMainMenu.this.fontRendererObj.getStringWidth(GuiWurstMainMenu.this.newsTicker);
                if (GuiWurstMainMenu.this.newsWidth % 50 == 0) {
                    GuiWurstMainMenu guiWurstMainMenu = GuiWurstMainMenu.this;
                    guiWurstMainMenu.newsWidth = guiWurstMainMenu.newsWidth + 1;
                }
                while (GuiWurstMainMenu.this.fontRendererObj.getStringWidth(GuiWurstMainMenu.this.newsTicker) < Math.max(GuiWurstMainMenu.this.width * 2, GuiWurstMainMenu.this.newsWidth * 2) && !GuiWurstMainMenu.this.newsTicker.isEmpty()) {
                    GuiWurstMainMenu guiWurstMainMenu = GuiWurstMainMenu.this;
                    guiWurstMainMenu.newsTicker = String.valueOf(guiWurstMainMenu.newsTicker) + GuiWurstMainMenu.this.newsTicker;
                }
            }
        }).start();
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        super.actionPerformed(button);
        switch (button.id) {
            case 3: {
                this.mc.displayGuiScreen(new GuiAlts(this));
            }
        }
    }

    @Override
    public void confirmClicked(boolean result, int id) {
        super.confirmClicked(result, id);
        if (id == 64) {
            if (result) {
                WurstClient.INSTANCE.analytics.trackEvent("changelog", "go play");
            } else {
                MiscUtils.openLink("https://www.wurst-client.tk/changelog/");
                WurstClient.INSTANCE.analytics.trackEvent("changelog", "view changelog");
            }
            this.mc.displayGuiScreen(this);
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (WurstClient.INSTANCE.startupMessageDisabled) {
            return;
        }
        if (WurstClient.INSTANCE.updater.isOutdated()) {
            WurstClient.INSTANCE.analytics.trackEvent("updater", "update to v" + WurstClient.INSTANCE.updater.getLatestVersion(), "from " + WurstClient.INSTANCE.updater.getCurrentVersion());
            WurstClient.INSTANCE.updater.update();
            WurstClient.INSTANCE.startupMessageDisabled = true;
        }
        if (WurstClient.INSTANCE.startupMessageDisabled) {
            return;
        }
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL("https://www.wurst-client.tk/api/v1/messages.json").openConnection();
            connection.connect();
            JsonObject json = JsonUtils.jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8")).getAsJsonObject();
            if (json.get("3.0") != null) {
                System.out.println("Emergency message found!");
                this.mc.displayGuiScreen(new GuiMessage(json.get("3.0").getAsJsonObject()));
                WurstClient.INSTANCE.startupMessageDisabled = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (WurstClient.INSTANCE.startupMessageDisabled) {
            return;
        }
        if (!"3.0".equals(WurstClient.INSTANCE.options.lastLaunchedVersion)) {
            this.mc.displayGuiScreen(new GuiYesNo(this, "Successfully updated to Wurst v3.0", "", "Go Play", "View Changelog", 64));
            WurstClient.INSTANCE.options.lastLaunchedVersion = "3.0";
            WurstClient.INSTANCE.files.saveOptions();
        }
        WurstClient.INSTANCE.startupMessageDisabled = true;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.disableAlpha();
        this.renderSkybox(mouseX, mouseY, partialTicks);
        GlStateManager.enableAlpha();
        this.drawGradientRect(0, 0, this.width, this.height, -2130706433, 0xFFFFFF);
        this.drawGradientRect(0, 0, this.width, this.height, 0, Integer.MIN_VALUE);
        this.mc.getTextureManager().bindTexture(title);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int x = this.width / 2 - 128;
        int y = 36;
        int w = 256;
        int h = 64;
        float fw = 256.0f;
        float fh = 64.0f;
        float u = 0.0f;
        float v = 0.0f;
        if (GuiMainMenu.splashText.equals("umop-apisdn!")) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width), (float)(-h - 60), (float)0.0f);
        }
        GuiWurstMainMenu.drawModalRectWithCustomSizedTexture(x, y, u, v, w, h, fw, fh);
        if (Calendar.getInstance().get(2) == 11) {
            this.mc.getTextureManager().bindTexture(santaHat);
            x += 112;
            y -= 36;
            h = 48;
            w = 48;
            fw = 48.0f;
            fh = 48.0f;
            u = 0.0f;
            v = 0.0f;
            GuiWurstMainMenu.drawModalRectWithCustomSizedTexture(x, y, u, v, w, h, fw, fh);
        }
        if (GuiMainMenu.splashText.equals("umop-apisdn!")) {
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width), (float)(-h - 60), (float)0.0f);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate(this.width / 2 + 90, 72.0f, 0.0f);
        GlStateManager.rotate(-20.0f, 0.0f, 0.0f, 1.0f);
        float splashScale = 1.8f - MathHelper.abs(MathHelper.sin((float)(Minecraft.getSystemTime() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f);
        splashScale = splashScale * 100.0f / (float)(this.fontRendererObj.getStringWidth(splashText) + 32);
        GlStateManager.scale(splashScale, splashScale, splashScale);
        this.drawCenteredString(this.fontRendererObj, splashText, 0, 0, -256);
        GlStateManager.popMatrix();
        String vMinecraft = "Minecraft 1.9";
        String cMinecraft1 = "Copyright Mojang AB";
        String cMinecraft2 = "Do not distribute!";
        this.drawString(this.fontRendererObj, vMinecraft, this.width - this.fontRendererObj.getStringWidth(vMinecraft) - 8, 8, 0xFFFFFF);
        this.drawString(this.fontRendererObj, cMinecraft1, this.width - this.fontRendererObj.getStringWidth(cMinecraft1) - 8, 18, 0xFFFFFF);
        this.drawString(this.fontRendererObj, cMinecraft2, this.width - this.fontRendererObj.getStringWidth(cMinecraft2) - 8, 28, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "Wurst Client 3.0" + (WurstClient.INSTANCE.updater.isOutdated() ? " (outdated)" : ""), 8, 8, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "Copyright Alexander01998", 8, 18, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "All rights reserved.", 8, 28, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "\u00a7nwww.Wurst-Client.tk", this.width / 2, this.height - 26, 0xFFFFFF);
        for (Object button : this.buttonList) {
            ((GuiButton)button).drawButton(this.mc, mouseX, mouseY);
        }
        if (!this.newsTicker.isEmpty() && this.newsWidth != 0) {
            this.drawString(this.fontRendererObj, this.newsTicker, -((int)(Minecraft.getSystemTime() / 50L % (long)this.newsWidth)), this.height - 10, -1);
        }
        int i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            if (button.isMouseOver()) {
                ArrayList<String> tooltip = new ArrayList<String>();
                switch (button.id) {
                    case 20: {
                        tooltip.add("Wurst YouTube Channel");
                        break;
                    }
                    case 21: {
                        tooltip.add("Wurst Twitter Account");
                        break;
                    }
                    case 22: {
                        tooltip.add("Wurst Google+ Page");
                        break;
                    }
                    case 23: {
                        tooltip.add("Wurst Source Code");
                        break;
                    }
                    case 24: {
                        tooltip.add("Wurst Feedback");
                        break;
                    }
                    case 25: {
                        tooltip.add("Wurst Merchandise");
                    }
                }
                this.drawHoveringText(tooltip, mouseX, mouseY);
                break;
            }
            ++i;
        }
        if (this.noticeText != null && this.noticeText.length() > 0) {
            GuiWurstMainMenu.drawRect(this.noticeX1 - 2, this.noticeY1 - 2, this.noticeX2 + 2, this.noticeY2 - 1, 0x55200000);
            this.drawString(this.fontRendererObj, this.noticeText, this.noticeX1, this.noticeY1, -1);
            this.drawString(this.fontRendererObj, GuiMainMenu.field_96138_a, (this.width - this.noticeWidth2) / 2, ((GuiButton)this.buttonList.get((int)0)).yPosition - 12, -1);
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int linkWidth = this.fontRendererObj.getStringWidth("\u00a7nwww.Wurst-Client.tk");
        if (mouseButton == 0 && mouseY >= this.height - 26 && mouseY < this.height - 16 && mouseX > this.width / 2 - linkWidth / 2 && mouseX < this.width / 2 + linkWidth / 2) {
            MiscUtils.openLink("https://www.Wurst-Client.tk/");
            WurstClient.INSTANCE.analytics.trackPageView("/wurst-client-dot-tk", "www.Wurst-Client.tk");
        }
        if (this.news != null && mouseButton == 0 && mouseY >= this.height - 10) {
            MiscUtils.openLink("https://www.wurst-client.tk/news");
            WurstClient.INSTANCE.analytics.trackPageView("/news", "Wurst News");
        }
        if (this.noticeText.length() > 0 && mouseX >= this.noticeX1 && mouseX <= this.noticeX2 && mouseY >= this.noticeY1 && mouseY <= this.noticeY2) {
            MiscUtils.openLink(this.noticeLink);
        }
    }
}

