/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui.target;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import tk.wurst_client.WurstClient;
import tk.wurst_client.navigator.settings.ColorsSetting;

public class GuiTeamSettings
extends GuiScreen {
    private GuiScreen prevMenu;

    public GuiTeamSettings(GuiScreen prevMenu) {
        this.prevMenu = prevMenu;
        WurstClient.INSTANCE.analytics.trackPageView("/team-settings", "Team Settings");
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        String[] colors = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        int i = 0;
        while (i < 16) {
            int offsetX = -22;
            switch (i % 4) {
                case 3: {
                    offsetX = 26;
                    break;
                }
                case 2: {
                    offsetX = 2;
                    break;
                }
                case 0: {
                    offsetX = -46;
                }
            }
            int offsetY = 72;
            switch (i % 16 / 4) {
                case 2: {
                    offsetY = 48;
                    break;
                }
                case 1: {
                    offsetY = 24;
                    break;
                }
                case 0: {
                    offsetY = 0;
                }
            }
            this.buttonList.add(new TeamColorButton(i, this.width / 2 + offsetX, this.height / 3 + offsetY, "\u00a7" + colors[i] + colors[i]));
            ++i;
        }
        boolean[] team_colors = WurstClient.INSTANCE.special.targetSpf.teamColors.getSelected();
        int i2 = 0;
        while (i2 < 16) {
            ((TeamColorButton)this.buttonList.get(i2)).setFakeHover(team_colors[i2]);
            ++i2;
        }
        this.buttonList.add(new GuiButton(16, this.width / 2 - 46, this.height / 3 + 96, 44, 20, "All On"));
        this.buttonList.add(new GuiButton(17, this.width / 2 + 2, this.height / 3 + 96, 44, 20, "All Off"));
        this.buttonList.add(new GuiButton(18, this.width / 2 - 100, this.height / 3 + 120, 200, 20, "Done"));
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (!button.enabled) {
            return;
        }
        if (button.id == 18) {
            Minecraft.getMinecraft().displayGuiScreen(this.prevMenu);
            WurstClient.INSTANCE.analytics.trackEvent("team settings", "done");
        } else {
            ColorsSetting teamColors = WurstClient.INSTANCE.special.targetSpf.teamColors;
            switch (button.id) {
                case 16: {
                    int i = 0;
                    while (i < 16) {
                        teamColors.setSelected(i, true);
                        ((TeamColorButton)this.buttonList.get(i)).setFakeHover(true);
                        ++i;
                    }
                    WurstClient.INSTANCE.analytics.trackEvent("team settings", "all on");
                    break;
                }
                case 17: {
                    int i = 0;
                    while (i < 16) {
                        teamColors.setSelected(i, false);
                        ((TeamColorButton)this.buttonList.get(i)).setFakeHover(false);
                        ++i;
                    }
                    WurstClient.INSTANCE.analytics.trackEvent("team settings", "all off");
                    break;
                }
                default: {
                    boolean onOff = !teamColors.getSelected()[button.id];
                    teamColors.setSelected(button.id, onOff);
                    ((TeamColorButton)this.buttonList.get(button.id)).setFakeHover(onOff);
                    WurstClient.INSTANCE.analytics.trackEvent("team settings", "toggle", onOff ? "on" : "off", button.id);
                }
            }
            WurstClient.INSTANCE.files.saveOptions();
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, "Team Settings", this.width / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "Target all entities with the following", this.width / 2, this.height / 3 - 30, 0xA0A0A0);
        this.drawCenteredString(this.fontRendererObj, "color(s) in their name:", this.width / 2, this.height / 3 - 20, 0xA0A0A0);
        ArrayList<String> tooltip = new ArrayList<String>();
        int i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            button.drawButton(this.mc, mouseX, mouseY);
            if (button.isMouseOver()) {
                switch (button.id) {
                    case 0: {
                        tooltip.add("black");
                        break;
                    }
                    case 1: {
                        tooltip.add("dark blue");
                        break;
                    }
                    case 2: {
                        tooltip.add("dark green");
                        break;
                    }
                    case 3: {
                        tooltip.add("dark aqua");
                        break;
                    }
                    case 4: {
                        tooltip.add("dark red");
                        break;
                    }
                    case 5: {
                        tooltip.add("dark purple");
                        break;
                    }
                    case 6: {
                        tooltip.add("gold");
                        break;
                    }
                    case 7: {
                        tooltip.add("gray");
                        break;
                    }
                    case 8: {
                        tooltip.add("dark gray");
                        break;
                    }
                    case 9: {
                        tooltip.add("blue");
                        break;
                    }
                    case 10: {
                        tooltip.add("green");
                        break;
                    }
                    case 11: {
                        tooltip.add("aqua");
                        break;
                    }
                    case 12: {
                        tooltip.add("red");
                        break;
                    }
                    case 13: {
                        tooltip.add("light purple");
                        break;
                    }
                    case 14: {
                        tooltip.add("yellow");
                        break;
                    }
                    case 15: {
                        tooltip.add("white");
                    }
                }
            }
            ++i;
        }
        this.drawHoveringText(tooltip, mouseX, mouseY);
    }

    public class TeamColorButton
    extends GuiButton {
        private boolean fakeHover;

        public TeamColorButton(int buttonId, int x, int y, String buttonText) {
            super(buttonId, x, y, 20, 20, buttonText);
        }

        public void setFakeHover(boolean fakeHover) {
            this.fakeHover = fakeHover;
        }

        @Override
        protected int getHoverState(boolean mouseOver) {
            return this.fakeHover ? super.getHoverState(mouseOver) : 0;
        }
    }
}

