/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.hooks;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import tk.wurst_client.bot.WurstBot;

public class FrameHook {
    private static JFrame frame;

    public static void createFrame(DefaultResourcePack mcDefaultResourcePack, Logger logger) throws LWJGLException {
        block7: {
            if (!FrameHook.isAutoMaximize() && !WurstBot.isEnabled()) {
                return;
            }
            frame = new JFrame("Minecraft 1.9");
            Canvas canvas = new Canvas();
            canvas.setBackground(new Color(16, 16, 16));
            Display.setParent((Canvas)canvas);
            Minecraft mc = Minecraft.getMinecraft();
            canvas.setSize(mc.displayWidth, mc.displayHeight);
            frame.add(canvas);
            frame.setDefaultCloseOperation(3);
            frame.pack();
            frame.setLocationRelativeTo(null);
            InputStream icon16 = null;
            InputStream icon32 = null;
            try {
                try {
                    icon16 = mcDefaultResourcePack.getInputStreamAssets(new ResourceLocation("icons/icon_16x16.png"));
                    icon32 = mcDefaultResourcePack.getInputStreamAssets(new ResourceLocation("icons/icon_32x32.png"));
                    ArrayList<BufferedImage> icons = new ArrayList<BufferedImage>();
                    icons.add(ImageIO.read(icon16));
                    icons.add(ImageIO.read(icon32));
                    frame.setIconImages(icons);
                }
                catch (Exception e) {
                    logger.error("Couldn't set icon", (Throwable)e);
                    IOUtils.closeQuietly((InputStream)icon16);
                    IOUtils.closeQuietly(icon32);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(icon16);
                IOUtils.closeQuietly(icon32);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)icon16);
            IOUtils.closeQuietly((InputStream)icon32);
        }
        if (!WurstBot.isEnabled()) {
            frame.setVisible(true);
        }
    }

    private static boolean isAutoMaximize() {
        File autoMaximizeFile = new File(Minecraft.getMinecraft().mcDataDir + "/wurst/automaximize.json");
        boolean autoMaximizeEnabled = false;
        if (!autoMaximizeFile.exists()) {
            FrameHook.createAutoMaximizeFile(autoMaximizeFile);
        }
        try {
            BufferedReader load = new BufferedReader(new FileReader(autoMaximizeFile));
            String line = load.readLine();
            load.close();
            Minecraft.getMinecraft();
            autoMaximizeEnabled = line.equals("true") && !Minecraft.isRunningOnMac;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return autoMaximizeEnabled;
    }

    private static void createAutoMaximizeFile(File autoMaximizeFile) {
        try {
            if (!autoMaximizeFile.getParentFile().exists()) {
                autoMaximizeFile.getParentFile().mkdirs();
            }
            PrintWriter save = new PrintWriter(new FileWriter(autoMaximizeFile));
            save.println(Boolean.toString(!Minecraft.isRunningOnMac));
            save.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void maximize() {
        if (frame != null) {
            frame.setExtendedState(6);
        }
    }

    public static JFrame getFrame() {
        return frame;
    }
}

